/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.ImmutableIterator;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjIntHashMap<K>
implements Iterable<Entry<K>>,
Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final int noKeyValue;
    private final double loadFactor;
    private final EntryIterator iterator = new EntryIterator();
    private K[] keys;
    private int[] values;
    private int free;
    private int capacity;
    private int mask;

    public ObjIntHashMap() {
        this(8);
    }

    private ObjIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    private ObjIntHashMap(int initialCapacity, double loadFactor, int noKeyValue) {
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.noKeyValue = noKeyValue;
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        this.free = this.capacity = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, noEntryValue);
    }

    public int get(K key) {
        int index = key.hashCode() & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            return this.noKeyValue;
        }
        if (Unsafe.arrayGet(this.keys, index) == key || key.equals(Unsafe.arrayGet(this.keys, index))) {
            return this.values[index];
        }
        return this.probe(key, index);
    }

    public Iterable<Entry<K>> immutableIterator() {
        return new EntryIterator();
    }

    @Override
    @NotNull
    public Iterator<Entry<K>> iterator() {
        this.iterator.index = 0;
        return this.iterator;
    }

    public void put(K key, int value) {
        int index = key.hashCode() & this.mask;
        if (this.cantPutAt(index, key, value)) {
            this.probeInsert(key, index, value);
        }
    }

    public boolean putIfAbsent(K key, int value) {
        int index = key.hashCode() & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            this.keys[index] = key;
            this.values[index] = value;
            --this.free;
            if (this.free == 0) {
                this.rehash();
            }
            return true;
        }
        return Unsafe.arrayGet(this.keys, index) != key && !key.equals(Unsafe.arrayGet(this.keys, index)) && this.probeInsertIfAbsent(key, index, value);
    }

    public int size() {
        return this.capacity - this.free;
    }

    private boolean cantPutAt(int index, K key, int value) {
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            --this.free;
            if (this.free == 0) {
                this.rehash();
            }
            return false;
        }
        if (Unsafe.arrayGet(this.keys, index) == key || key.equals(Unsafe.arrayGet(this.keys, index))) {
            Unsafe.arrayPut(this.values, index, value);
            return false;
        }
        return true;
    }

    private int probe(K key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryValue) continue;
            return this.noKeyValue;
        } while (Unsafe.arrayGet(this.keys, index) != key && !key.equals(Unsafe.arrayGet(this.keys, index)));
        return Unsafe.arrayGet(this.values, index);
    }

    private void probeInsert(K key, int index, int value) {
        while (this.cantPutAt(index = index + 1 & this.mask, key, value)) {
        }
    }

    private boolean probeInsertIfAbsent(K key, int index, int value) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryValue) continue;
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            --this.free;
            if (this.free == 0) {
                this.rehash();
            }
            return true;
        } while (Unsafe.arrayGet(this.keys, index) != key && !key.equals(Unsafe.arrayGet(this.keys, index)));
        return false;
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        int[] oldValues = this.values;
        K[] oldKeys = this.keys;
        this.keys = new Object[newCapacity];
        this.values = new int[newCapacity];
        Arrays.fill(this.keys, noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == noEntryValue) continue;
            this.put(Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }

    public class EntryIterator
    implements ImmutableIterator<Entry<K>> {
        private final Entry<K> entry = new Entry();
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ObjIntHashMap.this.values.length && (Unsafe.arrayGet(ObjIntHashMap.this.keys, this.index) != noEntryValue || this.scan());
        }

        @Override
        public Entry<K> next() {
            this.entry.key = Unsafe.arrayGet(ObjIntHashMap.this.keys, this.index);
            this.entry.value = Unsafe.arrayGet(ObjIntHashMap.this.values, this.index++);
            return this.entry;
        }

        private boolean scan() {
            do {
                ++this.index;
            } while (this.index < ObjIntHashMap.this.values.length && Unsafe.arrayGet(ObjIntHashMap.this.keys, this.index) == noEntryValue);
            return this.index < ObjIntHashMap.this.values.length;
        }
    }

    public static class Entry<V> {
        public V key;
        public int value;
    }
}

