/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.Sinkable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import java.util.Arrays;
import java.util.Comparator;

public class ObjList<T>
implements Mutable,
Sinkable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private T[] buffer;
    private int pos = 0;

    public ObjList() {
        this.buffer = new Object[16];
    }

    public ObjList(int capacity) {
        this.buffer = new Object[capacity < 16 ? 16 : capacity];
    }

    public void add(T value) {
        this.ensureCapacity0(this.pos + 1);
        Unsafe.arrayPut(this.buffer, this.pos++, value);
    }

    public void addAll(ObjList<T> that) {
        int n = that.size();
        this.ensureCapacity0(this.pos + n);
        for (int i = 0; i < n; ++i) {
            Unsafe.arrayPut(this.buffer, this.pos++, that.getQuick(i));
        }
    }

    @Override
    public void clear() {
        this.pos = 0;
        Arrays.fill(this.buffer, null);
    }

    public void extendAndSet(int index, T value) {
        this.ensureCapacity0(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        Unsafe.arrayPut(this.buffer, index, value);
    }

    public T get(int index) {
        if (index < this.pos) {
            return Unsafe.arrayGet(this.buffer, index);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public T getAndSetQuick(int index, T value) {
        T v = Unsafe.arrayGet(this.buffer, index);
        Unsafe.arrayPut(this.buffer, index, value);
        return v;
    }

    public T getLast() {
        if (this.pos > 0) {
            return Unsafe.arrayGet(this.buffer, this.pos - 1);
        }
        return null;
    }

    public T getQuick(int index) {
        return Unsafe.arrayGet(this.buffer, index);
    }

    public T getQuiet(int index) {
        if (index < this.pos) {
            return Unsafe.arrayGet(this.buffer, index);
        }
        return null;
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            T o = this.getQuick(i);
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        return hashCode;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ObjList && this.equals((ObjList)that);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.setLength(0);
        b.append('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(this.getQuick(i));
        }
        b.append(']');
        return b.toString();
    }

    public int indexOf(Object o) {
        if (o == null) {
            return this.indexOfNull();
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (!o.equals(this.getQuick(i))) continue;
            return i;
        }
        return -1;
    }

    public void remove(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        Unsafe.arrayPut(this.buffer, --this.pos, null);
    }

    public int remove(Object o) {
        if (this.pos == 0) {
            return -1;
        }
        int index = this.indexOf(o);
        if (index > -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public void setAll(int capacity, T value) {
        this.ensureCapacity0(capacity);
        this.pos = capacity;
        Arrays.fill(this.buffer, value);
    }

    public void setPos(int capacity) {
        this.ensureCapacity0(capacity);
        this.pos = capacity;
    }

    public void setQuick(int index, T value) {
        Unsafe.arrayPut(this.buffer, index, value);
    }

    public int size() {
        return this.pos;
    }

    public void sort(Comparator<T> cmp) {
        Arrays.sort(this.buffer, 0, this.pos, cmp);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            T obj;
            if (i > 0) {
                sink.put(',');
            }
            if ((obj = this.getQuick(i)) instanceof Sinkable) {
                sink.put((Sinkable)obj);
                continue;
            }
            if (obj == null) {
                sink.put("null");
                continue;
            }
            sink.put(obj.toString());
        }
        sink.put(']');
    }

    private void ensureCapacity0(int capacity) {
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            Object[] buf = new Object[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    private boolean equals(ObjList that) {
        if (this.pos == that.pos) {
            int n = this.pos;
            for (int i = 0; i < n; ++i) {
                T lhs = this.getQuick(i);
                if (lhs == null) {
                    return that.getQuick(i) == null;
                }
                if (!lhs.equals(that.getQuick(i))) continue;
                return true;
            }
        }
        return false;
    }

    private int indexOfNull() {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (null != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }
}

