/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.ImmutableIterator;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjObjHashMap<K, V>
implements Iterable<Entry<K, V>>,
Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final double loadFactor;
    private final EntryIterator iterator = new EntryIterator();
    private K[] keys;
    private V[] values;
    private int free;
    private int capacity;
    private int mask;

    public ObjObjHashMap() {
        this(8);
    }

    public ObjObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private ObjObjHashMap(int initialCapacity, double loadFactor) {
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.free = this.capacity = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, noEntryValue);
    }

    public V get(K key) {
        return this.getAt(this.keyIndex(key));
    }

    public int keyIndex(K key) {
        int index = key.hashCode() & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            return index;
        }
        if (Unsafe.arrayGet(this.keys, index) == key || key.equals(Unsafe.arrayGet(this.keys, index))) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public V getAt(int index) {
        return index < 0 ? (V)Unsafe.arrayGet(this.values, -index - 1) : null;
    }

    public Iterable<Entry<K, V>> immutableIterator() {
        return new EntryIterator();
    }

    @Override
    @NotNull
    public Iterator<Entry<K, V>> iterator() {
        this.iterator.index = 0;
        return this.iterator;
    }

    public void put(K key, V value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, K key, V value) {
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, value);
        } else {
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    public V remove(K key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            V value = Unsafe.arrayGet(this.values, -index - 1);
            Unsafe.arrayPut(this.values, -index - 1, null);
            ++this.free;
            return value;
        }
        return null;
    }

    public int size() {
        return this.capacity - this.free;
    }

    private int probe(K key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryValue) continue;
            return index;
        } while (Unsafe.arrayGet(this.keys, index) != key && !key.equals(Unsafe.arrayGet(this.keys, index)));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        V[] oldValues = this.values;
        K[] oldKeys = this.keys;
        this.keys = new Object[newCapacity];
        this.values = new Object[newCapacity];
        Arrays.fill(this.keys, noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == noEntryValue) continue;
            this.put(Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }

    public class EntryIterator
    implements ImmutableIterator<Entry<K, V>> {
        private final Entry<K, V> entry = new Entry();
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ObjObjHashMap.this.values.length && (Unsafe.arrayGet(ObjObjHashMap.this.keys, this.index) != noEntryValue || this.scan());
        }

        @Override
        public Entry<K, V> next() {
            this.entry.key = ObjObjHashMap.this.keys[this.index];
            this.entry.value = ObjObjHashMap.this.values[this.index++];
            return this.entry;
        }

        private boolean scan() {
            do {
                ++this.index;
            } while (this.index < ObjObjHashMap.this.values.length && Unsafe.arrayGet(ObjObjHashMap.this.keys, this.index) == noEntryValue);
            return this.index < ObjObjHashMap.this.values.length;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;
    }
}

