/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import org.jetbrains.annotations.NotNull;

public class ObjectPool<T extends Mutable>
implements Mutable {
    private final ObjList<T> list;
    private final ObjectFactory<T> factory;
    private int pos = 0;
    private int size = 0;

    public ObjectPool(@NotNull ObjectFactory<T> factory, int size) {
        this.list = new ObjList(size);
        this.factory = factory;
        this.size = size;
        this.fill();
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public T next() {
        if (this.pos == this.size) {
            this.expand();
        }
        Mutable o = (Mutable)this.list.getQuick(this.pos++);
        o.clear();
        return (T)o;
    }

    private void expand() {
        this.fill();
        this.size <<= 1;
    }

    private void fill() {
        for (int i = 0; i < this.size; ++i) {
            this.list.add(this.factory.newInstance());
        }
    }
}

