/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.MemoryPages;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public class RedBlackTree
implements Mutable,
Closeable {
    private static final int BLOCK_SIZE = 33;
    private static final int O_LEFT = 8;
    private static final int O_RIGHT = 16;
    private static final int O_COLOUR = 24;
    private static final int O_REF = 25;
    private static final byte RED = 1;
    private static final byte BLACK = 0;
    private final MemoryPages mem;
    private final LongComparator comparator;
    private final LongIterator cursor = new LongIterator();
    private long root = -1L;

    public RedBlackTree(LongComparator comparator, int keyPageSize) {
        this.comparator = comparator;
        this.mem = new MemoryPages(keyPageSize);
    }

    public void add(long value) {
        long parent;
        long r;
        int cmp;
        if (this.root == -1L) {
            this.putParent(value);
            return;
        }
        this.comparator.setLeft(value);
        long p = this.root;
        do {
            parent = p;
        } while ((p = (cmp = this.comparator.compare(r = RedBlackTree.refOf(p))) <= 0 ? RedBlackTree.leftOf(p) : RedBlackTree.rightOf(p)) > -1L);
        p = this.allocateBlock();
        RedBlackTree.setParent(p, parent);
        RedBlackTree.setRef(p, value);
        if (cmp <= 0) {
            RedBlackTree.setLeft(parent, p);
        } else {
            RedBlackTree.setRight(parent, p);
        }
        this.fix(p);
    }

    @Override
    public void clear() {
        this.root = -1L;
        this.mem.clear();
    }

    @Override
    public void close() {
        this.mem.close();
    }

    public LongComparator getComparator() {
        return this.comparator;
    }

    public LongIterator iterator() {
        long p = this.root;
        if (p != -1L) {
            long l;
            while ((l = RedBlackTree.leftOf(p)) != -1L) {
                p = l;
            }
        }
        this.cursor.current = p;
        return this.cursor;
    }

    private static void setLeft(long blockAddress, long left) {
        Unsafe.getUnsafe().putLong(blockAddress + 8L, left);
    }

    private static long rightOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 16L);
    }

    private static long leftOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 8L);
    }

    private static void setParent(long blockAddress, long parent) {
        Unsafe.getUnsafe().putLong(blockAddress, parent);
    }

    private static long refOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 25L);
    }

    private static void setRef(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 25L, recRef);
    }

    private static void setRight(long blockAddress, long right) {
        Unsafe.getUnsafe().putLong(blockAddress + 16L, right);
    }

    private static long parentOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress);
    }

    private static long parent2Of(long blockAddress) {
        return RedBlackTree.parentOf(RedBlackTree.parentOf(blockAddress));
    }

    private static void setColor(long blockAddress, byte colour) {
        if (blockAddress == -1L) {
            return;
        }
        Unsafe.getUnsafe().putByte(blockAddress + 24L, colour);
    }

    private static byte colorOf(long blockAddress) {
        return blockAddress == -1L ? (byte)0 : Unsafe.getUnsafe().getByte(blockAddress + 24L);
    }

    private static long successor(long current) {
        long p = RedBlackTree.rightOf(current);
        if (p != -1L) {
            long l;
            while ((l = RedBlackTree.leftOf(p)) != -1L) {
                p = l;
            }
        } else {
            p = RedBlackTree.parentOf(current);
            long ch = current;
            while (p != -1L && ch == RedBlackTree.rightOf(p)) {
                ch = p;
                p = RedBlackTree.parentOf(p);
            }
        }
        return p;
    }

    private long allocateBlock() {
        long p = this.mem.allocate(33L);
        RedBlackTree.setLeft(p, -1L);
        RedBlackTree.setRight(p, -1L);
        RedBlackTree.setColor(p, (byte)0);
        return p;
    }

    private void fix(long x) {
        RedBlackTree.setColor(x, (byte)1);
        while (x != -1L && x != this.root && RedBlackTree.colorOf(RedBlackTree.parentOf(x)) == 1) {
            long y;
            if (RedBlackTree.parentOf(x) == RedBlackTree.leftOf(RedBlackTree.parent2Of(x))) {
                y = RedBlackTree.rightOf(RedBlackTree.parent2Of(x));
                if (RedBlackTree.colorOf(y) == 1) {
                    RedBlackTree.setColor(RedBlackTree.parentOf(x), (byte)0);
                    RedBlackTree.setColor(y, (byte)0);
                    RedBlackTree.setColor(RedBlackTree.parent2Of(x), (byte)1);
                    x = RedBlackTree.parent2Of(x);
                    continue;
                }
                if (x == RedBlackTree.rightOf(RedBlackTree.parentOf(x))) {
                    x = RedBlackTree.parentOf(x);
                    this.rotateLeft(x);
                }
                RedBlackTree.setColor(RedBlackTree.parentOf(x), (byte)0);
                RedBlackTree.setColor(RedBlackTree.parent2Of(x), (byte)1);
                this.rotateRight(RedBlackTree.parent2Of(x));
                continue;
            }
            y = RedBlackTree.leftOf(RedBlackTree.parent2Of(x));
            if (RedBlackTree.colorOf(y) == 1) {
                RedBlackTree.setColor(RedBlackTree.parentOf(x), (byte)0);
                RedBlackTree.setColor(y, (byte)0);
                RedBlackTree.setColor(RedBlackTree.parent2Of(x), (byte)1);
                x = RedBlackTree.parent2Of(x);
                continue;
            }
            if (x == RedBlackTree.leftOf(RedBlackTree.parentOf(x))) {
                x = RedBlackTree.parentOf(x);
                this.rotateRight(x);
            }
            RedBlackTree.setColor(RedBlackTree.parentOf(x), (byte)0);
            RedBlackTree.setColor(RedBlackTree.parent2Of(x), (byte)1);
            this.rotateLeft(RedBlackTree.parent2Of(x));
        }
        RedBlackTree.setColor(this.root, (byte)0);
    }

    private void putParent(long value) {
        this.root = this.allocateBlock();
        RedBlackTree.setRef(this.root, value);
        RedBlackTree.setParent(this.root, -1L);
        RedBlackTree.setLeft(this.root, -1L);
        RedBlackTree.setRight(this.root, -1L);
    }

    private void rotateLeft(long p) {
        if (p != -1L) {
            long r = RedBlackTree.rightOf(p);
            RedBlackTree.setRight(p, RedBlackTree.leftOf(r));
            if (RedBlackTree.leftOf(r) != -1L) {
                RedBlackTree.setParent(RedBlackTree.leftOf(r), p);
            }
            RedBlackTree.setParent(r, RedBlackTree.parentOf(p));
            if (RedBlackTree.parentOf(p) == -1L) {
                this.root = r;
            } else if (RedBlackTree.leftOf(RedBlackTree.parentOf(p)) == p) {
                RedBlackTree.setLeft(RedBlackTree.parentOf(p), r);
            } else {
                RedBlackTree.setRight(RedBlackTree.parentOf(p), r);
            }
            RedBlackTree.setLeft(r, p);
            RedBlackTree.setParent(p, r);
        }
    }

    private void rotateRight(long p) {
        if (p != -1L) {
            long l = RedBlackTree.leftOf(p);
            RedBlackTree.setLeft(p, RedBlackTree.rightOf(l));
            if (RedBlackTree.rightOf(l) != -1L) {
                RedBlackTree.setParent(RedBlackTree.rightOf(l), p);
            }
            RedBlackTree.setParent(l, RedBlackTree.parentOf(p));
            if (RedBlackTree.parentOf(p) == -1L) {
                this.root = l;
            } else if (RedBlackTree.rightOf(RedBlackTree.parentOf(p)) == p) {
                RedBlackTree.setRight(RedBlackTree.parentOf(p), l);
            } else {
                RedBlackTree.setLeft(RedBlackTree.parentOf(p), l);
            }
            RedBlackTree.setRight(l, p);
            RedBlackTree.setParent(p, l);
        }
    }

    public static class LongIterator {
        private long current;

        public boolean hasNext() {
            return this.current != -1L;
        }

        public long next() {
            long result = RedBlackTree.refOf(this.current);
            this.current = RedBlackTree.successor(this.current);
            return result;
        }
    }

    public static interface LongComparator {
        public int compare(long var1);

        public void setLeft(long var1);
    }
}

