/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.common.NumericException;
import com.questdb.std.Chars;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.Os;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateFormatCompiler;
import com.questdb.std.microtime.DateLocale;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.microtime.Dates;
import com.questdb.std.microtime.Interval;
import com.questdb.std.str.CharSink;

public class DateFormatUtils {
    public static final int HOUR_24 = 2;
    public static final int HOUR_PM = 1;
    public static final int HOUR_AM = 0;
    public static final DateFormat UTC_FORMAT;
    public static final DateFormat USEC_UTC_FORMAT;
    public static final String UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.SSSz";
    public static final DateLocale defaultLocale;
    private static final DateFormat HTTP_FORMAT;
    static long referenceYear;
    static int thisCenturyLimit;
    static int thisCenturyLow;
    static int prevCenturyLow;
    private static long newYear;

    public static void append0(CharSink sink, int val) {
        if (Math.abs(val) < 10) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append00(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0');
        } else if (v < 100) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append000(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0').put('0');
        } else if (v < 100) {
            sink.put('0').put('0');
        } else if (v < 1000) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void appendDateTime(CharSink sink, long micros) {
        if (micros == Long.MIN_VALUE) {
            return;
        }
        UTC_FORMAT.format(micros, defaultLocale, "Z", sink);
    }

    public static void appendDateTimeUSec(CharSink sink, long micros) {
        if (micros == Long.MIN_VALUE) {
            return;
        }
        USEC_UTC_FORMAT.format(micros, defaultLocale, "Z", sink);
    }

    public static void formatDashYYYYMMDD(CharSink sink, long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(millis, y, l);
        Numbers.append(sink, y);
        DateFormatUtils.append0(sink.put('-'), m);
        DateFormatUtils.append0(sink.put('-'), Dates.getDayOfMonth(millis, y, m, l));
    }

    public static void formatHTTP(CharSink sink, long millis) {
        HTTP_FORMAT.format(millis, defaultLocale, "GMT", sink);
    }

    public static void formatYYYYMM(CharSink sink, long millis) {
        int y = Dates.getYear(millis);
        int m = Dates.getMonthOfYear(millis, y, Dates.isLeapYear(y));
        Numbers.append(sink, y);
        DateFormatUtils.append0(sink.put('-'), m);
    }

    public static void formatYYYYMMDD(CharSink sink, long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(millis, y, l);
        Numbers.append(sink, y);
        DateFormatUtils.append0(sink, m);
        DateFormatUtils.append0(sink, Dates.getDayOfMonth(millis, y, m, l));
    }

    public static long getReferenceYear() {
        return referenceYear;
    }

    public static long parseDateTime(CharSequence seq) throws NumericException {
        return DateFormatUtils.parseDateTime(seq, 0, seq.length());
    }

    public static long parseDateTimeQuiet(CharSequence seq) {
        try {
            return DateFormatUtils.parseDateTime(seq, 0, seq.length());
        }
        catch (NumericException e) {
            return Long.MIN_VALUE;
        }
    }

    public static Interval parseInterval(CharSequence seq) throws NumericException {
        int lim = seq.length();
        int p = 0;
        if (lim < 4) {
            throw NumericException.INSTANCE;
        }
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Dates.isLeapYear(year);
        if (DateFormatUtils.checkLen(p, lim)) {
            DateFormatUtils.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            DateFormatUtils.checkRange(month, 1, 12);
            if (DateFormatUtils.checkLen(p, lim)) {
                DateFormatUtils.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                DateFormatUtils.checkRange(day, 1, Dates.getDaysPerMonth(month, l));
                if (DateFormatUtils.checkLen(p, lim)) {
                    DateFormatUtils.checkChar(seq, p++, lim, 'T');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    DateFormatUtils.checkRange(hour, 0, 23);
                    if (DateFormatUtils.checkLen(p, lim)) {
                        DateFormatUtils.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        DateFormatUtils.checkRange(min, 0, 59);
                        if (DateFormatUtils.checkLen(p, lim)) {
                            DateFormatUtils.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            DateFormatUtils.checkRange(sec, 0, 59);
                            if (p < lim) {
                                throw NumericException.INSTANCE;
                            }
                            return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L, Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + 999999L);
                        }
                        return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L, Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + 59000000L + 999999L);
                    }
                    return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L, Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + 3540000000L + 59000000L + 999999L);
                }
                return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L, Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
            }
            return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l), Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(Dates.getDaysPerMonth(month, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
        }
        return new Interval(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(1, l), Dates.yearMicros(year, l) + Dates.monthOfYearMicros(12, l) + (long)(Dates.getDaysPerMonth(12, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
    }

    public static void parseInterval(CharSequence seq, int pos, int lim, LongList out) throws NumericException {
        int len = lim - pos;
        int p = pos;
        if (len < 4) {
            throw NumericException.INSTANCE;
        }
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Dates.isLeapYear(year);
        if (DateFormatUtils.checkLen(p, len)) {
            DateFormatUtils.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            DateFormatUtils.checkRange(month, 1, 12);
            if (DateFormatUtils.checkLen(p, len)) {
                DateFormatUtils.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                DateFormatUtils.checkRange(day, 1, Dates.getDaysPerMonth(month, l));
                if (DateFormatUtils.checkLen(p, len)) {
                    DateFormatUtils.checkChar(seq, p++, lim, 'T');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    DateFormatUtils.checkRange(hour, 0, 23);
                    if (DateFormatUtils.checkLen(p, len)) {
                        DateFormatUtils.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        DateFormatUtils.checkRange(min, 0, 59);
                        if (DateFormatUtils.checkLen(p, len)) {
                            DateFormatUtils.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            DateFormatUtils.checkRange(sec, 0, 59);
                            if (p < len) {
                                throw NumericException.INSTANCE;
                            }
                            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L);
                            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + 99999L);
                        } else {
                            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L);
                            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + 59000000L + 99999L);
                        }
                    } else {
                        out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L);
                        out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + 3540000000L + 59000000L + 99999L);
                    }
                } else {
                    out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L);
                    out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 99999L);
                }
            } else {
                out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l));
                out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(month, l) + (long)(Dates.getDaysPerMonth(month, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 99999L);
            }
        } else {
            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(1, l));
            out.add(Dates.yearMicros(year, l) + Dates.monthOfYearMicros(12, l) + (long)(Dates.getDaysPerMonth(12, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 99999L);
        }
    }

    public static long tryParse(CharSequence s) throws NumericException {
        return DateFormatUtils.tryParse(s, 0, s.length());
    }

    public static long tryParse(CharSequence s, int lo, int lim) throws NumericException {
        return DateFormatUtils.parseDateTime(s, lo, lim);
    }

    public static void updateReferenceYear(long micros) {
        referenceYear = micros;
        int referenceYear = Dates.getYear(micros);
        int centuryOffset = referenceYear % 100;
        thisCenturyLimit = centuryOffset + 20;
        if (thisCenturyLimit > 100) {
            thisCenturyLimit %= 100;
            thisCenturyLow = referenceYear - centuryOffset + 100;
        } else {
            thisCenturyLow = referenceYear - centuryOffset;
        }
        prevCenturyLow = thisCenturyLow - 100;
        newYear = Dates.endOfYear(referenceYear);
    }

    static void appendAmPm(CharSink sink, int hour, DateLocale locale) {
        if (hour < 12) {
            sink.put(locale.getAMPM(0));
        } else {
            sink.put(locale.getAMPM(1));
        }
    }

    static void assertChar(char c, CharSequence in, int pos, int hi) throws NumericException {
        DateFormatUtils.assertRemaining(pos, hi);
        if (in.charAt(pos) != c) {
            throw NumericException.INSTANCE;
        }
    }

    static int assertString(CharSequence delimiter, int len, CharSequence in, int pos, int hi) throws NumericException {
        if (delimiter.charAt(0) == '\'' && delimiter.charAt(len - 1) == '\'') {
            DateFormatUtils.assertRemaining(pos + len - 3, hi);
            if (!Chars.equals(delimiter, 1, len - 1, in, pos, pos + len - 2)) {
                throw NumericException.INSTANCE;
            }
            return pos + len - 2;
        }
        DateFormatUtils.assertRemaining(pos + len - 1, hi);
        if (!Chars.equals(delimiter, in, pos, pos + len)) {
            throw NumericException.INSTANCE;
        }
        return pos + len;
    }

    static void assertRemaining(int pos, int hi) throws NumericException {
        if (pos < hi) {
            return;
        }
        throw NumericException.INSTANCE;
    }

    static void assertNoTail(int pos, int hi) throws NumericException {
        if (pos < hi) {
            throw NumericException.INSTANCE;
        }
    }

    static long compute(DateLocale locale, int era, int year, int month, int day, int hour, int minute, int second, int millis, int micros, int timezone, long offset, int hourType) throws NumericException {
        if (era == 0) {
            year = -(year - 1);
        }
        boolean leap = Dates.isLeapYear(year);
        if (month < 1 || month > 12) {
            throw NumericException.INSTANCE;
        }
        switch (hourType) {
            case 1: {
                hour += 12;
            }
            case 2: {
                if (hour >= 0 && hour <= 23) break;
                throw NumericException.INSTANCE;
            }
            default: {
                if (hour >= 0 && hour <= 11) break;
                throw NumericException.INSTANCE;
            }
        }
        if (day < 1 || day > Dates.getDaysPerMonth(month, leap)) {
            throw NumericException.INSTANCE;
        }
        if (minute < 0 || minute > 59) {
            throw NumericException.INSTANCE;
        }
        if (second < 0 || second > 59) {
            throw NumericException.INSTANCE;
        }
        long datetime = Dates.yearMicros(year, leap) + Dates.monthOfYearMicros(month, leap) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)minute * 60000000L + (long)second * 1000000L + (long)(millis * 1000) + (long)micros;
        if (timezone > -1) {
            datetime -= locale.getZoneRules(timezone).getOffset(datetime, year, leap);
        } else if (offset > Long.MIN_VALUE) {
            datetime -= offset;
        }
        return datetime;
    }

    static long parseYearGreedy(CharSequence in, int pos, int hi) throws NumericException {
        long l = Numbers.parseIntSafely(in, pos, hi);
        int len = Numbers.decodeLen(l);
        int year = len == 2 ? DateFormatUtils.adjustYear(Numbers.decodeInt(l)) : Numbers.decodeInt(l);
        return Numbers.encodeIntAndLen(year, len);
    }

    static int adjustYear(int year) {
        return (year < thisCenturyLimit ? thisCenturyLow : prevCenturyLow) + year;
    }

    static void appendHour12(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour);
        } else {
            sink.put(hour - 12);
        }
    }

    static void appendHour12Padded(CharSink sink, int hour) {
        if (hour < 12) {
            DateFormatUtils.append0(sink, hour);
        } else {
            DateFormatUtils.append0(sink, hour - 12);
        }
    }

    static void appendHour121Padded(CharSink sink, int hour) {
        if (hour < 12) {
            DateFormatUtils.append0(sink, hour + 1);
        } else {
            DateFormatUtils.append0(sink, hour - 11);
        }
    }

    static void appendHour121(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour + 1);
        } else {
            sink.put(hour - 11);
        }
    }

    static void appendEra(CharSink sink, int year, DateLocale locale) {
        if (year < 0) {
            sink.put(locale.getEra(0));
        } else {
            sink.put(locale.getEra(1));
        }
    }

    private static long parseDateTime(CharSequence seq, int lo, int lim) throws NumericException {
        return UTC_FORMAT.parse(seq, lo, lim, defaultLocale);
    }

    private static boolean checkLen(int p, int lim) throws NumericException {
        if (lim - p > 2) {
            return true;
        }
        if (lim <= p) {
            return false;
        }
        throw NumericException.INSTANCE;
    }

    private static void checkChar(CharSequence s, int p, int lim, char c) throws NumericException {
        if (p >= lim || s.charAt(p) != c) {
            throw NumericException.INSTANCE;
        }
    }

    private static void checkRange(int x, int min, int max) throws NumericException {
        if (x < min || x > max) {
            throw NumericException.INSTANCE;
        }
    }

    static {
        defaultLocale = DateLocaleFactory.INSTANCE.getDefaultDateLocale();
        DateFormatUtils.updateReferenceYear(Os.currentTimeMicros());
        DateFormatCompiler compiler = new DateFormatCompiler();
        UTC_FORMAT = compiler.compile(UTC_PATTERN);
        HTTP_FORMAT = compiler.compile("E, d MMM yyyy HH:mm:ss Z");
        USEC_UTC_FORMAT = compiler.compile("yyyy-MM-ddTHH:mm:ss.SSSNNNz");
    }
}

