/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.microtime;

import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.microtime.Dates;
import com.questdb.std.microtime.FixedTimeZoneRule;
import com.questdb.std.microtime.TimeZoneRules;
import com.questdb.std.microtime.TimeZoneRulesImpl;
import java.time.ZoneId;
import java.util.Map;

public class TimeZoneRuleFactory {
    public static final TimeZoneRuleFactory INSTANCE = new TimeZoneRuleFactory();
    private final CharSequenceIntHashMap ruleMap = new CharSequenceIntHashMap();
    private final ObjList<TimeZoneRules> ruleList = new ObjList();

    public TimeZoneRuleFactory() {
        int index = 0;
        for (String string : ZoneId.getAvailableZoneIds()) {
            this.ruleList.add(new TimeZoneRulesImpl(string, ZoneId.of(string).getRules()));
            this.ruleMap.put(string, index++);
        }
        for (Map.Entry entry : ZoneId.SHORT_IDS.entrySet()) {
            String key = (String)entry.getKey();
            String alias = (String)entry.getValue();
            int i = this.ruleMap.get(key);
            if (i != -1) continue;
            i = this.ruleMap.get(alias);
            if (i == -1) {
                long offset = Dates.parseOffset(alias, 0, alias.length());
                if (offset == Long.MIN_VALUE) continue;
                this.ruleList.add(new FixedTimeZoneRule(alias, Numbers.decodeInt(offset) * 1000));
                this.ruleMap.put(key, index++);
                continue;
            }
            this.ruleMap.put(key, i);
        }
    }

    public TimeZoneRules getTimeZoneRules(CharSequence id) {
        int index = this.ruleMap.get(id);
        if (index == -1) {
            return null;
        }
        return this.ruleList.getQuick(index);
    }

    public int getTimeZoneRulesIndex(CharSequence id) {
        return this.ruleMap.get(id);
    }

    public TimeZoneRules getTimeZoneRulesQuick(int index) {
        return this.ruleList.getQuick(index);
    }
}

