/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Chars;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.LPSZ;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public final class CharSequenceZ
extends AbstractCharSequence
implements Closeable,
LPSZ,
ByteSequence {
    private long ptr = 0L;
    private int capacity;
    private int len;

    public CharSequenceZ(CharSequence str) {
        int l = str.length();
        this.alloc(l);
        this.cpyz(str, l);
    }

    @Override
    public long address() {
        return this.ptr;
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Unsafe.free(this.ptr, this.capacity + 1);
            this.ptr = 0L;
        }
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return (char)this.byteAt(index);
    }

    public CharSequenceZ of(CharSequence str) {
        return this.of(str, str.length());
    }

    public CharSequenceZ of(CharSequence str, int len) {
        if (len >= this.capacity) {
            this.close();
            this.alloc(len);
        }
        this.cpyz(str, len);
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return Chars.toUtf8String(this);
    }

    private void alloc(int len) {
        this.capacity = len;
        this.ptr = Unsafe.malloc(this.capacity + 1);
    }

    private void cpyz(CharSequence str, int len) {
        Chars.strcpy(str, len, this.ptr);
        Unsafe.getUnsafe().putByte(this.ptr + (long)len, (byte)0);
        this.len = len;
    }
}

