/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.ObjList;
import com.questdb.std.str.AbstractCharSequence;

public class ConcatCharSequence
extends AbstractCharSequence {
    private final ObjList<CharSequence> delegates = new ObjList();
    private int len = -1;
    private CharSequence lastSeq;
    private int lastCharIndex = -1;
    private int lastSeqLen;
    private int lastSeqIndex;
    private int lastOffset;

    public void add(CharSequence cs) {
        if (cs == null) {
            return;
        }
        if (this.delegates.size() == 0) {
            this.lastSeq = cs;
            this.lastOffset = 0;
            this.lastSeqLen = cs.length();
            this.lastSeqIndex = 0;
        }
        this.delegates.add(cs);
    }

    public int computeLen() {
        int l = 0;
        int n = this.delegates.size();
        for (int i = 0; i < n; ++i) {
            CharSequence d = this.delegates.getQuick(i);
            if (d == this.lastSeq) {
                this.lastSeqLen = d.length();
            }
            l += d.length();
        }
        this.len = l;
        return this.len;
    }

    @Override
    public int length() {
        if (this.len > -1) {
            return this.len;
        }
        return this.computeLen();
    }

    @Override
    public char charAt(int index) {
        if (index == this.lastCharIndex + 1) {
            this.lastCharIndex = index;
            if (index - this.lastOffset < this.lastSeqLen) {
                return this.lastSeq.charAt(index - this.lastOffset);
            }
            return this.next(index);
        }
        return this.seek(index);
    }

    public void surroundWith(CharSequence left, CharSequence right) {
        if (this.delegates.size() > 0) {
            CharSequence delegate = this.delegates.get(0);
            this.delegates.setPos(3);
            this.delegates.extendAndSet(0, left);
            this.delegates.extendAndSet(1, delegate);
            this.delegates.extendAndSet(2, right);
        } else {
            this.delegates.setPos(2);
            this.delegates.extendAndSet(0, left);
            this.delegates.extendAndSet(1, right);
        }
        this.lastSeq = left;
        this.lastSeqLen = left.length();
    }

    private char next(int index) {
        this.lastOffset += this.lastSeqLen;
        do {
            ++this.lastSeqIndex;
            this.lastSeq = this.delegates.getQuick(this.lastSeqIndex);
            this.lastSeqLen = this.lastSeq.length();
        } while (this.lastSeqLen == 0);
        return this.lastSeq.charAt(index - this.lastOffset);
    }

    private char seek(int index) {
        int l = 0;
        int n = this.delegates.size();
        for (int i = 0; i < n; ++i) {
            CharSequence cs = this.delegates.getQuick(i);
            int len = cs.length();
            if (index < len + l) {
                this.lastSeq = cs;
                this.lastSeqLen = len;
                this.lastOffset = l;
                this.lastSeqIndex = i;
                this.lastCharIndex = index;
                return cs.charAt(index - l);
            }
            l += len;
        }
        throw new IndexOutOfBoundsException();
    }
}

