/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Misc;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import java.io.Closeable;
import java.io.IOException;

public class DelimitedCharSink
extends AbstractCharSink
implements CharSink,
Closeable {
    private static final String NULL = "";
    private final CharSink delegate;
    private final char delimiter;
    private final String eol;
    private boolean del = false;

    public DelimitedCharSink(CharSink delegate, char delimiter, String eol) {
        this.delegate = delegate;
        this.delimiter = delimiter;
        this.eol = eol;
    }

    @Override
    public void close() throws IOException {
        Misc.free(this.delegate);
    }

    public void eol() {
        this.delegate.put(this.eol);
        this.del = false;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public CharSink put(CharSequence cs) {
        this.delimiter();
        this.delegate.put(cs == null ? NULL : cs);
        return this;
    }

    @Override
    public CharSink put(char c) {
        this.delegate.put(c);
        return this;
    }

    @Override
    public CharSink put(int value) {
        this.delimiter();
        return super.put(value);
    }

    @Override
    public CharSink put(long value) {
        this.delimiter();
        return super.put(value);
    }

    @Override
    public CharSink putISODate(long value) {
        this.delimiter();
        return super.put(value);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private void delimiter() {
        if (this.del) {
            this.delegate.put(this.delimiter);
        } else {
            this.del = true;
        }
    }
}

