/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.DirectBytes;
import org.jetbrains.annotations.NotNull;

public class DirectByteCharSequence
extends AbstractCharSequence
implements Mutable,
ByteSequence,
DirectBytes {
    public static final Factory FACTORY = new Factory();
    private long lo;
    private long hi;

    @Override
    public long address() {
        return this.lo;
    }

    @Override
    public int byteLength() {
        return this.length();
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.lo + (long)index);
    }

    @Override
    public void clear() {
        this.hi = 0L;
        this.lo = 0L;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    @Override
    public int length() {
        return (int)(this.hi - this.lo);
    }

    @Override
    public char charAt(int index) {
        return (char)this.byteAt(index);
    }

    public void lshift(long delta) {
        this.lo -= delta;
        this.hi -= delta;
    }

    public DirectByteCharSequence of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        return this;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        DirectByteCharSequence seq = new DirectByteCharSequence();
        seq.lo = this.lo + (long)start;
        seq.hi = this.lo + (long)end;
        return seq;
    }

    @Override
    @NotNull
    public String toString() {
        return Chars.toUtf8String(this);
    }

    public static final class Factory
    implements ObjectFactory<DirectByteCharSequence> {
        @Override
        public DirectByteCharSequence newInstance() {
            return new DirectByteCharSequence();
        }
    }
}

