/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.DirectBytes;

public class DirectCharSequence
extends AbstractCharSequence
implements DirectBytes {
    private long lo;
    private long hi;
    private int len;

    @Override
    public long address() {
        return this.lo;
    }

    @Override
    public int byteLength() {
        return this.len * 2;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    @Override
    public int hashCode() {
        if (this.lo == this.hi) {
            return 0;
        }
        int h = 0;
        for (long p = this.lo; p < this.hi; p += 2L) {
            h = 31 * h + Unsafe.getUnsafe().getChar(p);
        }
        return h;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.lo + (long)(index << 1));
    }

    public DirectCharSequence of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        this.len = (int)((hi - lo) / 2L);
        return this;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        DirectCharSequence seq = new DirectCharSequence();
        seq.lo = this.lo + (long)start;
        seq.hi = this.lo + (long)end;
        return seq;
    }
}

