/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectBytes;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class DirectCharSink
extends AbstractCharSink
implements CharSequence,
Closeable,
Mutable,
DirectBytes {
    private long ptr;
    private int capacity;
    private long lo;
    private long hi;

    public DirectCharSink(int capacity) {
        this.ptr = Unsafe.malloc(capacity);
        this.capacity = capacity;
        this.lo = this.ptr;
        this.hi = this.ptr + (long)capacity;
    }

    @Override
    public long address() {
        return this.ptr;
    }

    @Override
    public int byteLength() {
        return (int)(this.lo - this.ptr);
    }

    @Override
    public void clear() {
        this.lo = this.ptr;
    }

    @Override
    public void close() {
        Unsafe.free(this.ptr, this.capacity);
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr) / 2;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + (long)(index * 2));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSink put(CharSequence cs) {
        int l = cs.length();
        int l2 = l * 2;
        if (this.lo + (long)l2 >= this.hi) {
            this.resize((int)Math.max((long)(this.capacity * 2), (this.lo - this.ptr + (long)l2) * 2L));
        }
        for (int i = 0; i < l; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)(i * 2), cs.charAt(i));
        }
        this.lo += (long)l2;
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.lo == this.hi) {
            this.resize(this.capacity * 2);
        }
        Unsafe.getUnsafe().putChar(this.lo, c);
        this.lo += 2L;
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private void resize(int cap) {
        long temp = Unsafe.malloc(cap);
        int len = (int)(this.lo - this.ptr);
        Unsafe.getUnsafe().copyMemory(this.ptr, temp, len);
        Unsafe.free(this.ptr, this.capacity);
        this.ptr = temp;
        this.capacity = cap;
        this.lo = this.ptr + (long)len;
        this.hi = this.ptr + (long)cap;
    }
}

