/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;

public class DirectUnboundedByteSink
extends AbstractCharSink {
    private final long address;
    private long _wptr;

    public DirectUnboundedByteSink(long address) {
        this.address = this._wptr = address;
    }

    public void clear(int len) {
        this._wptr = this.address + (long)len;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public CharSink put(CharSequence cs) {
        int len = cs.length();
        Chars.strcpy(cs, len, this._wptr);
        this._wptr += (long)len;
        return this;
    }

    @Override
    public CharSink put(char c) {
        Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
        return this;
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalBuilder();
        long hi = this._wptr;
        for (long p = this.address; p < hi; ++p) {
            b.put((char)Unsafe.getUnsafe().getByte(p));
        }
        return ((Object)b).toString();
    }
}

