/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileSink
extends AbstractCharSink
implements Closeable {
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private ByteBuffer buffer;
    private long pos;
    private long addr;
    private long limit;

    public FileSink(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.pos = 0L;
        this.limit = 0L;
        this.addr = 0L;
    }

    @Override
    public void close() throws IOException {
        ByteBuffers.release(this.buffer);
        if (this.addr > 0L && this.pos > 0L) {
            this.channel.truncate(this.pos - (this.limit - this.addr));
        }
        this.channel.close();
        this.raf.close();
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs == null) {
            return this;
        }
        int l = cs.length();
        for (int i = 0; i < l; ++i) {
            if (this.addr == this.limit) {
                this.map();
            }
            Unsafe.getUnsafe().putByte(this.addr++, (byte)cs.charAt(i));
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.addr == this.limit) {
            this.map();
        }
        Unsafe.getUnsafe().putByte(this.addr++, (byte)c);
        return this;
    }

    private void map() {
        if (this.buffer != null) {
            ByteBuffers.release(this.buffer);
        }
        try {
            this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, this.pos, ByteBuffers.getMaxMappedBufferSize(Long.MAX_VALUE));
            this.pos += (long)this.buffer.limit();
            this.addr = ByteBuffers.getAddress(this.buffer);
            this.limit = this.addr + (long)this.buffer.remaining();
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }
}

