/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.ByteBuffers;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class FlexBufferSink
extends AbstractCharSink
implements Closeable {
    WritableByteChannel channel;
    private ByteBuffer buffer;
    private int capacity;

    public FlexBufferSink(WritableByteChannel channel, int bufferSize) {
        this(bufferSize);
        this.channel = channel;
    }

    FlexBufferSink() {
        this(1024);
    }

    private FlexBufferSink(int capacity) {
        this.capacity = capacity;
        this.buffer = ByteBuffer.allocateDirect(this.capacity);
    }

    @Override
    public void close() throws IOException {
        this.free();
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs != null) {
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                this.put(cs.charAt(i));
            }
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (!this.buffer.hasRemaining()) {
            this.resize();
        }
        this.buffer.put((byte)c);
        return this;
    }

    private void free() {
        this.buffer = ByteBuffers.release(this.buffer);
    }

    private void resize() {
        ByteBuffer buf = ByteBuffer.allocateDirect(this.capacity <<= 1);
        this.buffer.flip();
        ByteBuffers.copy(this.buffer, buf);
        ByteBuffers.release(this.buffer);
        this.buffer = buf;
    }
}

