/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.str;

import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.LPSZ;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class Path
extends AbstractCharSink
implements Closeable,
LPSZ {
    private static final int OVERHEAD = 4;
    private long ptr = 0L;
    private long wptr;
    private int capacity;
    private int len;

    public Path() {
        this(128);
    }

    public Path(int capacity) {
        this.capacity = capacity;
        this.ptr = this.wptr = Unsafe.malloc(capacity + 1);
    }

    public Path $() {
        if (1L + (this.wptr - this.ptr) >= (long)this.capacity) {
            this.extend((int)(16L + (this.wptr - this.ptr)));
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)0);
        return this;
    }

    @Override
    public long address() {
        return this.ptr;
    }

    public Path chopZ() {
        this.trimTo(this.length());
        return this;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Unsafe.free(this.ptr, this.capacity + 1);
            this.ptr = 0L;
        }
    }

    public Path concat(CharSequence str) {
        return this.concat(str, 0, str.length());
    }

    @Override
    public char charAt(int index) {
        return (char)Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    public Path concat(long lpsz) {
        this.ensureSeparator();
        long p = lpsz;
        while (true) {
            int b;
            if (this.len + 4 >= this.capacity) {
                this.extend(this.len * 2 + 4);
            }
            if ((b = Unsafe.getUnsafe().getByte(p++)) == 0) break;
            Unsafe.getUnsafe().putByte(this.wptr, (byte)(b == 47 && Os.type == 3 ? 92 : b));
            ++this.wptr;
            ++this.len;
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.$();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Path concat(CharSequence str, int from, int len) {
        this.ensureSeparator();
        this.copy(str, from, len);
        return this;
    }

    @Override
    public final int length() {
        return this.len;
    }

    @Override
    public Path put(CharSequence str) {
        int l = str.length();
        if (l + this.len >= this.capacity) {
            this.extend(l + this.len);
        }
        Chars.strcpy(str, l, this.wptr);
        this.wptr += (long)l;
        this.len += l;
        return this;
    }

    @Override
    public Path put(char c) {
        if (1 + this.len >= this.capacity) {
            this.extend(16 + this.len);
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)c);
        ++this.len;
        return this;
    }

    public Path of(CharSequence str) {
        if (str == this) {
            this.len = str.length();
            this.wptr = this.ptr + (long)this.len;
            return this;
        }
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str);
    }

    public Path of(CharSequence str, int from, int len) {
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str, from, len);
    }

    public Path of(long lpsz) {
        if (lpsz != this.ptr) {
            this.wptr = this.ptr;
            this.len = 0;
            return this.concat(lpsz);
        }
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.ptr == 0L ? "" : AbstractCharSequence.getString(this);
    }

    public Path trimTo(int len) {
        this.len = len;
        this.wptr = this.ptr + (long)len;
        return this;
    }

    private void copy(CharSequence str, int from, int len) {
        this.encodeUtf8(str, from, len);
    }

    @Override
    protected void putUtf8Special(char c) {
        if (c == '/' && Os.type == 3) {
            this.put('\\');
        } else {
            this.put(c);
        }
    }

    protected final void ensureSeparator() {
        if (this.missingTrailingSeparator()) {
            Unsafe.getUnsafe().putByte(this.wptr, (byte)Files.SEPARATOR);
            ++this.wptr;
            ++this.len;
        }
    }

    private void extend(int len) {
        long p = Unsafe.malloc(len);
        Unsafe.getUnsafe().copyMemory(this.ptr, p, this.len);
        long d = this.wptr - this.ptr;
        Unsafe.free(this.ptr, this.capacity);
        this.ptr = p;
        this.wptr = p + d;
        this.capacity = len;
    }

    private boolean missingTrailingSeparator() {
        return this.len > 0 && Unsafe.getUnsafe().getByte(this.wptr - 1L) != Files.SEPARATOR;
    }
}

