/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.time;

import com.questdb.common.NumericException;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.Lexer;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.time.TimeZoneRuleFactory;
import com.questdb.std.time.TimeZoneRules;
import java.text.DateFormatSymbols;

public class DateLocale {
    private final IntObjHashMap<ObjList<CharSequence>> months = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> weekdays = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> amspms = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> eras = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> zones = new IntObjHashMap();
    private final String[] monthArray;
    private final String[] shortMonthArray;
    private final String[] weekdayArray;
    private final String[] shortWeekdayArray;
    private final String[] ampmArray;
    private final String[] eraArray;
    private final TimeZoneRuleFactory factory;
    private final String id;

    DateLocale(String id, DateFormatSymbols symbols, TimeZoneRuleFactory timeZoneRuleFactory, CharSequenceHashSet cache) {
        this.id = id;
        this.factory = timeZoneRuleFactory;
        this.monthArray = symbols.getMonths();
        DateLocale.index(this.monthArray, this.months);
        this.shortMonthArray = symbols.getShortMonths();
        DateLocale.index(this.shortMonthArray, this.months);
        this.weekdayArray = symbols.getWeekdays();
        DateLocale.index(this.weekdayArray, this.weekdays);
        this.shortWeekdayArray = symbols.getShortWeekdays();
        DateLocale.index(this.shortWeekdayArray, this.weekdays);
        this.ampmArray = symbols.getAmPmStrings();
        DateLocale.index(this.ampmArray, this.amspms);
        this.eraArray = symbols.getEras();
        DateLocale.index(this.eraArray, this.eras);
        this.indexZones(symbols.getZoneStrings(), timeZoneRuleFactory, cache);
    }

    public String getAMPM(int index) {
        return Unsafe.arrayGet(this.ampmArray, index);
    }

    public String getEra(int index) {
        return Unsafe.arrayGet(this.eraArray, index);
    }

    public String getId() {
        return this.id;
    }

    public String getMonth(int index) {
        return Unsafe.arrayGet(this.monthArray, index);
    }

    public TimeZoneRules getRules(CharSequence timeZoneName) throws NumericException {
        return this.getZoneRules(Numbers.decodeInt(this.matchZone(timeZoneName, 0, timeZoneName.length())));
    }

    public String getShortMonth(int index) {
        return Unsafe.arrayGet(this.shortMonthArray, index);
    }

    public String getShortWeekday(int index) {
        return Unsafe.arrayGet(this.shortWeekdayArray, index);
    }

    public String getWeekday(int index) {
        return Unsafe.arrayGet(this.weekdayArray, index);
    }

    public TimeZoneRules getZoneRules(int index) {
        return this.factory.getTimeZoneRulesQuick(index);
    }

    public long matchAMPM(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.amspms);
    }

    public long matchEra(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.eras);
    }

    public long matchMonth(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.months);
    }

    public long matchWeekday(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.weekdays);
    }

    public long matchZone(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.zones);
    }

    private static void index(String[] tokens, IntObjHashMap<ObjList<CharSequence>> map) {
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            DateLocale.defineToken(Unsafe.arrayGet(tokens, i), i, map);
        }
    }

    private static void defineToken(String token, int pos, IntObjHashMap<ObjList<CharSequence>> map) {
        if (token.length() == 0) {
            return;
        }
        char c0 = Character.toUpperCase(token.charAt(0));
        ObjList<CharSequence> l = map.get(c0);
        if (l == null) {
            l = new ObjList();
            map.put(c0, l);
        }
        l.add((char)pos + token.toUpperCase());
        l.sort(Lexer.COMPARATOR);
    }

    private static long findToken(CharSequence content, int lo, int hi, IntObjHashMap<ObjList<CharSequence>> map) throws NumericException {
        if (lo >= hi) {
            throw NumericException.INSTANCE;
        }
        char c = Character.toUpperCase(content.charAt(lo));
        ObjList<CharSequence> l = map.get(c);
        if (l == null) {
            throw NumericException.INSTANCE;
        }
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            boolean match;
            CharSequence txt = l.get(i);
            int n = txt.length() - 1;
            boolean bl = match = n <= hi - lo;
            if (match) {
                for (int k = 1; k < n; ++k) {
                    if (Character.toUpperCase(content.charAt(lo + k)) == txt.charAt(k + 1)) continue;
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            return (long)n << 32 | (long)txt.charAt(0);
        }
        throw NumericException.INSTANCE;
    }

    private void indexZones(String[][] zones, TimeZoneRuleFactory timeZoneRuleFactory, CharSequenceHashSet cache) {
        int index;
        if (cache.add("UTC") && (index = timeZoneRuleFactory.getTimeZoneRulesIndex("UTC")) != -1) {
            DateLocale.defineToken("UTC", index, this.zones);
        }
        for (String[] zNames : zones) {
            String key = zNames[0];
            int index2 = timeZoneRuleFactory.getTimeZoneRulesIndex(key);
            if (index2 == -1) continue;
            int m = zNames.length;
            for (int k = 1; k < m; ++k) {
                String name = zNames[k];
                if (!cache.add(name)) continue;
                DateLocale.defineToken(name, index2, this.zones);
            }
        }
    }
}

