/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.time;

import com.questdb.common.NumericException;
import com.questdb.std.IntList;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.AbstractDateFormat;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.Dates;

public class GenericDateFormat
extends AbstractDateFormat {
    private final IntList compiledOps;
    private final ObjList<String> delimiters;

    public GenericDateFormat(IntList compiledOps, ObjList<String> delimiters) {
        this.compiledOps = compiledOps;
        this.delimiters = delimiters;
    }

    @Override
    public void format(long datetime, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
        int day = -1;
        int month = -1;
        int year = Integer.MIN_VALUE;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int dayOfWeek = -1;
        boolean leap = false;
        int millis = -1;
        int n = this.compiledOps.size();
        block31: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.appendAmPm(sink, hour, locale);
                    continue block31;
                }
                case 21: 
                case 146: {
                    if (millis == -1) {
                        millis = Dates.getMillisOfSecond(datetime);
                    }
                    sink.put(millis);
                    continue block31;
                }
                case 31: {
                    if (millis == -1) {
                        millis = Dates.getMillisOfSecond(datetime);
                    }
                    DateFormatUtils.append00(sink, millis);
                    continue block31;
                }
                case 20: 
                case 145: {
                    if (second == -1) {
                        second = Dates.getSecondOfMinute(datetime);
                    }
                    sink.put(second);
                    continue block31;
                }
                case 30: {
                    if (second == -1) {
                        second = Dates.getSecondOfMinute(datetime);
                    }
                    DateFormatUtils.append0(sink, second);
                    continue block31;
                }
                case 19: 
                case 144: {
                    if (minute == -1) {
                        minute = Dates.getMinuteOfHour(datetime);
                    }
                    sink.put(minute);
                    continue block31;
                }
                case 29: {
                    if (minute == -1) {
                        minute = Dates.getMinuteOfHour(datetime);
                    }
                    DateFormatUtils.append0(sink, minute);
                    continue block31;
                }
                case 17: 
                case 142: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.appendHour12(sink, hour);
                    continue block31;
                }
                case 34: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.appendHour12Padded(sink, hour);
                    continue block31;
                }
                case 18: 
                case 143: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.appendHour121(sink, hour);
                    continue block31;
                }
                case 35: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.appendHour121Padded(sink, hour);
                    continue block31;
                }
                case 15: 
                case 140: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    sink.put(hour);
                    continue block31;
                }
                case 32: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.append0(sink, hour);
                    continue block31;
                }
                case 16: 
                case 141: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    sink.put(hour + 1);
                    continue block31;
                }
                case 33: {
                    if (hour == -1) {
                        hour = Dates.getHourOfDay(datetime);
                    }
                    DateFormatUtils.append0(sink, hour + 1);
                    continue block31;
                }
                case 9: 
                case 139: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Dates.getMonthOfYear(datetime, year, leap);
                        }
                        day = Dates.getDayOfMonth(datetime, year, month, leap);
                    }
                    sink.put(day);
                    continue block31;
                }
                case 10: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Dates.getMonthOfYear(datetime, year, leap);
                        }
                        day = Dates.getDayOfMonth(datetime, year, month, leap);
                    }
                    DateFormatUtils.append0(sink, day);
                    continue block31;
                }
                case 12: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Dates.getDayOfWeekSundayFirst(datetime);
                    }
                    sink.put(locale.getWeekday(dayOfWeek));
                    continue block31;
                }
                case 11: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Dates.getDayOfWeekSundayFirst(datetime);
                    }
                    sink.put(locale.getShortWeekday(dayOfWeek));
                    continue block31;
                }
                case 13: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Dates.getDayOfWeekSundayFirst(datetime);
                    }
                    sink.put(dayOfWeek);
                    continue block31;
                }
                case 5: 
                case 135: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        month = Dates.getMonthOfYear(datetime, year, leap);
                    }
                    sink.put(month);
                    continue block31;
                }
                case 6: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        month = Dates.getMonthOfYear(datetime, year, leap);
                    }
                    DateFormatUtils.append0(sink, month);
                    continue block31;
                }
                case 7: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        month = Dates.getMonthOfYear(datetime, year, leap);
                    }
                    sink.put(locale.getShortMonth(month - 1));
                    continue block31;
                }
                case 8: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Dates.getYear(datetime);
                            leap = Dates.isLeapYear(year);
                        }
                        month = Dates.getMonthOfYear(datetime, year, leap);
                    }
                    sink.put(locale.getMonth(month - 1));
                    continue block31;
                }
                case 2: 
                case 132: {
                    if (year == Integer.MIN_VALUE) {
                        year = Dates.getYear(datetime);
                        leap = Dates.isLeapYear(year);
                    }
                    sink.put(year);
                    continue block31;
                }
                case 3: {
                    if (year == Integer.MIN_VALUE) {
                        year = Dates.getYear(datetime);
                        leap = Dates.isLeapYear(year);
                    }
                    DateFormatUtils.append0(sink, year % 100);
                    continue block31;
                }
                case 4: {
                    if (year == Integer.MIN_VALUE) {
                        year = Dates.getYear(datetime);
                        leap = Dates.isLeapYear(year);
                    }
                    DateFormatUtils.append000(sink, year);
                    continue block31;
                }
                case 1: {
                    if (year == Integer.MIN_VALUE) {
                        year = Dates.getYear(datetime);
                        leap = Dates.isLeapYear(year);
                    }
                    DateFormatUtils.appendEra(sink, year, locale);
                    continue block31;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    sink.put(timeZoneName);
                    continue block31;
                }
                default: {
                    sink.put(this.delimiters.getQuick(-op - 1));
                }
            }
        }
    }

    @Override
    public long parse(CharSequence in, int lo, int hi, DateLocale locale) throws NumericException {
        int day = 1;
        int month = 1;
        int year = 1970;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        int era = 1;
        int timezone = -1;
        long offset = Long.MIN_VALUE;
        int hourType = 2;
        int pos = lo;
        int n = this.compiledOps.size();
        block39: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    long l = locale.matchAMPM(in, pos, hi);
                    hourType = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 21: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    millis = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 31: {
                    DateFormatUtils.assertRemaining(pos + 2, hi);
                    millis = Numbers.parseInt(in, pos, pos += 3);
                    continue block39;
                }
                case 146: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    millis = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 20: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    second = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 30: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    second = Numbers.parseInt(in, pos, pos += 2);
                    continue block39;
                }
                case 145: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    second = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 19: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    minute = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 29: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    minute = Numbers.parseInt(in, pos, pos += 2);
                    continue block39;
                }
                case 144: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    minute = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 17: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 34: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 142: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 18: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 35: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 143: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeInt(l) - 1;
                    pos += Numbers.decodeLen(l);
                    if (hourType != 2) continue block39;
                    hourType = 0;
                    continue block39;
                }
                case 15: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 32: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    continue block39;
                }
                case 140: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 16: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    continue block39;
                }
                case 33: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    continue block39;
                }
                case 141: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeInt(l) - 1;
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 9: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    day = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 10: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    day = Numbers.parseInt(in, pos, pos += 2);
                    continue block39;
                }
                case 139: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    day = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 11: 
                case 12: {
                    long l = locale.matchWeekday(in, pos, hi);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 13: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 5: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    month = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 6: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    month = Numbers.parseInt(in, pos, pos += 2);
                    continue block39;
                }
                case 135: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    month = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 7: 
                case 8: {
                    long l = locale.matchMonth(in, pos, hi);
                    month = Numbers.decodeInt(l) + 1;
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 2: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    year = Numbers.parseInt(in, pos++, pos);
                    continue block39;
                }
                case 3: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    year = DateFormatUtils.adjustYear(Numbers.parseInt(in, pos, pos += 2));
                    continue block39;
                }
                case 4: {
                    if (pos < hi && in.charAt(pos) == '-') {
                        DateFormatUtils.assertRemaining(pos + 4, hi);
                        year = -Numbers.parseInt(in, pos + 1, pos += 5);
                        continue block39;
                    }
                    DateFormatUtils.assertRemaining(pos + 3, hi);
                    year = Numbers.parseInt(in, pos, pos += 4);
                    continue block39;
                }
                case 132: {
                    long l = DateFormatUtils.parseYearGreedy(in, pos, hi);
                    year = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 1: {
                    long l = locale.matchEra(in, pos, hi);
                    era = Numbers.decodeInt(l);
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    long l = Dates.parseOffset(in, pos, hi);
                    if (l == Long.MIN_VALUE) {
                        l = locale.matchZone(in, pos, hi);
                        timezone = Numbers.decodeInt(l);
                    } else {
                        offset = (long)Numbers.decodeInt(l) * 60000L;
                    }
                    pos += Numbers.decodeLen(l);
                    continue block39;
                }
                default: {
                    String delimiter = this.delimiters.getQuick(-op - 1);
                    int len = delimiter.length();
                    if (len == 1) {
                        DateFormatUtils.assertChar(delimiter.charAt(0), in, pos++, hi);
                        continue block39;
                    }
                    pos = DateFormatUtils.assertString(delimiter, len, in, pos, hi);
                }
            }
        }
        DateFormatUtils.assertNoTail(pos, hi);
        return DateFormatUtils.compute(locale, era, year, month, day, hour, minute, second, millis, timezone, offset, hourType);
    }
}

