/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.time;

import com.questdb.common.NumericException;
import com.questdb.common.PartitionBy;
import com.questdb.std.Sinkable;
import com.questdb.std.ex.JournalUnsupportedTypeException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;

public class Interval
implements Sinkable {
    private long lo;
    private long hi;

    public Interval(long lo, long hi) {
        if (hi < lo) {
            this.lo = hi;
            this.hi = lo;
        } else {
            this.lo = lo;
            this.hi = hi;
        }
    }

    public Interval(CharSequence lo, CharSequence hi) throws NumericException {
        this(DateFormatUtils.parseDateTime(lo), DateFormatUtils.parseDateTime(hi));
    }

    public Interval(long millis, int partitionBy) {
        switch (partitionBy) {
            case 2: {
                this.lo = Dates.floorYYYY(millis);
                this.hi = Dates.ceilYYYY(millis);
                break;
            }
            case 1: {
                this.lo = Dates.floorMM(millis);
                this.hi = Dates.ceilMM(millis);
                break;
            }
            case 0: {
                this.lo = Dates.floorDD(millis);
                this.hi = Dates.ceilDD(millis);
                break;
            }
            default: {
                this.lo = 0L;
                this.hi = Long.MAX_VALUE;
            }
        }
    }

    public Interval(String dir, int partitionBy) throws NumericException {
        switch (partitionBy) {
            case 2: {
                long millis = DateFormatUtils.parseDateTime(dir + "-01-01T00:00:00.000Z");
                this.lo = Dates.floorYYYY(millis);
                this.hi = Dates.ceilYYYY(millis);
                break;
            }
            case 1: {
                long millis = DateFormatUtils.parseDateTime(dir + "-01T00:00:00.000Z");
                this.lo = Dates.floorMM(millis);
                this.hi = Dates.ceilMM(millis);
                break;
            }
            case 0: {
                long millis = DateFormatUtils.parseDateTime(dir + "T00:00:00.000Z");
                this.lo = Dates.floorDD(millis);
                this.hi = Dates.ceilDD(millis);
                break;
            }
            default: {
                if (!"default".equals(dir)) {
                    throw new JournalUnsupportedTypeException(PartitionBy.toString(partitionBy));
                }
                this.lo = 0L;
                this.hi = Long.MAX_VALUE;
            }
        }
    }

    public boolean contains(long x) {
        return x >= this.lo && x < this.hi;
    }

    public String getDirName(int partitionBy) {
        StringSink sink = new StringSink();
        switch (partitionBy) {
            case 2: {
                DateFormatUtils.formatYYYY(sink, this.lo);
                break;
            }
            case 1: {
                DateFormatUtils.formatYYYYMM(sink, this.lo);
                break;
            }
            case 0: {
                DateFormatUtils.formatDashYYYYMMDD(sink, this.lo);
                break;
            }
            default: {
                return "default";
            }
        }
        return sink.toString();
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public int hashCode() {
        int result = (int)(this.lo ^ this.lo >>> 32);
        return 31 * result + (int)(this.hi ^ this.hi >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.hi == interval.hi && this.lo == interval.lo;
    }

    public String toString() {
        return "Interval{lo=" + Dates.toString(this.lo) + ", hi=" + Dates.toString(this.hi) + '}';
    }

    public boolean isAfter(long x) {
        return this.lo > x;
    }

    public boolean isBefore(long x) {
        return this.hi <= x;
    }

    public void of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("low").put(':').putISODate(this.lo).put(',');
        sink.putQuoted("high").put(':').putISODate(this.hi);
        sink.put('}');
    }
}

