/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std.time;

import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.time.Dates;
import com.questdb.std.time.TimeZoneRules;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;

public class TimeZoneRulesImpl
implements TimeZoneRules {
    public static final long SAVING_INSTANT_TRANSITION = Unsafe.getFieldOffset(ZoneRules.class, "savingsInstantTransitions");
    public static final long STANDARD_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "standardOffsets");
    public static final long LAST_RULES = Unsafe.getFieldOffset(ZoneRules.class, "lastRules");
    public static final long SAVINGS_LOCAL_TRANSITION = Unsafe.getFieldOffset(ZoneRules.class, "savingsLocalTransitions");
    public static final long WALL_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "wallOffsets");
    private final long cutoffTransition;
    private final LongList historicTransitions = new LongList();
    private final ObjList<TransitionRule> rules;
    private final int ruleCount;
    private final int[] wallOffsets;
    private final long firstWall;
    private final long lastWall;
    private final int historyOverlapCheckCutoff;
    private final String id;
    private final long standardOffset;

    public TimeZoneRulesImpl(String id, ZoneRules rules) {
        this.id = id;
        long[] savingsInstantTransition = (long[])Unsafe.getUnsafe().getObject(rules, SAVING_INSTANT_TRANSITION);
        if (savingsInstantTransition.length == 0) {
            ZoneOffset[] standardOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, STANDARD_OFFSETS);
            this.standardOffset = standardOffsets[0].getTotalSeconds() * 1000;
        } else {
            this.standardOffset = Long.MIN_VALUE;
        }
        for (LocalDateTime dt : (LocalDateTime[])Unsafe.getUnsafe().getObject(rules, SAVINGS_LOCAL_TRANSITION)) {
            this.historicTransitions.add(Dates.toMillis(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute()) + (long)(dt.getSecond() * 1000) + (long)(dt.getNano() / 1000000));
        }
        this.cutoffTransition = this.historicTransitions.getLast();
        this.historyOverlapCheckCutoff = this.historicTransitions.size() - 1;
        ZoneOffsetTransitionRule[] lastRules = (ZoneOffsetTransitionRule[])Unsafe.getUnsafe().getObject(rules, LAST_RULES);
        this.rules = new ObjList(lastRules.length);
        int n = lastRules.length;
        for (int i = 0; i < n; ++i) {
            ZoneOffsetTransitionRule zr = lastRules[i];
            TransitionRule tr = new TransitionRule();
            tr.offsetBefore = zr.getOffsetBefore().getTotalSeconds();
            tr.offsetAfter = zr.getOffsetAfter().getTotalSeconds();
            tr.standardOffset = zr.getStandardOffset().getTotalSeconds();
            tr.dow = zr.getDayOfWeek() == null ? -1 : zr.getDayOfWeek().getValue();
            tr.dom = zr.getDayOfMonthIndicator();
            tr.month = zr.getMonth().getValue();
            tr.midnightEOD = zr.isMidnightEndOfDay();
            tr.hour = zr.getLocalTime().getHour();
            tr.minute = zr.getLocalTime().getMinute();
            tr.second = zr.getLocalTime().getSecond();
            switch (zr.getTimeDefinition()) {
                case UTC: {
                    tr.timeDef = 0;
                    break;
                }
                case STANDARD: {
                    tr.timeDef = 1;
                    break;
                }
                default: {
                    tr.timeDef = 2;
                }
            }
            this.rules.add(tr);
        }
        this.ruleCount = lastRules.length;
        ZoneOffset[] wallOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, WALL_OFFSETS);
        this.wallOffsets = new int[wallOffsets.length];
        int n2 = wallOffsets.length;
        for (int i = 0; i < n2; ++i) {
            this.wallOffsets[i] = wallOffsets[i].getTotalSeconds();
        }
        this.firstWall = (long)this.wallOffsets[0] * 1000L;
        this.lastWall = (long)this.wallOffsets[wallOffsets.length - 1] * 1000L;
    }

    @Override
    public long getOffset(long millis) {
        int y = Dates.getYear(millis);
        return this.getOffset(millis, y, Dates.isLeapYear(y));
    }

    @Override
    public long getOffset(long millis, int year, boolean leap) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return this.standardOffset;
        }
        if (this.ruleCount > 0 && millis > this.cutoffTransition) {
            return this.fromRules(millis, year, leap);
        }
        if (millis > this.cutoffTransition) {
            return this.lastWall;
        }
        return this.fromHistory(millis);
    }

    @Override
    public String getId() {
        return this.id;
    }

    private long fromHistory(long millis) {
        int index = this.historicTransitions.binarySearch(millis);
        if (index == -1) {
            return this.firstWall;
        }
        if (index < 0) {
            index = -index - 2;
        } else if (index < this.historyOverlapCheckCutoff && this.historicTransitions.getQuick(index) == this.historicTransitions.getQuick(index + 1)) {
            ++index;
        }
        if ((index & 1) == 0) {
            int offsetBefore = Unsafe.arrayGet(this.wallOffsets, index / 2);
            int offsetAfter = Unsafe.arrayGet(this.wallOffsets, index / 2 + 1);
            int delta = offsetAfter - offsetBefore;
            if (delta > 0) {
                return (long)(delta + offsetAfter) * 1000L;
            }
            return (long)offsetBefore * 1000L;
        }
        return (long)Unsafe.arrayGet(this.wallOffsets, index / 2 + 1) * 1000L;
    }

    private long fromRules(long millis, int year, boolean leap) {
        int offset = 0;
        for (int i = 0; i < this.ruleCount; ++i) {
            long date;
            TransitionRule zr = this.rules.getQuick(i);
            offset = zr.offsetBefore;
            int offsetAfter = zr.offsetAfter;
            int dom = zr.dom;
            int month = zr.month;
            int dow = zr.dow;
            if (dom < 0) {
                date = Dates.toMillis(year, leap, month, Dates.getDaysPerMonth(month, leap) + 1 + dom, zr.hour, zr.minute) + (long)zr.second * 1000L;
                if (dow > -1) {
                    date = Dates.previousOrSameDayOfWeek(date, dow);
                }
            } else {
                date = Dates.toMillis(year, leap, month, dom, zr.hour, zr.minute) + (long)zr.second * 1000L;
                if (dow > -1) {
                    date = Dates.nextOrSameDayOfWeek(date, dow);
                }
            }
            if (zr.midnightEOD) {
                date = Dates.addDays(date, 1);
            }
            switch (zr.timeDef) {
                case 0: {
                    date += (long)(offset - ZoneOffset.UTC.getTotalSeconds()) * 1000L;
                    break;
                }
                case 1: {
                    date += (long)(offset - zr.standardOffset) * 1000L;
                    break;
                }
            }
            long delta = offsetAfter - offset;
            if (delta > 0L) {
                if (millis < date) {
                    return (long)offset * 1000L;
                }
                if (millis < date + delta) {
                    return ((long)offsetAfter + delta) * 1000L;
                }
                offset = offsetAfter;
                continue;
            }
            if (millis < date) {
                return (long)offset * 1000L;
            }
            offset = offsetAfter;
        }
        return (long)offset * 1000L;
    }

    private static class TransitionRule {
        public static final int UTC = 0;
        public static final int STANDARD = 1;
        public static final int WALL = 2;
        int offsetBefore;
        int offsetAfter;
        int standardOffset;
        int dow;
        int dom;
        int month;
        boolean midnightEOD;
        int hour;
        int minute;
        int second;
        int timeDef;

        private TransitionRule() {
        }
    }
}

