/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ex.JournalException;
import com.questdb.store.MemoryFile;
import java.io.Closeable;
import java.nio.ByteBuffer;

public abstract class AbstractColumn
implements Closeable {
    final MemoryFile mappedFile;
    long txAppendOffset = -1L;

    AbstractColumn(MemoryFile storage) {
        this.mappedFile = storage;
    }

    @Override
    public void close() {
        this.mappedFile.close();
    }

    public void commit() {
        if (this.txAppendOffset != -1L) {
            this.mappedFile.setAppendOffset(this.txAppendOffset);
        }
    }

    public void compact() throws JournalException {
        this.mappedFile.compact();
    }

    public void force() {
        this.mappedFile.force();
    }

    public ByteBuffer getBuffer(long offset) {
        return this.mappedFile.getBuffer(offset);
    }

    public long getOffset() {
        return this.mappedFile.getAppendOffset();
    }

    public abstract long getOffset(long var1);

    public void preCommit(long appendOffset) {
        this.txAppendOffset = appendOffset;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.mappedFile.setSequentialAccess(sequentialAccess);
    }

    public abstract long size();

    public String toString() {
        return this.getClass().getName() + "[file=" + this.mappedFile + ", size=" + this.size() + ']';
    }

    public abstract void truncate(long var1);
}

