/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.store.AbstractColumn;
import com.questdb.store.BSearchType;
import com.questdb.store.MemoryFile;

public class FixedColumn
extends AbstractColumn {
    private final int width;
    private final int bits;

    public FixedColumn(MemoryFile mappedFile, int width) {
        super(mappedFile);
        this.width = width;
        this.bits = Numbers.msb(width);
    }

    public long bsearchEdge(long val, BSearchType type) {
        return this.bsearchEdge(val, type, 0L, this.size() - 1L);
    }

    public long bsearchEdge(long val, BSearchType type, long lo, long hi) {
        if (hi == -1L) {
            return -1L;
        }
        long res = this.bsearchAny(val, type, lo, hi);
        switch (type) {
            case NEWER_OR_SAME: {
                while (res > lo) {
                    if (this.getLong(--res) >= val) continue;
                    return res + 1L;
                }
                break;
            }
            default: {
                while (res < hi) {
                    if (this.getLong(++res) <= val) continue;
                    return res - 1L;
                }
                break block0;
            }
        }
        return res;
    }

    public void copy(Object obj, long offset) {
        Unsafe.getUnsafe().copyMemory(obj, offset, null, this.getAddress(), this.width);
    }

    public boolean getBool(long localRowID) {
        return Unsafe.getBool(this.mappedFile.addressOf(this.getOffset(localRowID), 1));
    }

    public byte getByte(long localRowID) {
        return Unsafe.getUnsafe().getByte(this.mappedFile.addressOf(this.getOffset(localRowID), 1));
    }

    public double getDouble(long localRowID) {
        return Unsafe.getUnsafe().getDouble(this.mappedFile.addressOf(this.getOffset(localRowID), 8));
    }

    public float getFloat(long localRowID) {
        return Unsafe.getUnsafe().getFloat(this.mappedFile.addressOf(this.getOffset(localRowID), 4));
    }

    public int getInt(long localRowID) {
        return Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(this.getOffset(localRowID), 4));
    }

    public long getLong(long localRowID) {
        return Unsafe.getUnsafe().getLong(this.mappedFile.addressOf(this.getOffset(localRowID), 8));
    }

    @Override
    public long getOffset(long localRowID) {
        return localRowID << this.bits;
    }

    @Override
    public long size() {
        return this.getOffset() >> this.bits;
    }

    @Override
    public void truncate(long size) {
        this.preCommit(size <= 0L ? 0L : size << this.bits);
    }

    public short getShort(long localRowID) {
        return Unsafe.getUnsafe().getShort(this.mappedFile.addressOf(this.getOffset(localRowID), 2));
    }

    public void putBool(boolean value) {
        Unsafe.getUnsafe().putByte(this.getAddress(), (byte)(value ? 1 : 0));
    }

    public void putByte(byte b) {
        Unsafe.getUnsafe().putByte(this.getAddress(), b);
    }

    public void putDouble(double value) {
        Unsafe.getUnsafe().putDouble(this.getAddress(), value);
    }

    public void putFloat(float value) {
        Unsafe.getUnsafe().putFloat(this.getAddress(), value);
    }

    public long putInt(int value) {
        Unsafe.getUnsafe().putInt(this.getAddress(), value);
        return (this.txAppendOffset >> this.bits) - 1L;
    }

    public long putLong(long value) {
        Unsafe.getUnsafe().putLong(this.getAddress(), value);
        return (this.txAppendOffset >> this.bits) - 1L;
    }

    public void putNull() {
        this.getAddress();
    }

    public void putShort(short value) {
        Unsafe.getUnsafe().putShort(this.getAddress(), value);
    }

    private long bsearchAny(long val, BSearchType type, long lo, long hi) {
        long _lo = lo;
        long _hi = hi;
        while (_lo < _hi) {
            long mid = _lo + (_hi - _lo) / 2L;
            long res = val - this.getLong(mid);
            if (res < 0L) {
                _hi = mid;
                continue;
            }
            if (res > 0L) {
                _lo = mid + 1L;
                continue;
            }
            return mid;
        }
        switch (type) {
            case NEWER_OR_SAME: {
                return val < this.getLong(_lo) ? _lo : -2L;
            }
        }
        return val > this.getLong(_hi) ? _hi : -1L;
    }

    private long getAddress() {
        long appendOffset = this.mappedFile.getAppendOffset();
        this.preCommit(appendOffset + (long)this.width);
        return this.mappedFile.addressOf(appendOffset, this.width);
    }
}

