/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.NumericException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ObjObjHashMap;
import com.questdb.std.Rows;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Dates;
import com.questdb.std.time.Interval;
import com.questdb.store.FixedColumn;
import com.questdb.store.JournalIterators;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.Partition;
import com.questdb.store.TempPartition;
import com.questdb.store.Tx;
import com.questdb.store.TxIterator;
import com.questdb.store.TxLog;
import com.questdb.store.factory.JournalCloseInterceptor;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.query.AbstractResultSetBuilder;
import com.questdb.store.query.api.Query;
import com.questdb.store.query.spi.QueryImpl;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;

public class Journal<T>
implements Iterable<T>,
Closeable {
    public static final long TX_LIMIT_EVAL = -1L;
    private static final Log LOG = LogFactory.getLog(Journal.class);
    final ObjList<Partition<T>> partitions = new ObjList();
    final Tx tx = new Tx();
    final JournalMetadata<T> metadata;
    private final File location;
    private final ObjObjHashMap<String, MMappedSymbolTable> symbolTableMap = new ObjObjHashMap();
    private final ObjList<MMappedSymbolTable> symbolTables = new ObjList();
    private final Query<T> query = new QueryImpl(this);
    private final long timestampOffset;
    private final Comparator<T> timestampComparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            long x = Unsafe.getUnsafe().getLong(o1, Journal.this.timestampOffset);
            long y = Unsafe.getUnsafe().getLong(o2, Journal.this.timestampOffset);
            return Long.compare(x, y);
        }
    };
    private final BitSet inactiveColumns;
    private final long openFileTtl;
    private final long expireRecheckInterval;
    protected JournalCloseInterceptor closeInterceptor;
    protected boolean open;
    protected TxLog txLog;
    protected boolean sequentialAccess = false;
    private volatile Partition<T> irregularPartition;
    private TxIterator txIterator;
    private long lastExpireCheck = 0L;

    public Journal(JournalMetadata<T> metadata, File location) throws JournalException {
        this.metadata = metadata;
        this.location = location;
        this.txLog = new TxLog(location, this.getMode(), metadata.getTxCountHint());
        this.open = true;
        this.timestampOffset = this.getMetadata().getTimestampMetadata() == null ? -1L : this.getMetadata().getTimestampMetadata().offset;
        this.inactiveColumns = new BitSet(metadata.getColumnCount());
        this.openFileTtl = metadata.getOpenFileTTL();
        this.expireRecheckInterval = (long)((double)this.openFileTtl * 0.1);
        this.configure();
    }

    @Override
    public void close() {
        if (this.open) {
            if (this.closeInterceptor != null && !this.closeInterceptor.canClose(this)) {
                return;
            }
        } else {
            throw new JournalRuntimeException("Already closed: %s", this);
        }
        this.closePartitions();
        this.closeSymbolTables();
        Misc.free(this.txLog);
        this.open = false;
    }

    public TempPartition<T> createTempPartition(String name) {
        int lag = this.getMetadata().getLag();
        if (lag < 1) {
            throw new JournalRuntimeException("Journal doesn't support temp partitions: %s", this);
        }
        Interval interval = null;
        if (this.getMetadata().getPartitionBy() != 3) {
            Partition<T> p = this.partitions.getLast();
            if (p != null) {
                Interval lastPartitionInterval = p.getInterval();
                interval = new Interval(lastPartitionInterval.getLo(), Dates.addHours(lastPartitionInterval.getHi(), lag));
            } else {
                interval = new Interval(System.currentTimeMillis(), this.getMetadata().getPartitionBy());
            }
        }
        return new TempPartition(this, interval, this.nonLagPartitionCount(), name);
    }

    public long decrementRowID(long rowID) throws JournalException {
        int partitionIndex = Rows.toPartitionIndex(rowID);
        long localRowID = Rows.toLocalRowID(rowID);
        if (localRowID > 0L) {
            return Rows.toRowID(partitionIndex, localRowID - 1L);
        }
        while (--partitionIndex > -1) {
            long sz = this.getPartition(partitionIndex, true).size();
            if (sz <= 0L) continue;
            return Rows.toRowID(partitionIndex, sz - 1L);
        }
        return -1L;
    }

    public void expireOpenFiles0() {
        long t = System.currentTimeMillis();
        if (this.openFileTtl > 0L && t - this.lastExpireCheck > this.expireRecheckInterval) {
            this.expireOpenFiles0(t - this.openFileTtl);
        }
        this.lastExpireCheck = t;
    }

    public Tx find(long txn, long txPin) {
        long address = this.txLog.findAddress(txn, txPin);
        if (address == -1L) {
            return null;
        }
        this.txLog.read(address, this.tx);
        return this.tx;
    }

    public Partition<T> getIrregularPartition() {
        return this.irregularPartition;
    }

    public void setIrregularPartition(Partition<T> partition) {
        this.removeIrregularPartitionInternal();
        this.irregularPartition = partition;
        this.irregularPartition.setPartitionIndex(this.nonLagPartitionCount());
    }

    public Partition<T> getLastPartition() throws JournalException {
        if (this.getPartitionCount() == 0) {
            return null;
        }
        Partition<T> result = this.irregularPartition != null ? this.irregularPartition : this.partitions.getLast();
        if (result == null) {
            throw new JournalException("No available partitions", new Object[0]);
        }
        Partition<T> intermediate = result.open();
        while (true) {
            if (intermediate.size() > 0L) {
                return intermediate;
            }
            if (intermediate.getPartitionIndex() == 0) break;
            intermediate = this.getPartition(intermediate.getPartitionIndex() - 1, true);
        }
        return result.size() > 0L ? result : null;
    }

    public File getLocation() {
        return this.location;
    }

    public long getMaxRowID() throws JournalException {
        Partition<T> p = this.getLastPartition();
        if (p == null) {
            return -1L;
        }
        return Rows.toRowID(p.getPartitionIndex(), p.size() - 1L);
    }

    public long getMaxTimestamp() throws JournalException {
        Partition<T> p = this.getLastPartition();
        if (p == null) {
            return 0L;
        }
        FixedColumn column = p.getTimestampColumn();
        long sz = column.size();
        if (sz > 0L) {
            return column.getLong(sz - 1L);
        }
        return 0L;
    }

    public final JournalMetadata<T> getMetadata() {
        return this.metadata;
    }

    public int getMode() {
        return 0;
    }

    public String getName() {
        return this.getMetadata().getKey().getName();
    }

    public Partition<T> getPartition(int partitionIndex, boolean open) throws JournalException {
        if (this.irregularPartition != null && partitionIndex == this.nonLagPartitionCount()) {
            return open ? this.irregularPartition.open() : this.irregularPartition;
        }
        Partition<T> partition = this.partitions.get(partitionIndex).access();
        if (open) {
            partition.open();
        }
        return partition;
    }

    public int getPartitionCount() {
        if (this.irregularPartition == null) {
            return this.nonLagPartitionCount();
        }
        return this.nonLagPartitionCount() + 1;
    }

    public MMappedSymbolTable getSymbolTable(String columnName) {
        MMappedSymbolTable result = this.symbolTableMap.get(columnName);
        if (result == null) {
            throw new JournalRuntimeException("Column is not a symbol: %s", columnName);
        }
        return result;
    }

    public MMappedSymbolTable getSymbolTable(int index) {
        return this.symbolTables.get(index);
    }

    public int getSymbolTableCount() {
        return this.symbolTables.size();
    }

    public Comparator<T> getTimestampComparator() {
        return this.timestampComparator;
    }

    public long getTxPin() {
        return this.txLog.getCurrentTxnPin();
    }

    public long getTxn() {
        assert (this.isOpen());
        return this.txLog.getCurrentTxn();
    }

    public boolean hasIrregularPartition() {
        return this.irregularPartition != null;
    }

    public long incrementRowID(long rowID) throws JournalException {
        Partition<T> p;
        int count = this.getPartitionCount();
        if (rowID == -1L) {
            if (count > 0 && this.getPartition(0, true).size() > 0L) {
                return 0L;
            }
            return -1L;
        }
        int partitionIndex = Rows.toPartitionIndex(rowID);
        long localRowID = Rows.toLocalRowID(rowID);
        if (localRowID < (p = this.getPartition(partitionIndex, this.open)).size() - 1L) {
            return Rows.toRowID(partitionIndex, localRowID + 1L);
        }
        while (++partitionIndex < count) {
            p = this.getPartition(partitionIndex, true);
            if (p.size() <= 0L) continue;
            return Rows.toRowID(partitionIndex, 0L);
        }
        return -1L;
    }

    public boolean isOpen() {
        return this.open;
    }

    public final boolean isSequentialAccess() {
        return this.sequentialAccess;
    }

    public final void setSequentialAccess(boolean sequentialAccess) {
        int i;
        this.sequentialAccess = sequentialAccess;
        int n = this.partitions.size();
        for (i = 0; i < n; ++i) {
            Partition<T> partition = this.partitions.getQuick(i);
            if (partition == null) continue;
            partition.setSequentialAccess(sequentialAccess);
        }
        if (this.irregularPartition != null) {
            this.irregularPartition.setSequentialAccess(sequentialAccess);
        }
        this.txLog.setSequentialAccess(sequentialAccess);
        n = this.symbolTables.size();
        for (i = 0; i < n; ++i) {
            this.symbolTables.getQuick(i).setSequentialAccess(sequentialAccess);
        }
    }

    public <X> X iteratePartitions(AbstractResultSetBuilder<T, X> builder) throws JournalException {
        builder.setJournal(this);
        int count = this.getPartitionCount();
        for (int i = 0; i < count && !builder.next(this.getPartition(i, false), true); ++i) {
        }
        return builder.getResult();
    }

    public <X> X iteratePartitionsDesc(AbstractResultSetBuilder<T, X> builder) throws JournalException {
        builder.setJournal(this);
        int count = this.getPartitionCount();
        for (int i = count - 1; i > -1 && !builder.next(this.getPartition(i, false), false); --i) {
        }
        return builder.getResult();
    }

    @Override
    public Iterator<T> iterator() {
        return JournalIterators.iterator(this);
    }

    public T newObject() {
        return (T)this.getMetadata().newObject();
    }

    public int nonLagPartitionCount() {
        return this.partitions.size();
    }

    public Query<T> query() {
        return this.query;
    }

    public void read(long rowID, T obj) throws JournalException {
        this.getPartition(Rows.toPartitionIndex(rowID), true).read(Rows.toLocalRowID(rowID), obj);
    }

    public T[] read(LongList rowIDs) throws JournalException {
        Object[] result = (Object[])Array.newInstance(this.metadata.getModelClass(), rowIDs.size());
        int sz = rowIDs.size();
        for (int i = 0; i < sz; ++i) {
            result[i] = this.read(rowIDs.get(i));
        }
        return result;
    }

    public T read(long rowID) throws JournalException {
        return this.getPartition(Rows.toPartitionIndex(rowID), true).read(Rows.toLocalRowID(rowID));
    }

    public boolean refresh() {
        if (this.isOpen() && this.txLog.head(this.tx)) {
            this.refreshInternal();
            int sz = this.symbolTables.size();
            for (int i = 0; i < sz; ++i) {
                this.symbolTables.getQuick(i).applyTx(this.tx.symbolTableSizes[i], this.tx.symbolTableIndexPointers[i]);
            }
            return true;
        }
        return false;
    }

    public Journal<T> select(String ... columns) {
        if (columns == null || columns.length == 0) {
            this.inactiveColumns.clear();
        } else {
            this.inactiveColumns.set(0, this.metadata.getColumnCount());
            for (int i = 0; i < columns.length; ++i) {
                this.inactiveColumns.clear(this.metadata.getColumnIndex(columns[i]));
            }
        }
        return this;
    }

    public void setCloseInterceptor(JournalCloseInterceptor closeInterceptor) {
        this.closeInterceptor = closeInterceptor;
    }

    public long size() throws JournalException {
        long result = 0L;
        int count = this.getPartitionCount();
        for (int i = 0; i < count; ++i) {
            result += this.getPartition(i, true).size();
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[location=" + this.location + ", mode=" + this.getMode() + ", , metadata=" + this.metadata + ']';
    }

    public TxIterator transactions() {
        if (this.txIterator == null) {
            this.txIterator = new TxIterator(this.txLog);
        } else {
            this.txIterator.reset();
        }
        return this.txIterator;
    }

    void closePartitions() {
        if (this.irregularPartition != null) {
            this.irregularPartition.close();
        }
        int sz = this.partitions.size();
        for (int i = 0; i < sz; ++i) {
            this.partitions.getQuick(i).close();
        }
        this.partitions.clear();
    }

    private void closeSymbolTables() {
        int sz = this.symbolTables.size();
        for (int i = 0; i < sz; ++i) {
            Misc.free(this.symbolTables.getQuick(i));
        }
    }

    void configure() throws JournalException {
        this.txLog.head(this.tx);
        this.configureColumns();
        this.configureSymbolTableSynonyms();
        this.configurePartitions();
    }

    private void configureColumns() throws JournalException {
        int columnCount = this.getMetadata().getColumnCount();
        try {
            for (int i = 0; i < columnCount; ++i) {
                ColumnMetadata meta = this.metadata.getColumnQuick(i);
                if (meta.type != 8 || meta.sameAs != null) continue;
                int tabIndex = this.symbolTables.size();
                int tabSize = this.tx.symbolTableSizes.length > tabIndex ? this.tx.symbolTableSizes[tabIndex] : 0;
                long indexTxAddress = this.tx.symbolTableIndexPointers.length > tabIndex ? this.tx.symbolTableIndexPointers[tabIndex] : 0L;
                MMappedSymbolTable tab = new MMappedSymbolTable(meta.distinctCountHint, meta.avgSize, this.getMetadata().getTxCountHint(), this.location, meta.name, this.getMode(), tabSize, indexTxAddress, meta.noCache, this.sequentialAccess);
                this.symbolTables.add(tab);
                this.symbolTableMap.put(meta.name, tab);
                meta.symbolTable = tab;
            }
        }
        catch (JournalException e) {
            this.closeSymbolTables();
            throw e;
        }
    }

    private void configureIrregularPartition() {
        String lagPartitionName = this.tx.lagName;
        if (!(lagPartitionName == null || this.irregularPartition != null && lagPartitionName.equals(this.irregularPartition.getName()))) {
            TempPartition<T> temp = this.createTempPartition(lagPartitionName);
            temp.applyTx(this.tx.lagSize, this.tx.lagIndexPointers);
            this.setIrregularPartition(temp);
        } else if (lagPartitionName != null && lagPartitionName.equals(this.irregularPartition.getName())) {
            this.irregularPartition.applyTx(this.tx.lagSize, this.tx.lagIndexPointers);
        } else if (lagPartitionName == null && this.irregularPartition != null) {
            this.removeIrregularPartitionInternal();
        }
    }

    private void configurePartitions() {
        Object[] files = this.getLocation().listFiles(f -> f.isDirectory() && !f.getName().startsWith("temp"));
        int partitionIndex = 0;
        if (files != null && this.tx.journalMaxRowID > 0L) {
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object f2 = files[i];
                if (partitionIndex > Rows.toPartitionIndex(this.tx.journalMaxRowID)) break;
                long txLimit = -1L;
                long[] indexTxAddresses = null;
                if (partitionIndex == Rows.toPartitionIndex(this.tx.journalMaxRowID)) {
                    txLimit = Rows.toLocalRowID(this.tx.journalMaxRowID);
                    indexTxAddresses = this.tx.indexPointers;
                }
                try {
                    Interval interval = new Interval(((File)f2).getName(), this.getMetadata().getPartitionBy());
                    if (partitionIndex < this.partitions.size()) {
                        Partition<T> partition = this.partitions.getQuick(partitionIndex);
                        Interval that = partition.getInterval();
                        if (that == null || that.equals(interval)) {
                            partition.applyTx(txLimit, indexTxAddresses);
                            ++partitionIndex;
                            continue;
                        }
                        partition.close();
                        this.partitions.remove(partitionIndex);
                        continue;
                    }
                    this.partitions.add(new Partition(this, interval, partitionIndex++, txLimit, indexTxAddresses, this.sequentialAccess));
                    continue;
                }
                catch (NumericException e) {
                    LOG.info().$("Foreign directory: ").$(((File)f2).getName()).$();
                }
            }
        }
        this.configureIrregularPartition();
    }

    private void configureSymbolTableSynonyms() {
        int n = this.metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnMetadata meta = this.metadata.getColumnQuick(i);
            if (meta.type != 8 || meta.sameAs == null) continue;
            MMappedSymbolTable tab = this.getSymbolTable(meta.sameAs);
            this.symbolTableMap.put(meta.name, tab);
            meta.symbolTable = tab;
        }
    }

    private void expireOpenFiles0(long deadline) {
        int sz = this.partitions.size() - 1;
        for (int i = 0; i < sz; ++i) {
            Partition<T> partition = this.partitions.getQuick(i);
            if (partition.getLastAccessed() >= deadline || !partition.isOpen()) continue;
            partition.close();
        }
    }

    BitSet getInactiveColumns() {
        return this.inactiveColumns;
    }

    long getTimestamp(T o) {
        return Unsafe.getUnsafe().getLong(o, this.timestampOffset);
    }

    long getTimestampOffset() {
        return this.timestampOffset;
    }

    boolean isCompatible(Journal<T> that) {
        return this.getMetadata().isCompatible(that.getMetadata(), true);
    }

    Partition<T> lastNonEmptyNonLag() throws JournalException {
        int count = this.nonLagPartitionCount();
        if (count > 0) {
            Partition<T> result = this.getPartition(count - 1, true);
            while (true) {
                if (result.size() > 0L) {
                    return result;
                }
                if (result.getPartitionIndex() == 0) break;
                result = this.getPartition(result.getPartitionIndex() - 1, true);
            }
            return result;
        }
        return null;
    }

    private void refreshInternal() {
        int txPartitionIndex;
        assert (this.tx.address > 0L);
        int n = txPartitionIndex = this.tx.journalMaxRowID == -1L ? 0 : Rows.toPartitionIndex(this.tx.journalMaxRowID);
        if (this.partitions.size() != txPartitionIndex + 1 || this.tx.journalMaxRowID < 1L) {
            if (this.tx.journalMaxRowID < 1L || this.partitions.size() > txPartitionIndex + 1) {
                this.closePartitions();
            }
            this.configurePartitions();
        } else {
            long txPartitionSize = this.tx.journalMaxRowID == -1L ? 0L : Rows.toLocalRowID(this.tx.journalMaxRowID);
            this.partitions.getQuick(txPartitionIndex).applyTx(txPartitionSize, this.tx.indexPointers);
            this.configureIrregularPartition();
        }
    }

    void removeIrregularPartitionInternal() {
        if (this.irregularPartition != null) {
            if (this.irregularPartition.isOpen()) {
                this.irregularPartition.close();
            }
            this.irregularPartition = null;
        }
    }
}

