/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.Hash;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.DirectBytes;
import com.questdb.store.AbstractColumn;
import com.questdb.store.FixedColumn;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.Partition;
import com.questdb.store.SymbolIndexProxy;
import com.questdb.store.VariableColumn;
import com.questdb.store.factory.configuration.ColumnMetadata;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class JournalEntryWriterImpl
implements JournalEntryWriter {
    private final JournalWriter journal;
    private final ColumnMetadata[] meta;
    private final int timestampIndex;
    private final boolean[] skipped;
    private final long[] koTuple;
    private AbstractColumn[] columns;
    private SymbolIndexProxy[] indexProxies;
    private Partition partition;
    private long timestamp;

    public JournalEntryWriterImpl(JournalWriter journal) {
        this.journal = journal;
        this.meta = new ColumnMetadata[journal.getMetadata().getColumnCount()];
        journal.getMetadata().copyColumnMetadata(this.meta);
        this.timestampIndex = journal.getMetadata().getTimestampIndex();
        this.koTuple = new long[this.meta.length * 2];
        this.skipped = new boolean[this.meta.length];
    }

    @Override
    public void append() throws JournalException {
        int l = this.meta.length;
        for (int i = 0; i < l; ++i) {
            if (Unsafe.arrayGet(this.skipped, i)) {
                this.putNull(i);
            }
            Unsafe.arrayGet(this.columns, i).commit();
            if (!this.meta((int)i).indexed) continue;
            Unsafe.arrayGet(this.indexProxies, i).getIndex().add((int)Unsafe.arrayGet(this.koTuple, i * 2), Unsafe.arrayGet(this.koTuple, i * 2 + 1));
        }
        this.partition.applyTx(-1L, null);
        this.journal.updateTsLo(this.timestamp);
    }

    @Override
    public void put(int index, byte value) {
        this.assertType(index, 1);
        this.fixCol(index).putByte(value);
        this.skip(index);
    }

    @Override
    public void putBin(int index, InputStream value) {
        this.putBin0(index, value);
        this.skip(index);
    }

    @Override
    public OutputStream putBin(int index) {
        this.skip(index);
        return this.varCol(index).putBin();
    }

    @Override
    public void putBin(int index, ByteBuffer buf) {
        this.varCol(index).putBin(buf);
        this.skip(index);
    }

    @Override
    public void putBool(int index, boolean value) {
        this.assertType(index, 0);
        this.fixCol(index).putBool(value);
        this.skip(index);
    }

    @Override
    public void putDate(int index, long value) {
        this.assertType(index, 10);
        this.fixCol(index).putLong(value);
        this.skip(index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.assertType(index, 2);
        this.fixCol(index).putDouble(value);
        this.skip(index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.assertType(index, 3);
        this.fixCol(index).putFloat(value);
        this.skip(index);
    }

    @Override
    public void putInt(int index, int value) {
        this.assertType(index, 4);
        this.putInt0(index, value);
        this.skip(index);
    }

    @Override
    public void putLong(int index, long value) {
        this.assertType(index, 5);
        this.putLong0(index, value);
        this.skip(index);
    }

    @Override
    public void putNull(int index) {
        switch (this.meta[index].type) {
            case 7: {
                this.putNullStr(index);
                break;
            }
            case 8: {
                this.putSymbol0(index, null);
                break;
            }
            case 4: {
                this.putInt0(index, Integer.MIN_VALUE);
                break;
            }
            case 3: {
                this.putFloat(index, Float.NaN);
                break;
            }
            case 2: {
                this.putDouble(index, Double.NaN);
                break;
            }
            case 5: {
                this.putLong(index, Long.MIN_VALUE);
                break;
            }
            case 9: {
                this.putBin0(index, null);
                break;
            }
            case 10: {
                this.putDate(index, Long.MIN_VALUE);
                break;
            }
            default: {
                this.fixCol(index).putNull();
            }
        }
    }

    @Override
    public void putShort(int index, short value) {
        this.assertType(index, 6);
        this.fixCol(index).putShort(value);
        this.skip(index);
    }

    @Override
    public void putStr(int index, CharSequence value) {
        this.assertType(index, 7);
        if (this.meta((int)index).indexed) {
            Unsafe.arrayPut(this.koTuple, index * 2, value == null ? -1L : (long)Hash.boundedHash(value, Unsafe.arrayGet(this.meta, (int)index).distinctCountHint));
            Unsafe.arrayPut(this.koTuple, index * 2 + 1, this.varCol(index).putStr(value));
        } else {
            this.varCol(index).putStr(value);
        }
        this.skip(index);
    }

    @Override
    public void putStr(int index, DirectBytes value) {
        this.assertType(index, 7);
        if (this.meta((int)index).indexed) {
            Unsafe.arrayPut(this.koTuple, index * 2, value == null ? -1L : (long)Hash.boundedHash(value, Unsafe.arrayGet(this.meta, (int)index).distinctCountHint));
            Unsafe.arrayPut(this.koTuple, index * 2 + 1, this.varCol(index).putStr(value));
        } else {
            this.varCol(index).putStr(value);
        }
        this.skip(index);
    }

    @Override
    public void putSym(int index, CharSequence value) {
        this.assertType(index, 8);
        this.putSymbol0(index, value);
        this.skip(index);
    }

    private void assertType(int index, int columnType) {
        if (this.meta[index].type != columnType) {
            throw new JournalRuntimeException("Expected type: " + this.meta[index].type, new Object[0]);
        }
    }

    private FixedColumn fixCol(int index) {
        return (FixedColumn)Unsafe.arrayGet(this.columns, index);
    }

    private ColumnMetadata meta(int index) {
        return Unsafe.arrayGet(this.meta, index);
    }

    private void putBin0(int index, InputStream value) {
        this.varCol(index).putBin(value);
    }

    private void putInt0(int index, int value) {
        if (this.meta((int)index).indexed) {
            int h = value & this.meta((int)index).distinctCountHint;
            Unsafe.arrayPut(this.koTuple, index * 2, h < 0 ? (long)(-h) : (long)h);
            Unsafe.arrayPut(this.koTuple, index * 2 + 1, this.fixCol(index).putInt(value));
        } else {
            this.fixCol(index).putInt(value);
        }
    }

    private void putLong0(int index, long value) {
        if (this.meta((int)index).indexed) {
            int h = (int)(value & (long)this.meta((int)index).distinctCountHint);
            Unsafe.arrayPut(this.koTuple, index * 2, h < 0 ? (long)(-h) : (long)h);
            Unsafe.arrayPut(this.koTuple, index * 2 + 1, this.fixCol(index).putLong(value));
        } else {
            this.fixCol(index).putLong(value);
        }
    }

    private void putNullStr(int index) {
        if (this.meta((int)index).indexed) {
            Unsafe.arrayPut(this.koTuple, index * 2, -1L);
            Unsafe.arrayPut(this.koTuple, index * 2 + 1, this.varCol(index).putNull());
        } else {
            this.varCol(index).putNull();
        }
    }

    private void putSymbol0(int index, CharSequence value) {
        int key = value == null ? -1 : this.meta((int)index).symbolTable.put(value);
        if (this.meta((int)index).indexed) {
            this.koTuple[index * 2] = key;
            this.koTuple[index * 2 + 1] = this.fixCol(index).putInt(key);
        } else {
            this.fixCol(index).putInt(key);
        }
    }

    void setPartition(Partition partition, long timestamp) {
        if (this.partition != partition) {
            this.columns = partition.columns;
            this.partition = partition;
            this.indexProxies = partition.sparseIndexProxies;
        }
        this.timestamp = timestamp;
        Arrays.fill(this.skipped, true);
        if (this.timestampIndex != -1) {
            this.putDate(this.timestampIndex, timestamp);
        }
    }

    private void skip(int index) {
        Unsafe.arrayPut(this.skipped, index, false);
    }

    private VariableColumn varCol(int index) {
        return (VariableColumn)Unsafe.arrayGet(this.columns, index);
    }
}

