/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.query.OrderedResultSetBuilder;
import com.questdb.store.query.iter.JournalBufferedIterator;
import com.questdb.store.query.iter.JournalConcurrentIterator;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.store.query.iter.JournalIteratorImpl;
import com.questdb.store.query.iter.JournalIteratorRange;
import com.questdb.store.query.iter.JournalPeekingIterator;
import java.util.Iterator;

public final class JournalIterators {
    private JournalIterators() {
    }

    public static <T> JournalPeekingIterator<T> bufferedIterator(Journal<T> journal) {
        return new JournalBufferedIterator<T>(journal, JournalIterators.createRanges(journal));
    }

    public static <T> JournalPeekingIterator<T> bufferedIterator(Journal<T> journal, Interval interval) {
        return new JournalBufferedIterator<T>(journal, JournalIterators.createRanges(journal, interval));
    }

    public static <T> JournalPeekingIterator<T> bufferedIterator(Journal<T> journal, long rowid) {
        return new JournalBufferedIterator<T>(journal, JournalIterators.createRanges(journal, rowid));
    }

    public static <T> JournalConcurrentIterator<T> concurrentIterator(Journal<T> journal) {
        return new JournalConcurrentIterator<T>(journal, JournalIterators.createRanges(journal), 1024);
    }

    public static <T> JournalConcurrentIterator<T> concurrentIterator(Journal<T> journal, Interval interval) {
        return new JournalConcurrentIterator<T>(journal, JournalIterators.createRanges(journal, interval), 1024);
    }

    public static <T> JournalConcurrentIterator<T> concurrentIterator(Journal<T> journal, long rowid) {
        return new JournalConcurrentIterator<T>(journal, JournalIterators.createRanges(journal, rowid), 1024);
    }

    public static <T> JournalPeekingIterator<T> incrementBufferedIterator(Journal<T> journal) {
        try {
            long lo = journal.getMaxRowID();
            journal.refresh();
            return new JournalBufferedIterator<T>(journal, JournalIterators.createRanges(journal, journal.incrementRowID(lo)));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public static <T> JournalPeekingIterator<T> incrementIterator(Journal<T> journal) {
        try {
            long lo = journal.getMaxRowID();
            journal.refresh();
            return new JournalIteratorImpl<T>(journal, JournalIterators.createRanges(journal, journal.incrementRowID(lo)));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public static <T> JournalIterator<T> iterator(Journal<T> journal, Interval interval) {
        return new JournalIteratorImpl<T>(journal, JournalIterators.createRanges(journal, interval));
    }

    public static <T> JournalPeekingIterator<T> iterator(Journal<T> journal, long rowid) {
        return new JournalIteratorImpl<T>(journal, JournalIterators.createRanges(journal, rowid));
    }

    public static <T> Iterator<T> iterator(Journal<T> journal) {
        return new JournalIteratorImpl<T>(journal, JournalIterators.createRanges(journal));
    }

    private static <T> ObjList<JournalIteratorRange> createRanges(Journal<T> journal) {
        int partitionCount = journal.getPartitionCount();
        ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>(partitionCount);
        try {
            for (int i = 0; i < partitionCount; ++i) {
                Partition<T> p = journal.getPartition(i, true);
                long size = p.size();
                if (size <= 0L) continue;
                ranges.add(new JournalIteratorRange(p.getPartitionIndex(), 0L, size - 1L));
            }
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return ranges;
    }

    private static <T> ObjList<JournalIteratorRange> createRanges(Journal<T> journal, Interval interval) {
        final ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>();
        try {
            journal.iteratePartitions(new OrderedResultSetBuilder<T>(interval){

                @Override
                public void read(long lo, long hi) throws JournalException {
                    ranges.add(new JournalIteratorRange(this.partition.getPartitionIndex(), lo, hi));
                }
            });
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return ranges;
    }

    private static <T> ObjList<JournalIteratorRange> createRanges(Journal<T> journal, long lo) {
        ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>();
        int loPartitionID = Rows.toPartitionIndex(lo);
        long loLocalRowID = Rows.toLocalRowID(lo);
        try {
            int count = journal.getPartitionCount();
            for (int i = loPartitionID; i < count; ++i) {
                Partition<T> p;
                long size;
                long localRowID = 0L;
                if (i == loPartitionID) {
                    localRowID = loLocalRowID;
                }
                if ((size = (p = journal.getPartition(i, true)).size()) <= 0L) continue;
                ranges.add(new JournalIteratorRange(p.getPartitionIndex(), localRowID, size - 1L));
            }
            return ranges;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }
}

