/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ByteBuffers;
import java.nio.ByteBuffer;

public class JournalKey<T> {
    private final Class<T> modelClass;
    private final String name;
    private final int partitionBy;
    private final int recordHint;
    private final boolean ordered;

    public JournalKey(String name) {
        this(null, name);
    }

    public JournalKey(Class<T> clazz) {
        this(clazz, null);
    }

    public JournalKey(Class<T> clazz, String name) {
        this(clazz, name, 4);
    }

    public JournalKey(Class<T> clazz, String name, int partitionBy) {
        this(clazz, name, partitionBy, 0);
    }

    public JournalKey(Class<T> clazz, String name, int partitionBy, int recordHint) {
        this(clazz, name, partitionBy, recordHint, true);
    }

    public JournalKey(Class<T> clazz, String name, int partitionBy, int recordHint, boolean ordered) {
        this.modelClass = clazz;
        this.name = name == null ? clazz.getName() : name;
        this.partitionBy = partitionBy;
        this.recordHint = recordHint;
        this.ordered = ordered;
    }

    public static <X> JournalKey<X> fromBuffer(ByteBuffer buffer) {
        int locLen = buffer.getInt();
        char[] name = new char[locLen];
        for (int i = 0; i < name.length; ++i) {
            name[i] = buffer.getChar();
        }
        byte partitionBy = buffer.get();
        int recordHint = buffer.getInt();
        boolean ordered = buffer.get() == 1;
        return new JournalKey(null, new String(name), partitionBy, recordHint, ordered);
    }

    public int getBufferSize() {
        return 4 + 2 * (this.name == null ? 0 : this.name.length()) + 1 + 1 + 4;
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }

    public String getModelClassName() {
        return this.modelClass == null ? null : this.modelClass.getName();
    }

    public String getName() {
        return this.name;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getRecordHint() {
        return this.recordHint;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalKey that = (JournalKey)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return "JournalKey{modelClass=" + this.modelClass + ", name='" + this.name + '\'' + ", partitionBy=" + this.partitionBy + ", recordHint=" + this.recordHint + ", ordered=" + this.ordered + '}';
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void write(ByteBuffer buffer) {
        ByteBuffers.putStringDW(buffer, this.name);
        buffer.put((byte)this.partitionBy);
        buffer.putInt(this.recordHint);
        buffer.put((byte)(this.ordered ? 1 : 0));
    }
}

