/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.ex.IncompatibleJournalException;
import com.questdb.ex.JournalIOException;
import com.questdb.ex.JournalPartiallyMappedException;
import com.questdb.ex.JournalWriterAlreadyOpenException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.BlockingWaitStrategy;
import com.questdb.mp.SCSequence;
import com.questdb.mp.SPSequence;
import com.questdb.mp.Sequence;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.NamedDaemonThreadFactory;
import com.questdb.std.Numbers;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.FlexBufferSink;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.std.time.Interval;
import com.questdb.store.BSearchType;
import com.questdb.store.FixedColumn;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalEntryWriterImpl;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalListener;
import com.questdb.store.Lock;
import com.questdb.store.LockManager;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.Partition;
import com.questdb.store.TempPartition;
import com.questdb.store.Tx;
import com.questdb.store.TxLog;
import com.questdb.store.UnstructuredFile;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.query.ResultSet;
import com.questdb.store.query.iter.JournalConcurrentIterator;
import com.questdb.store.query.iter.MergingIterator;
import com.questdb.store.query.iter.PeekingIterator;
import com.questdb.store.query.iter.PeekingListIterator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class JournalWriter<T>
extends Journal<T> {
    private static final Log LOG = LogFactory.getLog(JournalWriter.class);
    private final long lagMillis;
    private final long lagSwellMillis;
    private final boolean checkOrder;
    private final PeekingListIterator<T> peekingListIterator = new PeekingListIterator();
    private final MergingIterator<T> mergingIterator = new MergingIterator();
    private final JournalEntryWriterImpl journalEntryWriter;
    private final File discardTxt;
    private Lock writeLock;
    private JournalListener journalListener;
    private boolean txActive = false;
    private int txPartitionIndex = -1;
    private long appendTimestampLo = -1L;
    private PartitionCleaner partitionCleaner;
    private boolean commitOnClose = true;
    private boolean doDiscard = true;
    private boolean doJournal = true;
    private Partition<T> appendPartition;
    private long appendTimestampHi = -1L;
    private RandomAccessFile discardTxtRaf;
    private FlexBufferSink discardSink;
    private boolean inError = false;

    public JournalWriter(JournalMetadata<T> metadata, File location) throws JournalException {
        super(metadata, location);
        if (metadata.isPartialMapped()) {
            this.close();
            throw JournalPartiallyMappedException.INSTANCE;
        }
        this.lagMillis = TimeUnit.HOURS.toMillis(this.getMetadata().getLag());
        this.lagSwellMillis = this.lagMillis * 3L;
        this.checkOrder = metadata.getKey().isOrdered() && this.getTimestampOffset() != -1L;
        this.journalEntryWriter = new JournalEntryWriterImpl(this);
        this.discardTxt = new File(location, "discard.txt");
        this.setSequentialAccess(true);
    }

    public void append(T obj) throws JournalException {
        if (obj == null) {
            throw new JournalException("Cannot append NULL to %s", this);
        }
        if (!this.txActive) {
            this.beginTx();
        }
        if (this.checkOrder) {
            long timestamp = this.getTimestamp(obj);
            if (timestamp > this.appendTimestampHi) {
                this.switchAppendPartition(timestamp);
            }
            if (timestamp < this.appendTimestampLo) {
                throw new JournalException("Cannot insert records out of order. maxHardTimestamp=%d (%s), timestamp=%d (%s): %s", this.appendTimestampLo, Dates.toString(this.appendTimestampLo), timestamp, Dates.toString(timestamp), this);
            }
            this.appendPartition.append(obj);
            this.appendTimestampLo = timestamp;
        } else {
            this.getAppendPartition().append(obj);
        }
    }

    @SafeVarargs
    public final void append(T ... objects) throws JournalException {
        for (int i = 0; i < objects.length; ++i) {
            this.append(objects[i]);
        }
    }

    public void append(ResultSet<T> resultSet) throws JournalException {
        if (this.isCompatible(resultSet.getJournal())) {
            for (Object obj : resultSet.bufferedIterator()) {
                this.append((T)obj);
            }
        } else {
            throw new JournalException("%s is incompatible with %s", this, resultSet.getJournal());
        }
    }

    public void append(Journal<T> journal) throws JournalException {
        try (JournalConcurrentIterator<T> iterator = JournalIterators.concurrentIterator(journal);){
            for (Object obj : iterator) {
                this.append((T)obj);
            }
        }
    }

    public void beginTx() {
        if (!this.txActive) {
            this.txActive = true;
            this.txPartitionIndex = this.nonLagPartitionCount() - 1;
        }
    }

    @Override
    public final void close() {
        if (this.open) {
            if (this.closeInterceptor != null && !this.closeInterceptor.canClose(this)) {
                return;
            }
            try {
                if (this.isCommitOnClose()) {
                    this.commit();
                }
                if (this.partitionCleaner != null) {
                    this.purgeTempPartitions();
                    this.partitionCleaner.halt();
                    this.partitionCleaner = null;
                }
                super.close();
                if (this.writeLock != null) {
                    LockManager.release(this.writeLock);
                    this.writeLock = null;
                }
                Misc.free(this.discardSink);
                Misc.free(this.discardTxtRaf);
            }
            catch (JournalException e) {
                throw new JournalRuntimeException(e);
            }
        }
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    void closePartitions() {
        super.closePartitions();
        this.appendPartition = null;
        this.appendTimestampHi = -1L;
    }

    @Override
    protected void configure() throws JournalException {
        this.writeLock = LockManager.lockExclusive(this.getLocation().getAbsolutePath());
        if (this.writeLock == null || !this.writeLock.isValid()) {
            this.close();
            LOG.error().$("Cannot obtain lock on ").$(this.getLocation().getAbsolutePath()).$();
            throw JournalWriterAlreadyOpenException.INSTANCE;
        }
        try {
            if (this.txLog.isEmpty()) {
                this.commit((byte)0, 0L, 0L);
            }
            this.txLog.head(this.tx);
            File meta = new File(this.getLocation(), "_meta2");
            if (!meta.exists()) {
                try (UnstructuredFile hb = new UnstructuredFile(meta, 12, 2);){
                    this.getMetadata().write(hb);
                }
            }
            super.configure();
            this.beginTx();
            this.rollback();
            this.rollbackPartitionDirs();
            if (this.tx.journalMaxRowID > 0L && this.getPartitionCount() <= Rows.toPartitionIndex(this.tx.journalMaxRowID)) {
                this.beginTx();
                this.commit();
            }
            if (this.getMetadata().getLag() != -1) {
                this.partitionCleaner = new PartitionCleaner(this, this.getLocation().getName());
                this.partitionCleaner.start();
            }
        }
        catch (JournalException e) {
            this.close();
            throw e;
        }
    }

    public void commit() throws JournalException {
        this.commit(false, -1L, -1L);
    }

    public void commit(boolean force, long txn, long txPin) throws JournalException {
        if (this.txActive) {
            this.commit(force ? (byte)1 : 0, txn, txPin);
            this.notifyTxListener();
            this.expireOpenFiles0();
            this.txActive = false;
        }
    }

    public void commitDurable() throws JournalException {
        this.commit(true, -1L, -1L);
    }

    public void compact() throws JournalException {
        int partitionCount = this.getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.getPartition(i, true).compact();
        }
    }

    public Partition<T> createPartition(Interval interval, int partitionIndex) throws JournalException {
        try {
            Partition result = new Partition(this, interval, partitionIndex, -1L, null, this.sequentialAccess).open();
            this.partitions.add(result);
            return result;
        }
        catch (JournalException e) {
            this.inError = true;
            throw e;
        }
    }

    public void disableCommitOnClose() {
        this.commitOnClose = false;
    }

    public JournalEntryWriter entryWriter() throws JournalException {
        return this.entryWriter(0L);
    }

    public JournalEntryWriter entryWriter(long timestamp) throws JournalException {
        if (!this.txActive) {
            this.beginTx();
        }
        if (this.checkOrder) {
            if (timestamp > this.appendTimestampHi) {
                this.switchAppendPartition(timestamp);
            }
            if (timestamp < this.appendTimestampLo) {
                throw new JournalException("Cannot insert records out of order. maxHardTimestamp=%d (%s), timestamp=%d (%s): %s", this.appendTimestampLo, Dates.toString(this.appendTimestampLo), timestamp, Dates.toString(timestamp), this);
            }
            this.journalEntryWriter.setPartition(this.appendPartition, timestamp);
            return this.journalEntryWriter;
        }
        this.journalEntryWriter.setPartition(this.getAppendPartition(), timestamp);
        return this.journalEntryWriter;
    }

    public Partition<T> getAppendPartition(long timestamp) throws JournalException {
        int sz = this.partitions.size();
        if (sz > 0) {
            Partition par = (Partition)this.partitions.getQuick(sz - 1);
            Interval interval = par.getInterval();
            if (interval == null || interval.contains(timestamp)) {
                return par.open().access();
            }
            if (interval.isBefore(timestamp)) {
                return this.createPartition(new Interval(timestamp, this.getMetadata().getPartitionBy()), sz);
            }
            throw new JournalException("%s cannot be appended to %s", Dates.toString(timestamp), this);
        }
        return this.createPartition(new Interval(timestamp, this.getMetadata().getPartitionBy()), 0);
    }

    public long getAppendTimestampLo() throws JournalException {
        if (this.appendTimestampLo == -1L) {
            if (this.nonLagPartitionCount() == 0) {
                return 0L;
            }
            FixedColumn column = this.lastNonEmptyNonLag().getTimestampColumn();
            long sz = column.size();
            if (sz > 0L) {
                this.appendTimestampLo = column.getLong(sz - 1L);
            } else {
                return 0L;
            }
        }
        return this.appendTimestampLo;
    }

    public boolean isCommitOnClose() {
        return this.commitOnClose;
    }

    public boolean isInError() {
        return this.inError;
    }

    public boolean isTxActive() {
        return this.txActive;
    }

    public void mergeAppend(List<T> list) throws JournalException {
        this.peekingListIterator.setDelegate(list);
        this.mergeAppend(this.peekingListIterator);
    }

    public void mergeAppend(ResultSet<T> resultSet) throws JournalException {
        this.mergeAppend(resultSet.bufferedIterator());
    }

    public void mergeAppend(PeekingIterator<T> data) throws JournalException {
        long hard;
        if (this.lagMillis == 0L) {
            throw new JournalException("This journal is not configured to have lag partition", new Object[0]);
        }
        this.beginTx();
        if (data == null || data.isEmpty()) {
            return;
        }
        long dataMaxTimestamp = this.getTimestamp(data.peekLast());
        if (dataMaxTimestamp < (hard = this.getAppendTimestampLo())) {
            return;
        }
        Partition<PeekingIterator<T>> lagPartition = this.openOrCreateLagPartition();
        this.doDiscard = true;
        this.doJournal = true;
        long dataMinTimestamp = this.getTimestamp(data.peekFirst());
        long lagMaxTimestamp = this.getMaxTimestamp();
        long lagMinTimestamp = lagPartition.size() == 0L ? 0L : this.getTimestamp(lagPartition.read(0L));
        long soft = Math.max(dataMaxTimestamp, lagMaxTimestamp) - this.lagMillis;
        if (dataMinTimestamp > lagMaxTimestamp) {
            long lagSizeMillis = hard > 0L ? dataMaxTimestamp - hard : (lagMinTimestamp > 0L ? dataMaxTimestamp - lagMinTimestamp : 0L);
            if (lagSizeMillis > this.lagSwellMillis) {
                Partition<T> tempPartition = this.createTempPartition().open();
                this.splitAppend(lagPartition.bufferedIterator(), hard, soft, tempPartition);
                this.splitAppend(data, hard, soft, tempPartition);
                this.replaceIrregularPartition(tempPartition);
            } else {
                lagPartition.append(data);
            }
        } else {
            Partition<T> tempPartition = this.createTempPartition().open();
            if (dataMinTimestamp > lagMinTimestamp && dataMaxTimestamp < lagMaxTimestamp) {
                long lagMid1 = lagPartition.indexOf(dataMinTimestamp, BSearchType.OLDER_OR_SAME);
                long lagMid2 = lagPartition.indexOf(dataMaxTimestamp, BSearchType.NEWER_OR_SAME);
                this.splitAppend(lagPartition.bufferedIterator(0L, lagMid1), hard, soft, tempPartition);
                this.splitAppendMerge(data, lagPartition.bufferedIterator(lagMid1 + 1L, lagMid2 - 1L), hard, soft, tempPartition);
                this.splitAppend(lagPartition.bufferedIterator(lagMid2, lagPartition.size() - 1L), hard, soft, tempPartition);
            } else if (dataMaxTimestamp < lagMinTimestamp && dataMaxTimestamp <= lagMinTimestamp) {
                this.splitAppend(data, hard, soft, tempPartition);
                this.splitAppend(lagPartition.bufferedIterator(), hard, soft, tempPartition);
            } else if (dataMinTimestamp <= lagMinTimestamp && dataMaxTimestamp < lagMaxTimestamp) {
                long split = lagPartition.indexOf(dataMaxTimestamp, BSearchType.NEWER_OR_SAME);
                this.splitAppendMerge(data, lagPartition.bufferedIterator(0L, split - 1L), hard, soft, tempPartition);
                this.splitAppend(lagPartition.bufferedIterator(split, lagPartition.size() - 1L), hard, soft, tempPartition);
            } else if (dataMinTimestamp > lagMinTimestamp && dataMaxTimestamp >= lagMaxTimestamp) {
                long split = lagPartition.indexOf(dataMinTimestamp, BSearchType.OLDER_OR_SAME);
                this.splitAppend(lagPartition.bufferedIterator(0L, split), hard, soft, tempPartition);
                this.splitAppendMerge(data, lagPartition.bufferedIterator(split + 1L, lagPartition.size() - 1L), hard, soft, tempPartition);
            } else if (dataMinTimestamp <= lagMinTimestamp && dataMaxTimestamp >= lagMaxTimestamp) {
                this.splitAppendMerge(data, lagPartition.bufferedIterator(), hard, soft, tempPartition);
            } else {
                throw new JournalRuntimeException("Unsupported overlap type: lag min/max [%s/%s] data min/max: [%s/%s]", Dates.toString(lagMinTimestamp), Dates.toString(lagMaxTimestamp), Dates.toString(dataMinTimestamp), Dates.toString(dataMaxTimestamp));
            }
            this.replaceIrregularPartition(tempPartition);
        }
    }

    public void notifyListener(int event) {
        if (this.journalListener != null) {
            try {
                this.journalListener.onEvent(event);
            }
            catch (Throwable e) {
                LOG.error().$("Error in listener").$(e).$();
            }
        }
    }

    public Partition<T> openOrCreateLagPartition() throws JournalException {
        Partition result = this.getIrregularPartition();
        if (result == null) {
            result = this.createTempPartition();
            this.setIrregularPartition(result);
        }
        return result.open();
    }

    public void purgeTempPartitions() {
        this.partitionCleaner.purge();
    }

    public void rebuildIndexes() throws JournalException {
        int partitionCount = this.getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.getPartition(i, true).rebuildIndexes();
        }
    }

    public void removeIrregularPartition() {
        this.beginTx();
        this.removeIrregularPartitionInternal();
    }

    public void rollback() throws JournalException {
        if (this.txActive) {
            this.rollback0(this.txLog.getCurrentTxAddress(), false);
            this.txActive = false;
        }
    }

    public void rollback(long txn, long txPin) throws JournalException {
        this.rollback0(this.txLog.findAddress(txn, txPin), true);
    }

    public void setJournalListener(JournalListener journalListener) {
        this.journalListener = journalListener;
    }

    public void truncate() throws JournalException {
        int i;
        this.beginTx();
        int partitionCount = this.getPartitionCount();
        for (i = 0; i < partitionCount; ++i) {
            Partition partition = this.getPartition(i, true);
            partition.truncate(0L);
            partition.close();
            Files.deleteOrException(partition.getPartitionDir());
        }
        this.closePartitions();
        int sz = this.getSymbolTableCount();
        for (i = 0; i < sz; ++i) {
            this.getSymbolTable(i).truncate();
        }
        this.appendTimestampLo = -1L;
        this.commitDurable();
    }

    private void commit(byte command, long txn, long txPin) throws JournalException {
        int i;
        boolean force = command == 1;
        Partition partition = this.lastNonEmptyNonLag();
        Partition lag = this.getIrregularPartition();
        this.tx.command = command;
        this.tx.txn = txn;
        this.tx.txPin = txPin;
        this.tx.prevTxAddress = this.txLog.getCurrentTxAddress();
        this.tx.journalMaxRowID = partition == null ? -1L : Rows.toRowID(partition.getPartitionIndex(), partition.size());
        this.tx.lastPartitionTimestamp = partition == null || partition.getInterval() == null ? 0L : partition.getInterval().getLo();
        this.tx.lagSize = lag == null ? 0L : lag.open().size();
        this.tx.lagName = lag == null ? null : lag.getName();
        int len = this.getSymbolTableCount();
        if (this.tx.symbolTableSizes == null || this.tx.symbolTableSizes.length < len) {
            this.tx.symbolTableSizes = new int[len];
        }
        if (this.tx.symbolTableIndexPointers == null || this.tx.symbolTableIndexPointers.length < len) {
            this.tx.symbolTableIndexPointers = new long[len];
        }
        for (i = 0; i < this.tx.symbolTableSizes.length; ++i) {
            MMappedSymbolTable tab = this.getSymbolTable(i);
            tab.commit();
            if (force) {
                tab.force();
            }
            this.tx.symbolTableSizes[i] = tab.size();
            this.tx.symbolTableIndexPointers[i] = tab.getIndexTxAddress();
        }
        if (this.tx.indexPointers == null) {
            this.tx.indexPointers = new long[this.metadata.getColumnCount()];
        }
        int sz = this.nonLagPartitionCount();
        for (i = Math.max(this.txPartitionIndex, 0); i < sz; ++i) {
            Partition p = this.getPartition(i, true);
            p.commit();
            if (!force) continue;
            p.force();
        }
        if (partition != null) {
            partition.getIndexPointers(this.tx.indexPointers);
        }
        if (this.tx.lagIndexPointers == null) {
            this.tx.lagIndexPointers = new long[this.tx.indexPointers.length];
        }
        if (lag != null) {
            lag.commit();
            if (force) {
                lag.force();
            }
            lag.getIndexPointers(this.tx.lagIndexPointers);
        }
        this.txLog.write(this.tx, txn != -1L);
        if (force) {
            this.txLog.force();
        }
    }

    private Partition<T> createTempPartition() {
        return this.createTempPartition("temp." + System.currentTimeMillis() + '.' + UUID.randomUUID());
    }

    private Partition<T> getAppendPartition() throws JournalException {
        if (this.appendPartition != null) {
            return this.appendPartition;
        }
        int count = this.nonLagPartitionCount();
        if (count > 0) {
            this.appendPartition = this.getPartition(count - 1, true);
            return this.appendPartition;
        }
        if (this.getMetadata().getPartitionBy() != 3) {
            throw new JournalException("getAppendPartition() without timestamp on partitioned journal: %s", this);
        }
        this.appendPartition = this.createPartition(new Interval(0L, this.getMetadata().getPartitionBy()), 0);
        return this.appendPartition;
    }

    private void notifyTxListener() {
        if (this.journalListener != null) {
            this.journalListener.onCommit();
        }
    }

    private void replaceIrregularPartition(Partition<T> temp) {
        this.setIrregularPartition(temp);
        this.purgeTempPartitions();
    }

    private void rollback0(long address, boolean writeDiscard) throws JournalException {
        if (address == -1L) {
            this.notifyListener(4);
            throw new IncompatibleJournalException("Server txn is not compatible with %s", this.getLocation());
        }
        this.txLog.read(address, this.tx);
        if (this.tx.address == 0L) {
            throw new JournalException("Invalid transaction address", new Object[0]);
        }
        if (writeDiscard) {
            LOG.info().$("Journal ").$(this.getName()).$(" is rolling back to transaction ").$(this.tx.txn).$(", timestamp ").$ts(this.tx.timestamp).$();
            this.writeDiscardFile(this.tx.journalMaxRowID);
        }
        this.rollbackPartitions(this.tx);
        Partition lag = this.getIrregularPartition();
        if (!(this.tx.lagName == null || this.tx.lagName.length() <= 0 || lag != null && this.tx.lagName.equals(lag.getName()))) {
            TempPartition newLag = this.createTempPartition(this.tx.lagName);
            this.setIrregularPartition(newLag);
            newLag.applyTx(this.tx.lagSize, this.tx.lagIndexPointers);
        } else if (lag != null && this.tx.lagName == null) {
            this.removeIrregularPartitionInternal();
        } else if (lag != null) {
            lag.truncate(this.tx.lagSize);
        }
        if (this.tx.symbolTableSizes.length == 0) {
            int sz = this.getSymbolTableCount();
            for (int i = 0; i < sz; ++i) {
                this.getSymbolTable(i).truncate();
            }
        } else {
            int sz = this.getSymbolTableCount();
            for (int i = 0; i < sz; ++i) {
                this.getSymbolTable(i).truncate(this.tx.symbolTableSizes[i]);
            }
        }
        this.appendTimestampLo = -1L;
        this.appendTimestampHi = -1L;
        this.appendPartition = null;
        this.txLog.writeTxAddress(this.tx.address);
        this.txActive = false;
    }

    private void rollbackPartitionDirs() throws JournalException {
        Object[] files = this.getLocation().listFiles(f -> f.isDirectory() && !f.getName().startsWith("temp"));
        if (files != null) {
            Arrays.sort(files);
            for (int i = this.getPartitionCount(); i < files.length; ++i) {
                Files.deleteOrException((File)files[i]);
            }
        }
    }

    private void rollbackPartitions(Tx tx) throws JournalException {
        Partition p;
        int partitionIndex;
        int n = partitionIndex = tx.journalMaxRowID == -1L ? 0 : Rows.toPartitionIndex(tx.journalMaxRowID);
        while ((p = (Partition)this.partitions.getLast()) != null) {
            if (p.getPartitionIndex() > partitionIndex) {
                p.close();
                Files.deleteOrException(p.getPartitionDir());
                this.partitions.remove(this.partitions.size() - 1);
                continue;
            }
            if (p.getPartitionIndex() != partitionIndex) break;
            p.open();
            p.truncate(tx.journalMaxRowID == -1L ? 0L : Rows.toLocalRowID(tx.journalMaxRowID));
            break;
        }
    }

    private void splitAppend(Iterator<T> it, long hard, long soft, Partition<T> partition) throws JournalException {
        while (it.hasNext()) {
            T obj = it.next();
            if (this.doDiscard && this.getTimestamp(obj) < hard) continue;
            if (this.doDiscard) {
                this.doDiscard = false;
            }
            if (this.doJournal && this.getTimestamp(obj) < soft) {
                this.append(obj);
                continue;
            }
            if (this.doJournal) {
                this.doJournal = false;
            }
            partition.append(obj);
        }
    }

    private void splitAppendMerge(Iterator<T> a, Iterator<T> b, long hard, long soft, Partition<T> temp) throws JournalException {
        this.splitAppend(this.mergingIterator.$new(a, b, this.getTimestampComparator()), hard, soft, temp);
    }

    private void switchAppendPartition(long timestamp) throws JournalException {
        boolean computeTimestampLo = this.appendPartition == null;
        this.appendPartition = this.getAppendPartition(timestamp);
        Interval interval = this.appendPartition.getInterval();
        this.appendTimestampHi = interval == null ? Long.MAX_VALUE : interval.getHi();
        if (computeTimestampLo) {
            FixedColumn column = this.appendPartition.getTimestampColumn();
            long sz = column.size();
            if (sz > 0L) {
                this.appendTimestampLo = column.getLong(sz - 1L);
            }
        } else {
            this.appendTimestampLo = this.appendPartition.getInterval().getLo();
        }
    }

    void updateTsLo(long ts) {
        if (this.checkOrder) {
            this.appendTimestampLo = ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDiscardFile(long rowid) throws JournalException {
        if (this.discardTxtRaf == null) {
            try {
                this.discardTxtRaf = new RandomAccessFile(this.discardTxt, "rw");
                FileChannel ch = this.discardTxtRaf.getChannel();
                this.discardSink = new FlexBufferSink(ch.position(ch.size()), 0x100000);
            }
            catch (IOException e) {
                LOG.error().$(e).$();
                throw JournalIOException.INSTANCE;
            }
        }
        JournalMetadata m = this.getMetadata();
        long row = Rows.toLocalRowID(rowid);
        long rowCount = 0L;
        try {
            try {
                int n = this.getPartitionCount() - 1;
                for (int p = Rows.toPartitionIndex(rowid); p < n; ++p) {
                    Partition partition = this.getPartition(n, true);
                    long psz = partition.size();
                    for (long r = row; r < psz; ++r) {
                        int cc = m.getColumnCount();
                        for (int c = 0; c < cc; ++c) {
                            switch (m.getColumnQuick((int)c).type) {
                                case 10: {
                                    DateFormatUtils.appendDateTime(this.discardSink, partition.getLong(r, c));
                                    break;
                                }
                                case 2: {
                                    Numbers.append((CharSink)this.discardSink, partition.getDouble(r, c), 12);
                                    break;
                                }
                                case 3: {
                                    Numbers.append((CharSink)this.discardSink, partition.getFloat(r, c), 4);
                                    break;
                                }
                                case 4: {
                                    Numbers.append((CharSink)this.discardSink, partition.getInt(r, c));
                                    break;
                                }
                                case 7: {
                                    partition.getStr(r, c, this.discardSink);
                                    break;
                                }
                                case 8: {
                                    this.discardSink.put(partition.getSym(r, c));
                                    break;
                                }
                                case 6: {
                                    Numbers.append((CharSink)this.discardSink, partition.getShort(r, c));
                                    break;
                                }
                                case 5: {
                                    Numbers.append((CharSink)this.discardSink, partition.getLong(r, c));
                                    break;
                                }
                                case 1: {
                                    Numbers.append((CharSink)this.discardSink, partition.getByte(r, c));
                                    break;
                                }
                                case 0: {
                                    this.discardSink.put(partition.getBool(r, c) ? "true" : "false");
                                    break;
                                }
                            }
                            if ((++rowCount & 7L) != 0L) continue;
                            this.discardSink.flush();
                        }
                    }
                }
            }
            finally {
                this.discardSink.flush();
            }
        }
        catch (IOException e) {
            LOG.error().$(e).$();
            throw JournalIOException.INSTANCE;
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    private static class PartitionCleaner {
        private final ExecutorService executor;
        private final Sequence pubSeq;
        private final Sequence subSeq;
        private final JournalWriter writer;
        private final CountDownLatch haltLatch = new CountDownLatch(1);
        private volatile TxLog txLog;
        private volatile boolean running = false;

        public PartitionCleaner(JournalWriter writer, String name) throws JournalException {
            this.executor = Executors.newCachedThreadPool(new NamedDaemonThreadFactory("questdb-journal-cleaner-" + name, false));
            this.writer = writer;
            this.pubSeq = new SPSequence(32);
            this.subSeq = new SCSequence(new BlockingWaitStrategy());
            this.pubSeq.then(this.subSeq).then(this.pubSeq);
            this.txLog = new TxLog(writer.getLocation(), 0, writer.getMetadata().getTxCountHint());
        }

        public void halt() {
            this.executor.shutdown();
            this.subSeq.getWaitStrategy().alert();
            try {
                if (this.running) {
                    this.haltLatch.await();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void purge() {
            this.pubSeq.done(this.pubSeq.nextBully());
        }

        public void start() {
            this.running = true;
            this.executor.submit(this::lambda$start$1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$start$1() {
            try {
                try {
                    block7: while (true) {
                        this.subSeq.done(this.subSeq.waitForNext());
                        if (this.txLog == null) continue;
                        tx1 = new Tx();
                        v0 = lagPartitionName = this.writer.hasIrregularPartition() != false ? this.writer.getIrregularPartition().getName() : null;
                        files = this.writer.getLocation().listFiles((FileFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;)Z, lambda$null$0(java.lang.String java.io.File ), (Ljava/io/File;)Z)((String)lagPartitionName));
                        if (files == null) continue;
                        Arrays.sort(files);
                        i = 0;
                        while (true) {
                            block15: {
                                block16: {
                                    if (i < files.length) ** break;
                                    continue block7;
                                    if (this.txLog.isEmpty()) break block16;
                                    this.txLog.head(tx1);
                                    if (files[i].getName().equals(tx1.lagName)) break block15;
                                }
                                lock = LockManager.lockExclusive(files[i].getAbsolutePath());
                                try {
                                    if (lock != null && lock.isValid()) {
                                        JournalWriter.access$000().debug().$("Purging :").$(files[i].getAbsolutePath()).$();
                                        if (!Files.delete((File)files[i])) {
                                            JournalWriter.access$000().debug().$("Could not purge: ").$(files[i].getAbsolutePath()).$();
                                        }
                                    } else {
                                        JournalWriter.access$000().debug().$("Partition in use: ").$(files[i].getAbsolutePath()).$();
                                    }
                                }
                                finally {
                                    LockManager.release(lock);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable ignore) {
                    this.running = false;
                    this.haltLatch.countDown();
                    this.txLog = Misc.free(this.txLog);
                }
            }
            catch (Throwable var7_8) {
                this.txLog = Misc.free(this.txLog);
                throw var7_8;
            }
        }

        private static /* synthetic */ boolean lambda$null$0(String lagPartitionName, File f) {
            return f.isDirectory() && f.getName().startsWith("temp") && (lagPartitionName == null || !lagPartitionName.equals(f.getName()));
        }
    }
}

