/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Files;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.IndexCursor;
import com.questdb.store.MemoryFile;
import java.io.Closeable;
import java.io.File;

public class KVIndex
implements Closeable {
    private static final int ENTRY_SIZE = 32;
    private final RevIndexCursor cachedCursor = new RevIndexCursor();
    private final FwdIndexCursor fwdIndexCursor = new FwdIndexCursor();
    private final int rowBlockSize;
    private final int rowBlockLen;
    private final MemoryFile kData;
    private final MemoryFile rData;
    private final int mask;
    private final int bits;
    private long firstEntryOffset;
    private long keyBlockSize;
    private long keyBlockAddressOffset;
    private long keyBlockSizeOffset;
    private long maxValue;
    private boolean startTx = true;

    public KVIndex(File baseName, long keyCountHint, long recordCountHint, int txCountHint, int journalMode, long txAddress, boolean sequentialAccess) throws JournalException {
        int keyCount = (int)Math.min(Integer.MAX_VALUE, Math.max(keyCountHint, 1L));
        this.kData = new MemoryFile(new File(baseName.getParentFile(), baseName.getName() + ".k"), ByteBuffers.getBitHint(8, keyCount * txCountHint), journalMode, sequentialAccess);
        this.keyBlockAddressOffset = 8L;
        if (this.kData.getAppendOffset() > 0L) {
            this.rowBlockLen = (int)this.getLong(this.kData, 0L);
            this.keyBlockSizeOffset = txAddress == 0L ? this.getLong(this.kData, this.keyBlockAddressOffset) : txAddress;
            this.keyBlockSize = this.getLong(this.kData, this.keyBlockSizeOffset);
            this.maxValue = this.getLong(this.kData, this.keyBlockSizeOffset + 8L);
        } else if (journalMode == 2) {
            int l = (int)(recordCountHint / (long)keyCount);
            this.rowBlockLen = l < 1 ? 1 : Numbers.ceilPow2(l);
            this.keyBlockSizeOffset = 16L;
            this.keyBlockSize = 0L;
            this.maxValue = 0L;
            this.putLong(this.kData, 0L, this.rowBlockLen);
            this.putLong(this.kData, this.keyBlockAddressOffset, this.keyBlockSizeOffset);
            this.putLong(this.kData, this.keyBlockSizeOffset, this.keyBlockSize);
            this.putLong(this.kData, this.keyBlockSizeOffset + 8L, this.maxValue);
            this.kData.setAppendOffset(32L);
        } else {
            this.kData.close();
            throw new JournalException("Cannot open uninitialized index in read-only mode", new Object[0]);
        }
        this.mask = this.rowBlockLen - 1;
        this.bits = Numbers.msb(this.rowBlockLen);
        this.firstEntryOffset = this.keyBlockSizeOffset + 16L;
        this.rowBlockSize = this.rowBlockLen * 8 + 16;
        try {
            this.rData = new MemoryFile(new File(baseName.getParentFile(), baseName.getName() + ".r"), ByteBuffers.getBitHint(this.rowBlockSize, keyCount), journalMode, sequentialAccess);
        }
        catch (JournalException e) {
            this.kData.close();
            throw e;
        }
    }

    public static void delete(File base) {
        Files.delete(new File(base.getParentFile(), base.getName() + ".k"));
        Files.delete(new File(base.getParentFile(), base.getName() + ".r"));
    }

    public void add(int key, long value) {
        long keyOffset;
        if (this.startTx) {
            this.tx();
        }
        if ((keyOffset = this.getKeyOffset(key)) >= this.firstEntryOffset + this.keyBlockSize) {
            this.keyBlockSize = keyOffset + 32L - this.firstEntryOffset;
        }
        long address = this.kData.addressOf(keyOffset, 32);
        long rowBlockOffset = Unsafe.getUnsafe().getLong(address);
        long rowCount = Unsafe.getUnsafe().getLong(address + 8L);
        int cellIndex = (int)(rowCount & (long)this.mask);
        if (rowBlockOffset == 0L || cellIndex == 0) {
            rowBlockOffset = this.allocateRowBlock(address, rowBlockOffset);
        }
        Unsafe.getUnsafe().putLong(this.rData.addressOf(rowBlockOffset - (long)this.rowBlockSize + (long)(8 * cellIndex), 8), value);
        Unsafe.getUnsafe().putLong(address + 8L, rowCount + 1L);
        if (this.maxValue <= value) {
            this.maxValue = value + 1L;
        }
    }

    @Override
    public void close() {
        this.rData.close();
        this.kData.close();
    }

    public void commit() {
        if (!this.startTx) {
            this.putLong(this.kData, this.keyBlockSizeOffset, this.keyBlockSize);
            this.putLong(this.kData, this.keyBlockSizeOffset + 8L, this.maxValue);
            this.kData.setAppendOffset(this.firstEntryOffset + this.keyBlockSize);
            this.putLong(this.kData, this.keyBlockAddressOffset, this.keyBlockSizeOffset);
            this.startTx = true;
        }
    }

    public void compact() throws JournalException {
        this.kData.compact();
        this.rData.compact();
    }

    public boolean contains(int key) {
        return this.getValueCount(key) > 0;
    }

    public IndexCursor cursor(int key) {
        return this.cachedCursor.setKey(key);
    }

    public void force() {
        this.kData.force();
    }

    public FwdIndexCursor fwdCursor(int key) {
        return this.fwdIndexCursor.setKey(key);
    }

    public long getTxAddress() {
        return this.keyBlockSizeOffset;
    }

    public void setTxAddress(long txAddress) {
        if (txAddress == 0L) {
            this.refresh();
        } else {
            this.keyBlockSizeOffset = txAddress;
            this.keyBlockSize = this.getLong(this.kData, this.keyBlockSizeOffset);
            this.maxValue = this.getLong(this.kData, this.keyBlockSizeOffset + 8L);
            this.firstEntryOffset = this.keyBlockSizeOffset + 16L;
        }
    }

    public int getValueCount(int key) {
        long keyOffset = this.getKeyOffset(key);
        if (keyOffset >= this.firstEntryOffset + this.keyBlockSize) {
            return 0;
        }
        return (int)this.getLong(this.kData, keyOffset + 8L);
    }

    public long getValueQuick(int key, int i) {
        long address = this.keyAddressOrError(key);
        long rowBlockOffset = Unsafe.getUnsafe().getLong(address);
        long rowCount = Unsafe.getUnsafe().getLong(address + 8L);
        if ((long)i >= rowCount) {
            throw new JournalRuntimeException("Index out of bounds: %d, max: %d", i, rowCount - 1L);
        }
        int rowBlockCount = (int)((rowCount >>> this.bits) + 1L);
        if ((rowCount & (long)this.mask) == 0L) {
            --rowBlockCount;
        }
        int targetBlock = i >>> this.bits;
        int cellIndex = i & this.mask;
        while (targetBlock < --rowBlockCount) {
            if ((rowBlockOffset = this.getLong(this.rData, rowBlockOffset - 8L)) != 0L) continue;
            throw new JournalRuntimeException("Count doesn't match number of row blocks. Corrupt index? : %s", this);
        }
        return this.getLong(this.rData, rowBlockOffset - (long)this.rowBlockSize + (long)(8 * cellIndex));
    }

    public LongList getValues(int key) {
        LongList result = new LongList();
        this.getValues(key, result);
        return result;
    }

    public void getValues(int key, LongList values) {
        if (key < 0) {
            return;
        }
        long keyOffset = this.getKeyOffset(key);
        if (keyOffset >= this.firstEntryOffset + this.keyBlockSize) {
            return;
        }
        long address = this.kData.addressOf(keyOffset, 32);
        long rowBlockOffset = Unsafe.getUnsafe().getLong(address);
        long rowCount = Unsafe.getUnsafe().getLong(address + 8L);
        values.clear();
        values.setPos((int)rowCount);
        int rowBlockCount = (int)(rowCount >>> this.bits) + 1;
        int len = (int)(rowCount & (long)this.mask);
        if (len == 0) {
            --rowBlockCount;
            len = this.rowBlockLen;
        }
        for (int i = rowBlockCount - 1; i >= 0; --i) {
            address = this.rData.addressOf(rowBlockOffset - (long)this.rowBlockSize, this.rowBlockSize);
            int z = i << this.bits;
            for (int k = 0; k < len; ++k) {
                values.set(z + k, Unsafe.getUnsafe().getLong(address));
                address += 8L;
            }
            if (i > 0) {
                rowBlockOffset = Unsafe.getUnsafe().getLong(address + (long)((this.rowBlockLen - len) * 8) + 8L);
            }
            len = this.rowBlockLen;
        }
    }

    public long lastValue(int key) {
        long address = this.keyAddressOrError(key);
        long rowBlockOffset = Unsafe.getUnsafe().getLong(address);
        long rowCount = Unsafe.getUnsafe().getLong(address + 8L);
        int cellIndex = (int)(rowCount - 1L & (long)this.mask);
        return this.getLong(this.rData, rowBlockOffset - (long)this.rowBlockSize + (long)(8 * cellIndex));
    }

    public FwdIndexCursor newFwdCursor(int key) {
        FwdIndexCursor cursor = new FwdIndexCursor();
        cursor.setKey(key);
        return cursor;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.kData.setSequentialAccess(sequentialAccess);
        this.rData.setSequentialAccess(sequentialAccess);
    }

    public long size() {
        return this.maxValue;
    }

    public void truncate(long size) {
        long sz = 0L;
        for (long offset = this.firstEntryOffset; offset < this.firstEntryOffset + this.keyBlockSize; offset += 32L) {
            long keyBlockAddress = this.kData.addressOf(offset, 32);
            long rowBlockOffset = Unsafe.getUnsafe().getLong(keyBlockAddress);
            long rowCount = Unsafe.getUnsafe().getLong(keyBlockAddress + 8L);
            int len = (int)(rowCount & (long)this.mask);
            if (len == 0) {
                len = this.rowBlockLen;
            }
            while (rowBlockOffset > 0L) {
                long v;
                int pos;
                long rowAddress;
                long addr = rowAddress = this.rData.addressOf(rowBlockOffset - (long)this.rowBlockSize, this.rowBlockSize);
                long max = -1L;
                for (pos = 0; pos < len && (v = Unsafe.getUnsafe().getLong(addr)) < size; ++pos) {
                    addr += 8L;
                    max = v;
                }
                if (max >= sz) {
                    sz = max + 1L;
                }
                if (pos == 0) {
                    rowBlockOffset = Unsafe.getUnsafe().getLong(rowAddress + (long)this.rowBlockSize - 8L);
                    rowCount -= (long)len;
                    len = this.rowBlockLen;
                    continue;
                }
                rowCount -= (long)(len - pos);
                break;
            }
            Unsafe.getUnsafe().putLong(keyBlockAddress, rowBlockOffset);
            Unsafe.getUnsafe().putLong(keyBlockAddress + 8L, rowCount);
        }
        this.maxValue = sz;
        this.commit();
    }

    private long allocateRowBlock(long address, long rowBlockOffset) {
        long offset = this.rData.getAppendOffset() + (long)this.rowBlockSize;
        this.rData.setAppendOffset(offset);
        Unsafe.getUnsafe().putLong(this.rData.addressOf(offset - 8L, 8), rowBlockOffset);
        Unsafe.getUnsafe().putLong(address, offset);
        if (rowBlockOffset == 0L) {
            Unsafe.getUnsafe().putLong(address + 16L, offset);
        } else {
            Unsafe.getUnsafe().putLong(this.rData.addressOf(rowBlockOffset - 16L, 8), offset);
        }
        return offset;
    }

    private long getKeyOffset(long key) {
        return this.firstEntryOffset + (key + 1L) * 32L;
    }

    private long getLong(MemoryFile storage, long offset) {
        return Unsafe.getUnsafe().getLong(storage.addressOf(offset, 8));
    }

    private long keyAddressOrError(int key) {
        long keyOffset = this.getKeyOffset(key);
        if (keyOffset >= this.firstEntryOffset + this.keyBlockSize) {
            throw new JournalRuntimeException("Key doesn't exist: %d", key);
        }
        return this.kData.addressOf(keyOffset, 32);
    }

    private void putLong(MemoryFile storage, long offset, long value) {
        Unsafe.getUnsafe().putLong(storage.addressOf(offset, 8), value);
    }

    private void refresh() {
        this.commit();
        this.keyBlockSizeOffset = this.getLong(this.kData, this.keyBlockAddressOffset);
        this.keyBlockSize = this.getLong(this.kData, this.keyBlockSizeOffset);
        this.maxValue = this.getLong(this.kData, this.keyBlockSizeOffset + 8L);
        this.firstEntryOffset = this.keyBlockSizeOffset + 16L;
    }

    private void tx() {
        if (this.startTx) {
            this.keyBlockSizeOffset = this.kData.getAppendOffset();
            this.firstEntryOffset = this.keyBlockSizeOffset + 16L;
            long srcOffset = this.getLong(this.kData, this.keyBlockAddressOffset);
            long dstOffset = this.keyBlockSizeOffset;
            int size = (int)(this.keyBlockSize + 8L + 8L);
            while (size > 0) {
                long src = this.kData.addressOf(srcOffset, 1);
                int srcLen = this.kData.pageRemaining(srcOffset);
                this.kData.lockBuffers();
                long dst = this.kData.addressOf(dstOffset, 1);
                int dstLen = this.kData.pageRemaining(dstOffset);
                this.kData.unlockBuffers();
                int len = size < (srcLen < dstLen ? srcLen : dstLen) ? size : (srcLen < dstLen ? srcLen : dstLen);
                Unsafe.getUnsafe().copyMemory(src, dst, len);
                size -= len;
                srcOffset += (long)len;
                dstOffset += (long)len;
            }
            this.keyBlockSize = dstOffset - this.firstEntryOffset;
        }
        this.startTx = false;
    }

    private class FwdIndexCursor
    implements IndexCursor {
        private long rowCount;
        private long size;
        private long address;

        private FwdIndexCursor() {
        }

        public FwdIndexCursor setKey(int key) {
            this.rowCount = 0L;
            this.size = 0L;
            if (key < -1) {
                return this;
            }
            long keyOffset = KVIndex.this.getKeyOffset(key);
            if (keyOffset >= KVIndex.this.firstEntryOffset + KVIndex.this.keyBlockSize) {
                return this;
            }
            long addr = KVIndex.this.kData.addressOf(keyOffset, 32);
            this.size = Unsafe.getUnsafe().getLong(addr + 8L);
            if (this.size == 0L) {
                return this;
            }
            this.rowCount = 0L;
            this.address = KVIndex.this.rData.addressOf(Unsafe.getUnsafe().getLong(addr + 16L) - (long)KVIndex.this.rowBlockSize, KVIndex.this.rowBlockSize);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.rowCount < this.size;
        }

        @Override
        public long next() {
            int r = (int)(this.rowCount++ & (long)KVIndex.this.mask);
            long v = Unsafe.getUnsafe().getLong(this.address + (long)(r << 3));
            if (r == KVIndex.this.mask && this.rowCount < this.size) {
                this.address = KVIndex.this.rData.addressOf(Unsafe.getUnsafe().getLong(this.address + (long)(KVIndex.this.rowBlockLen << 3)) - (long)KVIndex.this.rowBlockSize, KVIndex.this.rowBlockSize);
            }
            return v;
        }

        @Override
        public long size() {
            return this.size;
        }
    }

    private class RevIndexCursor
    implements IndexCursor {
        private int remainingBlockCount;
        private int remainingRowCount;
        private long size;
        private long address;

        private RevIndexCursor() {
        }

        @Override
        public boolean hasNext() {
            return this.remainingRowCount > 0 || this.remainingBlockCount > 0;
        }

        public RevIndexCursor setKey(int key) {
            this.remainingBlockCount = 0;
            this.remainingRowCount = 0;
            if (key < 0) {
                return this;
            }
            long keyOffset = KVIndex.this.getKeyOffset(key);
            if (keyOffset < KVIndex.this.firstEntryOffset + KVIndex.this.keyBlockSize) {
                long addr = KVIndex.this.kData.addressOf(keyOffset, 32);
                this.size = Unsafe.getUnsafe().getLong(addr + 8L);
                if (this.size == 0L) {
                    return this;
                }
                int k = (int)(this.size & (long)KVIndex.this.mask);
                if (k == 0) {
                    this.remainingBlockCount = (int)(this.size >>> KVIndex.this.bits) - 1;
                    this.remainingRowCount = KVIndex.this.rowBlockLen;
                } else {
                    this.remainingBlockCount = (int)(this.size >>> KVIndex.this.bits);
                    this.remainingRowCount = k;
                }
                this.address = KVIndex.this.rData.addressOf(Unsafe.getUnsafe().getLong(addr) - (long)KVIndex.this.rowBlockSize, KVIndex.this.rowBlockSize);
            }
            return this;
        }

        @Override
        public long next() {
            if (this.remainingRowCount > 0) {
                return Unsafe.getUnsafe().getLong(this.address + (long)(--this.remainingRowCount << 3));
            }
            --this.remainingBlockCount;
            this.address = KVIndex.this.rData.addressOf(Unsafe.getUnsafe().getLong(this.address + (long)(KVIndex.this.rowBlockLen << 3) + 8L) - (long)KVIndex.this.rowBlockSize, KVIndex.this.rowBlockSize);
            this.remainingRowCount = KVIndex.this.mask;
            return Unsafe.getUnsafe().getLong(this.address + (long)(this.remainingRowCount << 3));
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

