/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicInteger;

public final class Lock {
    private static final Log LOG = LogFactory.getLog(Lock.class);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private RandomAccessFile file;
    private FileLock lock;
    private File lockName;
    private String location;

    Lock(String location, boolean shared) {
        try {
            this.location = location;
            this.lockName = new File(location + ".lock");
            this.file = new RandomAccessFile(this.lockName, "rw");
            int i = 0;
            while (true) {
                try {
                    this.lock = this.file.getChannel().tryLock(i, 1L, shared);
                }
                catch (OverlappingFileLockException e) {
                    if (shared) {
                        ++i;
                        continue;
                    }
                    this.lock = null;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public synchronized boolean isValid() {
        return this.lock != null && this.lock.isValid();
    }

    public String toString() {
        return "Lock{lockName=" + this.lockName + ", isShared=" + (this.lock == null ? "NULL" : Boolean.valueOf(this.lock.isShared())) + ", isValid=" + (this.lock == null ? "NULL" : Boolean.valueOf(this.lock.isValid())) + ", refCount=" + this.refCount.get() + '}';
    }

    void decrementRefCount() {
        this.refCount.decrementAndGet();
    }

    synchronized void delete() {
        if (!this.lockName.delete()) {
            LOG.error().$("Could not delete lock: ").$(this.lockName).$();
        }
    }

    String getLocation() {
        return this.location;
    }

    int getRefCount() {
        return this.refCount.get();
    }

    void incrementRefCount() {
        this.refCount.incrementAndGet();
    }

    synchronized void release() {
        try {
            if (this.isValid()) {
                this.lock.release();
                this.lock = null;
            }
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }
}

