/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.store.Lock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LockManager {
    private static final Log LOG = LogFactory.getLog(LockManager.class);
    private static final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();

    private LockManager() {
    }

    public static Lock lockExclusive(String location) {
        String sharedKey = LockManager.getKey(location, true);
        String exclusiveKey = LockManager.getKey(location, false);
        if (locks.get(sharedKey) != null || locks.get(exclusiveKey) != null) {
            return null;
        }
        Lock lock = new Lock(location, false);
        locks.put(exclusiveKey, lock);
        lock.incrementRefCount();
        LOG.debug().$("Exclusive lock successful: ").$(lock).$();
        return lock;
    }

    public static Lock lockShared(String location) {
        String sharedKey = LockManager.getKey(location, true);
        String exclusiveKey = LockManager.getKey(location, false);
        Lock lock = locks.get(sharedKey);
        if (lock == null) {
            lock = locks.get(exclusiveKey);
            if (lock != null) {
                return null;
            }
            lock = new Lock(location, true);
            locks.put(sharedKey, lock);
        }
        lock.incrementRefCount();
        LOG.debug().$("Shared lock was successful: ").$(lock).$();
        return lock;
    }

    public static void release(Lock lock) {
        Lock storedExclusiveLock;
        if (lock == null) {
            return;
        }
        String loc = lock.getLocation();
        String sharedKey = LockManager.getKey(loc, true);
        String exclusiveKey = LockManager.getKey(loc, false);
        Lock storedSharedLock = locks.get(sharedKey);
        if (storedSharedLock == lock) {
            lock.decrementRefCount();
            if (lock.getRefCount() < 1) {
                lock.release();
                locks.remove(sharedKey);
                LOG.debug().$("Shared lock released: ").$(lock).$();
            }
        }
        if ((storedExclusiveLock = locks.get(exclusiveKey)) == lock) {
            lock.decrementRefCount();
            if (lock.getRefCount() < 1) {
                lock.release();
                lock.delete();
                locks.remove(exclusiveKey);
                LOG.debug().$("Exclusive lock released: ").$(lock).$();
            }
        }
    }

    private static String getKey(String location, boolean shared) {
        return (shared ? "ShLck:" : "ExLck:") + location;
    }
}

