/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.SymbolTable;
import com.questdb.ex.JournalInvalidSymbolValueException;
import com.questdb.std.ByteBuffers;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Hash;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.MemoryFile;
import com.questdb.store.VariableColumn;
import java.io.Closeable;
import java.io.File;

public class MMappedSymbolTable
implements Closeable,
SymbolTable {
    private static final String DATA_FILE_SUFFIX = ".symd";
    private static final String INDEX_FILE_SUFFIX = ".symi";
    private static final String HASH_INDEX_FILE_SUFFIX = ".symr";
    private static final double CACHE_LOAD_FACTOR = 0.2;
    private final int hashKeyCount;
    private final String column;
    private final CharSequenceIntHashMap valueCache;
    private final ObjList<String> keyCache;
    private final boolean noCache;
    private final Iter iter = new Iter();
    private final VariableColumn data;
    private final KVIndex index;
    private int size;
    private boolean open = true;

    public MMappedSymbolTable(int keyCount, int avgStringSize, int txCountHint, File directory, String column, int journalMode, int size, long indexTxAddress, boolean noCache, boolean sequentialAccess) throws JournalException {
        MemoryFile indexFile;
        this.hashKeyCount = Numbers.ceilPow2(Math.max(2, (int)((double)keyCount * 0.2))) - 1;
        this.column = column;
        this.noCache = noCache;
        MemoryFile dataFile = new MemoryFile(new File(directory, column + DATA_FILE_SUFFIX), ByteBuffers.getBitHint(avgStringSize * 2 + 4, keyCount), journalMode, sequentialAccess);
        try {
            indexFile = new MemoryFile(new File(directory, column + INDEX_FILE_SUFFIX), ByteBuffers.getBitHint(8, keyCount), journalMode, sequentialAccess);
        }
        catch (JournalException e) {
            dataFile.close();
            throw e;
        }
        this.data = new VariableColumn(dataFile, indexFile);
        this.size = size;
        try {
            this.index = new KVIndex(new File(directory, column + HASH_INDEX_FILE_SUFFIX), this.hashKeyCount, keyCount, txCountHint, journalMode, indexTxAddress, sequentialAccess);
        }
        catch (JournalException e) {
            this.data.close();
            throw e;
        }
        this.valueCache = new CharSequenceIntHashMap(noCache ? 0 : keyCount, 0.5, -2);
        this.keyCache = new ObjList(noCache ? 0 : keyCount);
    }

    public void alignSize() {
        this.size = (int)this.data.size();
    }

    public void applyTx(int size, long indexTxAddress) {
        this.size = size;
        this.index.setTxAddress(indexTxAddress);
    }

    @Override
    public void close() {
        if (this.open) {
            Misc.free(this.data);
            Misc.free(this.index);
            this.open = false;
        }
    }

    public void commit() {
        this.data.commit();
        this.index.commit();
    }

    public void force() {
        this.data.force();
        this.index.force();
    }

    public int get(CharSequence value) {
        int result = this.getQuick(value);
        if (result == -2) {
            throw new JournalInvalidSymbolValueException("Invalid value %s for symbol %s", value, this.column);
        }
        return result;
    }

    public VariableColumn getDataColumn() {
        return this.data;
    }

    public long getIndexTxAddress() {
        return this.index.getTxAddress();
    }

    @Override
    public int getQuick(CharSequence value) {
        int key;
        if (value == null) {
            return -1;
        }
        if (!this.noCache && (key = this.valueCache.get(value)) != -2) {
            return key;
        }
        return this.get0(value);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String value(int key) {
        if (key < 0) {
            return null;
        }
        if (key < this.size) {
            String value;
            String string = value = key < this.keyCache.size() ? this.keyCache.getQuick(key) : null;
            if (value == null) {
                value = this.data.getStr(key);
                this.cache(key, value);
            }
            return value;
        }
        throw new JournalRuntimeException("Invalid symbol key: " + key, new Object[0]);
    }

    public MMappedSymbolTable preLoad() {
        int size = (int)this.data.size();
        for (int key = 0; key < size; ++key) {
            String value = this.data.getStr(key);
            this.valueCache.putIfAbsent(value, key);
            this.keyCache.add(value);
        }
        return this;
    }

    public int put(CharSequence value) {
        int key = this.getQuick(value);
        if (key == -2) {
            key = (int)this.data.putStr(value);
            this.data.commit();
            this.index.add(this.hashKey(value), key);
            ++this.size;
            this.cache(key, value.toString());
        }
        return key;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.data.setSequentialAccess(sequentialAccess);
        this.index.setSequentialAccess(sequentialAccess);
    }

    public void truncate() {
        this.truncate(0);
    }

    public void truncate(int size) {
        if (this.size() > size) {
            this.data.truncate(size);
            this.index.truncate(size);
            this.data.commit();
            this.clearCache();
            this.size = size;
        }
    }

    public void updateIndex(int oldSize, int newSize) {
        if (oldSize < newSize) {
            for (int i = oldSize; i < newSize; ++i) {
                this.index.add(this.hashKey(this.data.getStr(i)), i);
            }
        }
    }

    public boolean valueExists(CharSequence value) {
        return this.getQuick(value) != -2;
    }

    public Iterable<Entry> values() {
        this.iter.pos = 0;
        this.iter.size = this.size();
        return this.iter;
    }

    private void cache(int key, String value) {
        if (this.noCache) {
            return;
        }
        this.valueCache.put(value, key);
        this.keyCache.extendAndSet(key, value);
    }

    private void clearCache() {
        this.valueCache.clear();
        this.keyCache.clear();
    }

    private int get0(CharSequence value) {
        int hashKey = this.hashKey(value);
        if (!this.index.contains(hashKey)) {
            return -2;
        }
        IndexCursor cursor = this.index.cursor(hashKey);
        while (cursor.hasNext()) {
            int key = (int)cursor.next();
            if (!this.data.cmpStr(key, value)) continue;
            this.cache(key, value.toString());
            return key;
        }
        return -2;
    }

    private int hashKey(CharSequence value) {
        return Hash.boundedHash(value, this.hashKeyCount);
    }

    private class Iter
    implements ImmutableIterator<Entry> {
        private final Entry e = new Entry();
        private int pos;
        private int size;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.size;
        }

        @Override
        public Entry next() {
            this.e.key = this.pos;
            this.e.value = MMappedSymbolTable.this.data.getFlyweightStr(this.pos++);
            return this.e;
        }
    }

    public static class Entry {
        public int key;
        public CharSequence value;
    }
}

