/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.ex.JournalIOException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.ByteBufferWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryFile
implements Closeable {
    private static final Log LOG = LogFactory.getLog(MemoryFile.class);
    private static final int DATA_OFFSET = 8;
    private final File file;
    private final int journalMode;
    private int bitHint;
    private FileChannel channel;
    private MappedByteBuffer offsetBuffer;
    private ObjList<MappedByteBuffer> buffers;
    private ObjList<ByteBufferWrapper> stitches;
    private MappedByteBuffer cachedBuffer;
    private long cachedBufferLo = -1L;
    private long cachedBufferHi = -1L;
    private long cachedAppendOffset = -1L;
    private long cachedAddress;
    private long cachedPointer;
    private long offsetDirectAddr;
    private boolean unlockedBuffers = true;
    private boolean sequentialAccess;

    public MemoryFile(File file, int bitHint, int journalMode, boolean sequentialAccess) throws JournalException {
        this.file = file;
        this.journalMode = journalMode;
        if (bitHint < 2) {
            LOG.info().$("BitHint is too small for ").$(file).$();
        }
        this.bitHint = bitHint;
        long size = this.open();
        this.buffers = new ObjList((int)(size >>> this.bitHint) + 1);
        this.stitches = new ObjList(this.buffers.size());
        this.sequentialAccess = sequentialAccess;
    }

    public long addressOf(long offset, int size) {
        if (offset > this.cachedBufferLo && offset + (long)size < this.cachedBufferHi) {
            return this.cachedPointer + offset;
        }
        return this.allocateAddress(offset, size);
    }

    @Override
    public void close() {
        this.unmap();
        this.channel = Misc.free(this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws JournalException {
        this.close();
        try {
            this.openInternal("rw");
            try {
                long newSize = this.getAppendOffset() + 8L;
                this.offsetBuffer = ByteBuffers.release(this.offsetBuffer);
                LOG.debug().$("Compacting ").$(this).$(" to ").$(newSize).$(" bytes").$();
                this.channel.truncate(newSize).close();
            }
            catch (IOException e) {
                throw new JournalException("Could not compact %s to %d bytes", (Throwable)e, this.getFullFileName(), this.getAppendOffset());
            }
            finally {
                this.close();
            }
        }
        finally {
            this.open();
        }
    }

    public void delete() {
        this.close();
        Files.delete(this.file);
    }

    public void force() {
        int stitchesSize = this.stitches.size();
        this.offsetBuffer.force();
        int k = this.buffers.size();
        for (int i = 0; i < k; ++i) {
            ByteBufferWrapper s;
            MappedByteBuffer b = this.buffers.getQuick(i);
            if (b != null) {
                b.force();
            }
            if (i >= stitchesSize || (s = this.stitches.getQuick(i)) == null) continue;
            s.getByteBuffer().force();
        }
    }

    public long getAppendOffset() {
        if (this.cachedAppendOffset != -1L && this.journalMode == 2) {
            return this.cachedAppendOffset;
        }
        if (this.offsetBuffer != null) {
            this.cachedAppendOffset = Unsafe.getUnsafe().getLong(this.offsetDirectAddr);
            return this.cachedAppendOffset;
        }
        return -1L;
    }

    public void setAppendOffset(long offset) {
        this.cachedAppendOffset = offset;
        Unsafe.getUnsafe().putLong(this.offsetDirectAddr, this.cachedAppendOffset);
    }

    public MappedByteBuffer getBuffer(long offset) {
        if (offset > this.cachedBufferLo && offset + 1L < this.cachedBufferHi) {
            this.cachedBuffer.position((int)(offset - this.cachedBufferLo - 1L));
        } else {
            this.cachedBuffer = this.getBufferInternal(offset, 1);
            this.cachedBufferLo = offset - (long)this.cachedBuffer.position() - 1L;
            this.cachedBufferHi = this.cachedBufferLo + (long)this.cachedBuffer.limit() + 2L;
            this.cachedAddress = ByteBuffers.getAddress(this.cachedBuffer);
            this.cachedPointer = this.cachedAddress - this.cachedBufferLo - 1L;
        }
        return this.cachedBuffer;
    }

    public void lockBuffers() {
        this.unlockedBuffers = false;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.sequentialAccess = sequentialAccess;
    }

    public String toString() {
        return this.getClass().getName() + "[file=" + this.file + ", appendOffset=" + this.getAppendOffset() + ']';
    }

    public void unlockBuffers() {
        this.unlockedBuffers = true;
    }

    private long allocateAddress(long offset, int size) {
        this.cachedBuffer = this.getBufferInternal(offset, size);
        int p = this.cachedBuffer.position();
        this.cachedBufferLo = offset - (long)p - 1L;
        this.cachedBufferHi = this.cachedBufferLo + (long)this.cachedBuffer.limit() + 2L;
        this.cachedAddress = ByteBuffers.getAddress(this.cachedBuffer);
        this.cachedPointer = this.cachedAddress - this.cachedBufferLo - 1L;
        return this.cachedAddress + (long)p;
    }

    private MappedByteBuffer createMappedBuffer(int index, int bufferSize, long bufferOffset) {
        MappedByteBuffer buffer = this.mapBufferInternal(bufferOffset, bufferSize);
        assert (bufferSize > 0);
        this.buffers.extendAndSet(index, buffer);
        if (this.unlockedBuffers && this.sequentialAccess) {
            this.releasePrevBuffers(index);
        }
        return buffer;
    }

    private MappedByteBuffer createStitchBuffer(int size, int index, long stitchOffset) {
        ByteBufferWrapper bufferWrapper = this.stitches.getQuiet(index);
        if (bufferWrapper != null) {
            if (bufferWrapper.getOffset() != stitchOffset || bufferWrapper.getByteBuffer().limit() < size) {
                bufferWrapper.close();
                bufferWrapper = null;
            } else {
                bufferWrapper.getByteBuffer().rewind();
            }
        }
        if (bufferWrapper == null) {
            bufferWrapper = new ByteBufferWrapper(stitchOffset, this.mapBufferInternal(stitchOffset, size));
            this.stitches.extendAndSet(index, bufferWrapper);
        }
        return bufferWrapper.getByteBuffer();
    }

    private MappedByteBuffer getBufferInternal(long offset, int size) {
        int bufferSize = 1 << this.bitHint;
        int index = (int)(offset >>> this.bitHint);
        long bufferOffset = (long)index << (int)((long)this.bitHint);
        int bufferPos = (int)(offset - bufferOffset);
        MappedByteBuffer buffer = this.buffers.getQuiet(index);
        if (buffer != null && buffer.limit() < bufferPos) {
            buffer = ByteBuffers.release(buffer);
        }
        if (buffer == null) {
            buffer = this.createMappedBuffer(index, bufferSize, bufferOffset);
        }
        buffer.position(bufferPos);
        if (buffer.remaining() < size) {
            return this.createStitchBuffer(size, index, bufferOffset + (long)bufferPos);
        }
        return buffer;
    }

    private String getFullFileName() {
        return this.file.getAbsolutePath();
    }

    private MappedByteBuffer mapBufferInternal(long offset, int size) {
        long actualOffset = offset + 8L;
        try {
            MappedByteBuffer buf;
            switch (this.journalMode) {
                case 0: {
                    long sz = actualOffset + (long)size > this.channel.size() ? this.channel.size() - actualOffset : (long)size;
                    assert (sz > 0L);
                    buf = this.channel.map(FileChannel.MapMode.READ_ONLY, actualOffset, sz);
                    break;
                }
                default: {
                    buf = this.channel.map(FileChannel.MapMode.READ_WRITE, actualOffset, size);
                }
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf;
        }
        catch (IOException e) {
            throw new JournalRuntimeException("Failed to memory map: %s", (Throwable)e, this.file.getAbsolutePath());
        }
    }

    private long open() throws JournalException {
        return this.openInternal(this.journalMode == 0 ? "r" : "rw");
    }

    private long openInternal(String mode) throws JournalException {
        long size;
        File pf = this.file.getParentFile();
        if (pf == null) {
            throw new JournalException("Expected a file: " + this.file, new Object[0]);
        }
        if (!pf.exists() && !pf.mkdirs()) {
            throw new JournalException("Could not create directories: %s", this.file.getParentFile().getAbsolutePath());
        }
        try {
            this.channel = new RandomAccessFile(this.file, mode).getChannel();
        }
        catch (FileNotFoundException e) {
            LOG.error().$(e).$();
            throw JournalIOException.INSTANCE;
        }
        try {
            size = this.channel.size();
        }
        catch (IOException e) {
            LOG.error().$(e).$();
            throw JournalIOException.INSTANCE;
        }
        try {
            this.offsetBuffer = "r".equals(mode) ? this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(size, 8L)) : this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, 8L);
            this.offsetBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.offsetDirectAddr = ByteBuffers.getAddress(this.offsetBuffer);
            long offset = this.getAppendOffset();
            if (offset > 0L) {
                if (offset > Integer.MAX_VALUE) {
                    this.bitHint = 30;
                } else {
                    int hint = Numbers.msb((int)offset) + 1;
                    if (hint < 0 || hint > 30) {
                        this.bitHint = 30;
                    } else if (hint > this.bitHint) {
                        this.bitHint = hint;
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException ignore) {
                LOG.error().$("Cannot close channel").$();
            }
            this.channel = null;
            LOG.error().$(e).$();
            throw JournalIOException.INSTANCE;
        }
        return size;
    }

    int pageRemaining(long offset) {
        if (offset > this.cachedBufferLo && offset < this.cachedBufferHi) {
            return (int)(this.cachedBufferHi - offset - 1L);
        }
        return 0;
    }

    private void releasePrevBuffers(int index) {
        MappedByteBuffer mb;
        this.cachedBuffer = null;
        this.cachedBufferHi = -1L;
        this.cachedBufferLo = -1L;
        int ssz = this.stitches.size();
        for (int i = index - 1; i > -1 && (mb = this.buffers.getQuick(i)) != null; --i) {
            this.buffers.setQuick(i, ByteBuffers.release(mb));
            if (i >= ssz) continue;
            Misc.free(this.stitches.getAndSetQuick(i, null));
        }
    }

    private void unmap() {
        int i;
        int k = this.buffers.size();
        for (i = 0; i < k; ++i) {
            ByteBuffers.release((ByteBuffer)this.buffers.getQuick(i));
        }
        k = this.stitches.size();
        for (i = 0; i < k; ++i) {
            Misc.free(this.stitches.getQuick(i));
        }
        this.cachedBuffer = null;
        this.cachedBufferHi = -1L;
        this.cachedBufferLo = -1L;
        this.buffers.clear();
        this.stitches.clear();
        this.offsetBuffer = ByteBuffers.release(this.offsetBuffer);
        assert (this.offsetBuffer == null);
    }
}

