/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.DirectInputStream;
import com.questdb.std.Hash;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.Dates;
import com.questdb.std.time.Interval;
import com.questdb.store.AbstractColumn;
import com.questdb.store.BSearchType;
import com.questdb.store.FixedColumn;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.KVIndex;
import com.questdb.store.MemoryFile;
import com.questdb.store.SymbolIndexProxy;
import com.questdb.store.VariableColumn;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.query.iter.PartitionBufferedIterator;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class Partition<T>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Partition.class);
    private final Journal<T> journal;
    private final ObjList<SymbolIndexProxy<T>> indexProxies = new ObjList();
    private final Interval interval;
    private final int columnCount;
    private final ColumnMetadata[] columnMetadata;
    SymbolIndexProxy<T>[] sparseIndexProxies;
    AbstractColumn[] columns;
    private int partitionIndex;
    private File partitionDir;
    private long lastAccessed = System.currentTimeMillis();
    private long txLimit;
    private FixedColumn timestampColumn;
    private boolean sequentialAccess;

    Partition(Journal<T> journal, Interval interval, int partitionIndex, long txLimit, long[] indexTxAddresses, boolean sequentialAccess) {
        JournalMetadata<T> meta = journal.getMetadata();
        this.journal = journal;
        this.partitionIndex = partitionIndex;
        this.interval = interval;
        this.txLimit = txLimit;
        this.columnCount = meta.getColumnCount();
        this.columnMetadata = new ColumnMetadata[this.columnCount];
        meta.copyColumnMetadata(this.columnMetadata);
        if (interval != null) {
            this.setPartitionDir(new File(this.journal.getLocation(), interval.getDirName(meta.getPartitionBy())), indexTxAddresses);
        }
        this.sequentialAccess = sequentialAccess;
    }

    public void applyTx(long txLimit, long[] indexTxAddresses) {
        if (this.txLimit != txLimit) {
            this.txLimit = txLimit;
            int k = this.indexProxies.size();
            for (int i = 0; i < k; ++i) {
                SymbolIndexProxy<T> proxy = this.indexProxies.getQuick(i);
                proxy.setTxAddress(indexTxAddresses == null ? 0L : indexTxAddresses[proxy.getColumnIndex()]);
            }
        }
    }

    public PartitionBufferedIterator<T> bufferedIterator() {
        return new PartitionBufferedIterator(this, 0L, this.size() - 1L);
    }

    public PartitionBufferedIterator<T> bufferedIterator(long lo, long hi) {
        return new PartitionBufferedIterator(this, lo, hi);
    }

    @Override
    public void close() {
        int i;
        if (this.isOpen()) {
            for (i = 0; i < this.columns.length; ++i) {
                Misc.free(Unsafe.arrayGet(this.columns, i));
            }
            this.columns = null;
            LOG.debug().$("Partition").$(this.partitionDir).$(" is closed").$();
        }
        int k = this.indexProxies.size();
        for (i = 0; i < k; ++i) {
            Misc.free(this.indexProxies.getQuick(i));
        }
    }

    public void commitColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            AbstractColumn col = Unsafe.arrayGet(this.columns, i);
            if (col == null) continue;
            col.commit();
        }
    }

    public void compact() throws JournalException {
        int i;
        if (this.columns == null || this.columns.length == 0) {
            throw new JournalException("Cannot compact closed partition: %s", this);
        }
        for (i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.columns[i].compact();
        }
        int k = this.indexProxies.size();
        for (i = 0; i < k; ++i) {
            this.indexProxies.getQuick(i).getIndex().compact();
        }
    }

    public FixedColumn fixCol(int i) {
        return (FixedColumn)Unsafe.arrayGet(this.columns, i);
    }

    public AbstractColumn getAbstractColumn(int i) {
        return Unsafe.arrayGet(this.columns, i);
    }

    public void getBin(long localRowID, int columnIndex, OutputStream s) {
        this.varCol(columnIndex).getBin(localRowID, s);
    }

    public DirectInputStream getBin(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getBin(localRowID);
    }

    public long getBinLen(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getBinLen(localRowID);
    }

    public boolean getBool(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getBool(localRowID);
    }

    public byte getByte(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getByte(localRowID);
    }

    public double getDouble(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getDouble(localRowID);
    }

    public float getFloat(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getFloat(localRowID);
    }

    public CharSequence getFlyweightStr(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getFlyweightStr(localRowID);
    }

    public CharSequence getFlyweightStrB(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getFlyweightStrB(localRowID);
    }

    public KVIndex getIndexForColumn(String columnName) throws JournalException {
        return this.getIndexForColumn(this.journal.getMetadata().getColumnIndex(columnName));
    }

    public KVIndex getIndexForColumn(int columnIndex) throws JournalException {
        SymbolIndexProxy<T> h = this.sparseIndexProxies[columnIndex];
        if (h == null) {
            throw new JournalException("There is no index for column '%s' in %s", this.columnMetadata[columnIndex].name, this);
        }
        return h.getIndex();
    }

    public int getInt(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getInt(localRowID);
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Journal<T> getJournal() {
        return this.journal;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getLong(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getLong(localRowID);
    }

    public String getName() {
        return this.partitionDir.getName();
    }

    public File getPartitionDir() {
        return this.partitionDir;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public void setPartitionIndex(int partitionIndex) {
        this.partitionIndex = partitionIndex;
    }

    public short getShort(long localRowID, int columnIndex) {
        return this.fixCol(columnIndex).getShort(localRowID);
    }

    public String getStr(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getStr(localRowID);
    }

    public void getStr(long localRowID, int columnIndex, CharSink sink) {
        this.varCol(columnIndex).getStr(localRowID, sink);
    }

    public int getStrLen(long localRowID, int columnIndex) {
        return this.varCol(columnIndex).getStrLen(localRowID);
    }

    public CharSequence getSym(long localRowID, int columnIndex) {
        int symbolIndex = this.fixCol(columnIndex).getInt(localRowID);
        switch (symbolIndex) {
            case -2: 
            case -1: {
                return null;
            }
        }
        return this.columnMetadata[columnIndex].symbolTable.value(symbolIndex);
    }

    public FixedColumn getTimestampColumn() {
        if (this.timestampColumn == null) {
            throw new JournalRuntimeException("There is no timestamp column in: " + this, new Object[0]);
        }
        return this.timestampColumn;
    }

    public long indexOf(long timestamp, BSearchType type) {
        return this.getTimestampColumn().bsearchEdge(timestamp, type);
    }

    public long indexOf(long timestamp, BSearchType type, long lo, long hi) {
        return this.getTimestampColumn().bsearchEdge(timestamp, type, lo, hi);
    }

    public boolean isOpen() {
        return this.columns != null;
    }

    public Partition<T> open() throws JournalException {
        this.access();
        if (this.columns == null) {
            this.open0();
        }
        return this;
    }

    public T read(long localRowID) {
        T obj = this.journal.newObject();
        this.read(localRowID, obj);
        return obj;
    }

    public void read(long localRowID, T obj) {
        block12: for (int i = 0; i < this.columnCount; ++i) {
            if (this.journal.getInactiveColumns().get(i)) continue;
            ColumnMetadata m = Unsafe.arrayGet(this.columnMetadata, i);
            if (m.offset == 0L) continue;
            switch (m.type) {
                case 0: {
                    Unsafe.getUnsafe().putBoolean(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getBool(localRowID));
                    continue block12;
                }
                case 1: {
                    Unsafe.getUnsafe().putByte(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getByte(localRowID));
                    continue block12;
                }
                case 2: {
                    Unsafe.getUnsafe().putDouble(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getDouble(localRowID));
                    continue block12;
                }
                case 3: {
                    Unsafe.getUnsafe().putFloat(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getFloat(localRowID));
                    continue block12;
                }
                case 4: {
                    Unsafe.getUnsafe().putInt(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getInt(localRowID));
                    continue block12;
                }
                case 5: 
                case 10: {
                    Unsafe.getUnsafe().putLong(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getLong(localRowID));
                    continue block12;
                }
                case 6: {
                    Unsafe.getUnsafe().putShort(obj, m.offset, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).getShort(localRowID));
                    continue block12;
                }
                case 7: {
                    Unsafe.getUnsafe().putObject(obj, m.offset, ((VariableColumn)Unsafe.arrayGet(this.columns, i)).getStr(localRowID));
                    continue block12;
                }
                case 8: {
                    Unsafe.getUnsafe().putObject(obj, m.offset, m.symbolTable.value(((FixedColumn)Unsafe.arrayGet(this.columns, i)).getInt(localRowID)));
                    continue block12;
                }
                case 9: {
                    this.readBin(localRowID, obj, i, m);
                    continue block12;
                }
            }
        }
    }

    public void rebuildIndexes() throws JournalException {
        if (!this.isOpen()) {
            throw new JournalException("Cannot rebuild indexes in closed partition: %s", this);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!Unsafe.arrayGet(this.columnMetadata, (int)i).indexed) continue;
            this.rebuildIndex(i);
        }
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        int i;
        int n;
        this.sequentialAccess = sequentialAccess;
        if (this.columns != null) {
            n = this.columns.length;
            for (i = 0; i < n; ++i) {
                AbstractColumn c = Unsafe.arrayGet(this.columns, i);
                if (c == null) continue;
                c.setSequentialAccess(sequentialAccess);
            }
        }
        n = this.indexProxies.size();
        for (i = 0; i < n; ++i) {
            this.indexProxies.getQuick(i).setSequentialAccess(sequentialAccess);
        }
    }

    public long size() {
        if (!this.isOpen()) {
            throw new JournalRuntimeException("Closed partition: %s", this);
        }
        if (this.txLimit != -1L) {
            return this.txLimit;
        }
        long sz = 0L;
        for (int i = this.columns.length - 1; i > -1; --i) {
            AbstractColumn c = Unsafe.arrayGet(this.columns, i);
            if (c == null) continue;
            sz = c.size();
            break;
        }
        this.txLimit = sz;
        return sz;
    }

    public String toString() {
        return "Partition{partitionIndex=" + this.partitionIndex + ", open=" + this.isOpen() + ", partitionDir=" + this.partitionDir + ", interval=" + this.interval + ", lastAccessed=" + Dates.toString(this.lastAccessed) + '}';
    }

    public void updateIndexes(long oldSize, long newSize) {
        if (oldSize < newSize) {
            try {
                int k = this.indexProxies.size();
                for (int n = 0; n < k; ++n) {
                    SymbolIndexProxy<T> proxy = this.indexProxies.getQuick(n);
                    KVIndex index = proxy.getIndex();
                    FixedColumn col = this.fixCol(proxy.getColumnIndex());
                    for (long i = oldSize; i < newSize; ++i) {
                        index.add(col.getInt(i), i);
                    }
                    index.commit();
                }
            }
            catch (JournalException e) {
                throw new JournalRuntimeException(e);
            }
        }
    }

    public VariableColumn varCol(int i) {
        return (VariableColumn)Unsafe.arrayGet(this.columns, i);
    }

    Partition<T> access() {
        switch (this.journal.getMetadata().getPartitionBy()) {
            case 3: {
                return this;
            }
        }
        long t = System.currentTimeMillis();
        if (this.lastAccessed < t) {
            this.lastAccessed = t;
        }
        return this;
    }

    void append(Iterator<T> it) throws JournalException {
        while (it.hasNext()) {
            this.append(it.next());
        }
    }

    void append(T obj) throws JournalException {
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnMetadata m = Unsafe.arrayGet(this.columnMetadata, i);
                switch (m.type) {
                    case 5: {
                        long l = Unsafe.getUnsafe().getLong(obj, m.offset);
                        if (m.indexed) {
                            this.sparseIndexProxies[i].getIndex().add((int)(l & (long)m.distinctCountHint), ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putLong(l));
                            break;
                        }
                        ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putLong(l);
                        break;
                    }
                    case 4: {
                        int v = Unsafe.getUnsafe().getInt(obj, m.offset);
                        if (m.indexed) {
                            this.sparseIndexProxies[i].getIndex().add(v & m.distinctCountHint, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putInt(v));
                            break;
                        }
                        ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putInt(v);
                        break;
                    }
                    case 7: {
                        String s = (String)Unsafe.getUnsafe().getObject(obj, m.offset);
                        long offset = ((VariableColumn)Unsafe.arrayGet(this.columns, i)).putStr(s);
                        if (!m.indexed) break;
                        this.sparseIndexProxies[i].getIndex().add(s == null ? -1 : Hash.boundedHash(s, m.distinctCountHint), offset);
                        break;
                    }
                    case 8: {
                        String sym = (String)Unsafe.getUnsafe().getObject(obj, m.offset);
                        int key = sym == null ? -1 : m.symbolTable.put(sym);
                        if (m.indexed) {
                            this.sparseIndexProxies[i].getIndex().add(key, ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putInt(key));
                            break;
                        }
                        ((FixedColumn)Unsafe.arrayGet(this.columns, i)).putInt(key);
                        break;
                    }
                    case 9: {
                        this.appendBin(obj, i, m);
                        break;
                    }
                    default: {
                        ((FixedColumn)Unsafe.arrayGet(this.columns, i)).copy(obj, m.offset);
                    }
                }
                Unsafe.arrayGet(this.columns, i).commit();
            }
            this.applyTx(-1L, null);
        }
        catch (Throwable e) {
            ((JournalWriter)this.journal).rollback();
            throw e;
        }
    }

    private void appendBin(T obj, int i, ColumnMetadata meta) {
        ByteBuffer buf = (ByteBuffer)Unsafe.getUnsafe().getObject(obj, meta.offset);
        if (buf == null) {
            ((VariableColumn)Unsafe.arrayGet(this.columns, i)).putNull();
        } else {
            ((VariableColumn)Unsafe.arrayGet(this.columns, i)).putBin(buf);
        }
    }

    private void clearTx() {
        this.applyTx(-1L, null);
    }

    private void closePartiallyOpenColumns() {
        for (AbstractColumn c : this.columns) {
            if (c == null) continue;
            c.close();
            this.columns[i] = null;
        }
    }

    void commit() throws JournalException {
        int k = this.indexProxies.size();
        for (int i = 0; i < k; ++i) {
            this.indexProxies.getQuick(i).getIndex().commit();
        }
    }

    private void createSymbolIndexProxies(long[] indexTxAddresses) {
        this.indexProxies.clear();
        if (this.sparseIndexProxies == null || this.sparseIndexProxies.length != this.columnCount) {
            this.sparseIndexProxies = new SymbolIndexProxy[this.columnCount];
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (Unsafe.arrayGet(this.columnMetadata, (int)i).indexed) {
                SymbolIndexProxy proxy = new SymbolIndexProxy(this, i, indexTxAddresses == null ? 0L : indexTxAddresses[i]);
                this.indexProxies.add(proxy);
                this.sparseIndexProxies[i] = proxy;
                continue;
            }
            this.sparseIndexProxies[i] = null;
        }
    }

    void force() throws JournalException {
        int i;
        int k = this.indexProxies.size();
        for (i = 0; i < k; ++i) {
            this.indexProxies.getQuick(i).getIndex().force();
        }
        if (this.columns != null) {
            for (i = 0; i < this.columns.length; ++i) {
                AbstractColumn column = Unsafe.arrayGet(this.columns, i);
                if (column == null) continue;
                column.force();
            }
        }
    }

    void getIndexPointers(long[] pointers) throws JournalException {
        int k = this.indexProxies.size();
        for (int i = 0; i < k; ++i) {
            SymbolIndexProxy<T> proxy = this.indexProxies.getQuick(i);
            pointers[proxy.getColumnIndex()] = proxy.getIndex().getTxAddress();
        }
    }

    private void open0() throws JournalException {
        this.columns = new AbstractColumn[this.journal.getMetadata().getColumnCount()];
        try {
            block5: for (int i = 0; i < this.columns.length; ++i) {
                switch (Unsafe.arrayGet(this.columnMetadata, (int)i).type) {
                    case 7: 
                    case 9: {
                        Unsafe.arrayPut(this.columns, i, new VariableColumn(new MemoryFile(new File(this.partitionDir, Unsafe.arrayGet(this.columnMetadata, (int)i).name + ".d"), Unsafe.arrayGet(this.columnMetadata, (int)i).bitHint, this.journal.getMode(), this.sequentialAccess), new MemoryFile(new File(this.partitionDir, Unsafe.arrayGet(this.columnMetadata, (int)i).name + ".i"), Unsafe.arrayGet(this.columnMetadata, (int)i).indexBitHint, this.journal.getMode(), this.sequentialAccess)));
                        continue block5;
                    }
                    default: {
                        Unsafe.arrayPut(this.columns, i, new FixedColumn(new MemoryFile(new File(this.partitionDir, Unsafe.arrayGet(this.columnMetadata, (int)i).name + ".d"), Unsafe.arrayGet(this.columnMetadata, (int)i).bitHint, this.journal.getMode(), this.sequentialAccess), Unsafe.arrayGet(this.columnMetadata, (int)i).size));
                    }
                }
            }
        }
        catch (JournalException e) {
            this.closePartiallyOpenColumns();
            throw e;
        }
        int tsIndex = this.journal.getMetadata().getTimestampIndex();
        if (tsIndex > -1) {
            this.timestampColumn = this.fixCol(tsIndex);
        }
    }

    private void readBin(long localRowID, T obj, int i, ColumnMetadata m) {
        int size = ((VariableColumn)Unsafe.arrayGet(this.columns, i)).getBinLen(localRowID);
        ByteBuffer buf = (ByteBuffer)Unsafe.getUnsafe().getObject(obj, m.offset);
        if (size == -1) {
            if (buf != null) {
                buf.clear();
            }
        } else {
            if (buf == null || buf.capacity() < size) {
                buf = ByteBuffer.allocate(size);
                Unsafe.getUnsafe().putObject(obj, m.offset, buf);
            }
            if (buf.remaining() < size) {
                buf.rewind();
            }
            buf.limit(size);
            ((VariableColumn)Unsafe.arrayGet(this.columns, i)).getBin(localRowID, buf);
            buf.flip();
        }
    }

    private void rebuildIndex(int columnIndex) throws JournalException {
        JournalMetadata<T> meta = this.journal.getMetadata();
        this.rebuildIndex(columnIndex, this.columnMetadata[columnIndex].distinctCountHint, meta.getRecordHint(), meta.getTxCountHint());
    }

    private void rebuildIndex(int columnIndex, int keyCountHint, int recordCountHint, int txCountHint) throws JournalException {
        long time = System.nanoTime();
        this.getIndexForColumn(columnIndex).close();
        File base = new File(this.partitionDir, this.columnMetadata[columnIndex].name);
        KVIndex.delete(base);
        try (KVIndex index = new KVIndex(base, keyCountHint, recordCountHint, txCountHint, 2, 0L, this.sequentialAccess);){
            FixedColumn col = this.fixCol(columnIndex);
            long sz = this.size();
            for (long localRowID = 0L; localRowID < sz; ++localRowID) {
                index.add(col.getInt(localRowID), localRowID);
            }
            index.commit();
        }
        LOG.debug().$("REBUILT ").$(base).$(" in ").$(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time)).$("ms").$();
    }

    final void setPartitionDir(File partitionDir, long[] indexTxAddresses) {
        boolean create = partitionDir != null && !partitionDir.equals(this.partitionDir);
        this.partitionDir = partitionDir;
        if (create) {
            this.createSymbolIndexProxies(indexTxAddresses);
        }
    }

    void truncate(long newSize) throws JournalException {
        if (this.isOpen() && this.size() > newSize) {
            int i;
            int k = this.indexProxies.size();
            for (i = 0; i < k; ++i) {
                this.indexProxies.getQuick(i).getIndex().truncate(newSize);
            }
            for (i = 0; i < this.columns.length; ++i) {
                if (Unsafe.arrayGet(this.columns, i) == null) continue;
                Unsafe.arrayGet(this.columns, i).truncate(newSize);
            }
            this.commitColumns();
            this.clearTx();
        }
    }
}

