/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class PlainFile
implements Closeable {
    private static final Log LOGGER = LogFactory.getLog(PlainFile.class);
    private final File file;
    private final int journalMode;
    private final int bitHint;
    private FileChannel channel;
    private ObjList<MappedByteBuffer> buffers;
    private long cachedBufferLo = -1L;
    private long cachedBufferHi = -1L;
    private long cachedAddress;
    private boolean sequentialAccess = true;

    public PlainFile(File file, int bitHint, int journalMode) throws IOException {
        this.file = file;
        this.journalMode = journalMode;
        if (bitHint < 2) {
            LOGGER.info().$("BitHint is too small for ").$(file).$();
        }
        this.bitHint = bitHint;
        this.open();
        this.buffers = new ObjList((int)(this.size() >>> bitHint) + 1);
    }

    public long addressOf(long offset) {
        if (offset > this.cachedBufferLo && offset + 1L < this.cachedBufferHi) {
            return this.cachedAddress + offset - this.cachedBufferLo - 1L;
        }
        return this.allocateAddress(offset);
    }

    @Override
    public void close() {
        this.unmap();
        this.channel = Misc.free(this.channel);
    }

    public void compact(long size) throws IOException {
        this.close();
        this.openInternal("rw");
        try {
            LOGGER.debug().$("Compacting ").$(this).$(" to ").$(size).$(" bytes").$();
            this.channel.truncate(size).close();
        }
        finally {
            this.close();
        }
    }

    public void delete() {
        this.close();
        Files.delete(this.file);
    }

    public boolean isSequentialAccess() {
        return this.sequentialAccess;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.sequentialAccess = sequentialAccess;
    }

    public int pageRemaining(long offset) {
        if (offset > this.cachedBufferLo && offset < this.cachedBufferHi) {
            return (int)(this.cachedBufferHi - offset - 1L);
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "[file=" + this.file + ']';
    }

    private long allocateAddress(long offset) {
        MappedByteBuffer buf = this.getBufferInternal(offset);
        this.cachedBufferLo = offset - (long)buf.position() - 1L;
        this.cachedBufferHi = this.cachedBufferLo + (long)buf.limit() + 2L;
        this.cachedAddress = ByteBuffers.getAddress(buf);
        return this.cachedAddress + (long)buf.position();
    }

    private MappedByteBuffer getBufferInternal(long offset) {
        int bufferSize = 1 << this.bitHint;
        int index = (int)(offset >>> this.bitHint);
        long bufferOffset = (long)index << (int)((long)this.bitHint);
        int bufferPos = (int)(offset - bufferOffset);
        MappedByteBuffer buffer = this.buffers.getQuiet(index);
        if (buffer == null) {
            buffer = this.mapBufferInternal(bufferOffset, bufferSize);
            assert (bufferSize > 0);
            this.buffers.extendAndSet(index, buffer);
            if (this.sequentialAccess) {
                MappedByteBuffer mbb;
                this.cachedBufferHi = -1L;
                this.cachedBufferLo = -1L;
                for (int i = index - 1; i > -1 && (mbb = this.buffers.getQuick(i)) != null; --i) {
                    this.buffers.setQuick(i, ByteBuffers.release(mbb));
                }
            }
        }
        buffer.position(bufferPos);
        return buffer;
    }

    private MappedByteBuffer mapBufferInternal(long offset, int size) {
        try {
            MappedByteBuffer buf;
            switch (this.journalMode) {
                case 0: {
                    long sz = offset + (long)size > this.channel.size() ? this.channel.size() - offset : (long)size;
                    assert (sz > 0L);
                    buf = this.channel.map(FileChannel.MapMode.READ_ONLY, offset, sz);
                    break;
                }
                default: {
                    buf = this.channel.map(FileChannel.MapMode.READ_WRITE, offset, size);
                }
            }
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf;
        }
        catch (IOException e) {
            throw new JournalRuntimeException("Failed to memory map: %s", (Throwable)e, this.file.getAbsolutePath());
        }
    }

    private void open() throws IOException {
        this.openInternal(this.journalMode == 0 ? "r" : "rw");
    }

    private void openInternal(String mode) throws IOException {
        File pf = this.file.getParentFile();
        if (pf == null) {
            throw new IOException("Expected a file: " + this.file);
        }
        if (!pf.exists() && !pf.mkdirs()) {
            throw new IOException("Could not create directories: " + this.file.getParentFile().getAbsolutePath());
        }
        this.channel = new RandomAccessFile(this.file, mode).getChannel();
    }

    private long size() throws IOException {
        return this.channel.size();
    }

    private void unmap() {
        int k = this.buffers.size();
        for (int i = 0; i < k; ++i) {
            MappedByteBuffer b = this.buffers.getQuick(i);
            if (b == null) continue;
            ByteBuffers.release(b);
        }
        this.cachedBufferHi = -1L;
        this.cachedBufferLo = -1L;
        this.buffers.clear();
    }
}

