/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.Misc;
import com.questdb.std.ex.JournalException;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.io.Closeable;
import java.io.File;

class SymbolIndexProxy<T>
implements Closeable {
    private final Partition<T> partition;
    private final int columnIndex;
    private KVIndex index;
    private long txAddress;
    private boolean sequentialAccess = false;

    SymbolIndexProxy(Partition<T> partition, int columnIndex, long txAddress) {
        this.partition = partition;
        this.columnIndex = columnIndex;
        this.txAddress = txAddress;
    }

    @Override
    public void close() {
        this.index = Misc.free(this.index);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.sequentialAccess = sequentialAccess;
        if (this.index != null) {
            this.index.setSequentialAccess(sequentialAccess);
        }
    }

    public void setTxAddress(long txAddress) {
        this.txAddress = txAddress;
        if (this.index != null) {
            this.index.setTxAddress(txAddress);
        }
    }

    public String toString() {
        return "SymbolIndexProxy{index=" + this.index + '}';
    }

    KVIndex getIndex() throws JournalException {
        if (this.index == null) {
            this.index = this.openIndex();
            this.index.setSequentialAccess(this.sequentialAccess);
        }
        return this.index;
    }

    private KVIndex openIndex() throws JournalException {
        JournalMetadata<T> meta = this.partition.getJournal().getMetadata();
        ColumnMetadata columnMetadata = meta.getColumnQuick(this.columnIndex);
        if (!columnMetadata.indexed) {
            throw new JournalException("There is no index for column: %s", columnMetadata.name);
        }
        return new KVIndex(new File(this.partition.getPartitionDir(), columnMetadata.name), columnMetadata.distinctCountHint, meta.getRecordHint(), meta.getTxCountHint(), this.partition.getJournal().getMode(), this.txAddress, this.sequentialAccess);
    }
}

