/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ImmutableIterator;
import com.questdb.std.str.DelimitedCharSink;
import com.questdb.std.str.FlexBufferSink;
import com.questdb.store.Tx;
import com.questdb.store.TxLog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class TxIterator
implements ImmutableIterator<Tx> {
    private final TxLog txLog;
    private final Tx tx = new Tx();
    private long txAddress = -1L;

    public TxIterator(TxLog txLog) {
        this.txLog = txLog;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.txAddress == 0L) {
            return false;
        }
        this.txLog.read(this.txAddress, this.tx);
        this.txAddress = this.tx.prevTxAddress;
        return true;
    }

    @Override
    public Tx next() {
        return this.tx;
    }

    public void print() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(FileDescriptor.out);){
            this.print(fos.getChannel());
        }
    }

    public void print(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.print(fos.getChannel());
        }
    }

    public final void reset() {
        this.txAddress = this.txLog.readCurrentTxAddress();
    }

    private void print(WritableByteChannel channel) throws IOException {
        try (DelimitedCharSink sink = new DelimitedCharSink(new FlexBufferSink(channel, 1024), '\t', "\n");){
            this.print(sink);
        }
    }

    private void print(DelimitedCharSink sink) throws IOException {
        this.reset();
        sink.put("addr").put("prev").put("txn").put("txPin").put("timestamp").put("rowid").put("part timestamp").put("lag size").put("lag name");
        sink.eol();
        for (Tx tx : this) {
            sink.put(tx.address).put(tx.prevTxAddress).put(tx.txn).put(tx.txPin).putISODate(tx.timestamp).put(tx.journalMaxRowID).putISODate(tx.lastPartitionTimestamp).put(tx.lagSize).put(tx.lagName);
            sink.eol();
        }
        sink.flush();
    }
}

