/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.ByteBuffers;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Tx;
import com.questdb.store.UnstructuredFile;
import java.io.Closeable;
import java.io.File;

public class TxLog
implements Closeable {
    public static final String FILE_NAME = "_tx";
    private final UnstructuredFile hb;
    private final Rnd rnd;
    private long headAddress = 0L;
    private long currentAddress = 0L;
    private long txn;

    public TxLog(File baseLocation, int journalMode, int txCount) throws JournalException {
        this.hb = new UnstructuredFile(new File(baseLocation, FILE_NAME), ByteBuffers.getBitHint(512, txCount), journalMode);
        this.rnd = new Rnd(System.currentTimeMillis(), System.nanoTime());
        this.txn = this.getCurrentTxn() + 1L;
    }

    @Override
    public void close() {
        this.hb.close();
    }

    public long findAddress(long txn, long txPin) {
        long curr;
        long address = this.getCurrentTxAddress();
        do {
            this.hb.setPos(address);
            long prev = this.hb.getLong();
            curr = this.hb.getLong();
            if (txn == curr) {
                if (txPin == this.hb.getLong()) {
                    return address;
                }
                return -1L;
            }
            address = prev;
        } while (txn < curr && address > 0L);
        return -1L;
    }

    public void force() {
        this.hb.force();
    }

    public long getCurrentTxAddress() {
        if (this.currentAddress == 0L) {
            this.currentAddress = this.readCurrentTxAddress();
        }
        return this.currentAddress;
    }

    public final long getCurrentTxn() {
        long address = this.getCurrentTxAddress();
        if (address == 0L) {
            return 0L;
        }
        this.hb.setPos(address + 8L);
        return this.hb.getLong();
    }

    public long getCurrentTxnPin() {
        long address = this.getCurrentTxAddress();
        if (address == 0L) {
            return 0L;
        }
        this.hb.setPos(address + 16L);
        return this.hb.getLong();
    }

    public boolean hasNext() {
        return this.readCurrentTxAddress() > this.headAddress;
    }

    public boolean head(Tx tx) {
        long address = this.readCurrentTxAddress();
        boolean result = address != this.headAddress;
        this.headAddress = this.currentAddress = address;
        this.read(this.currentAddress, tx);
        return result;
    }

    public boolean isEmpty() {
        return this.hb.getAppendOffset() < 10L || this.readCurrentTxAddress() < 1L;
    }

    public void read(long address, Tx tx) {
        assert (address > 0L) : "zero headAddress: " + address;
        tx.address = address;
        this.hb.setPos(address);
        tx.prevTxAddress = this.hb.getLong();
        tx.txn = this.hb.getLong();
        tx.txPin = this.hb.getLong();
        tx.timestamp = this.hb.getLong();
        tx.command = this.hb.get();
        tx.journalMaxRowID = this.hb.getLong();
        tx.lastPartitionTimestamp = this.hb.getLong();
        tx.lagSize = this.hb.getLong();
        tx.lagName = this.hb.getStr();
        tx.symbolTableSizes = this.hb.get(tx.symbolTableSizes);
        tx.symbolTableIndexPointers = this.hb.get(tx.symbolTableIndexPointers);
        tx.indexPointers = this.hb.get(tx.indexPointers);
        tx.lagIndexPointers = this.hb.get(tx.lagIndexPointers);
    }

    public long readCurrentTxAddress() {
        byte checksum;
        byte b7;
        byte b6;
        byte b5;
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        long address;
        byte b0;
        long a = this.hb.addressOf(0L, 9);
        while (((b0 = (byte)(address = Unsafe.getUnsafe().getLong(a))) ^ (b1 = (byte)(address >> 8)) ^ (b2 = (byte)(address >> 16)) ^ (b3 = (byte)(address >> 24)) ^ (b4 = (byte)(address >> 32)) ^ (b5 = (byte)(address >> 40)) ^ (b6 = (byte)(address >> 48)) ^ (b7 = (byte)(address >> 56))) != (checksum = Unsafe.getUnsafe().getByte(a + 8L))) {
        }
        return address;
    }

    public void setSequentialAccess(boolean sequentialAccess) {
        this.hb.setSequentialAccess(sequentialAccess);
    }

    public void write(Tx tx, boolean manualTxn) {
        this.currentAddress = Math.max(9L, this.hb.getAppendOffset());
        this.hb.setPos(this.currentAddress);
        this.hb.put(tx.prevTxAddress);
        this.hb.put(manualTxn ? (this.txn = tx.txn) : this.txn);
        ++this.txn;
        this.hb.put(manualTxn ? tx.txPin : this.rnd.nextPositiveLong());
        this.hb.put(System.currentTimeMillis());
        this.hb.put(tx.command);
        this.hb.put(tx.journalMaxRowID);
        this.hb.put(tx.lastPartitionTimestamp);
        this.hb.put(tx.lagSize);
        this.hb.put(tx.lagName);
        this.hb.put(tx.symbolTableSizes);
        this.hb.put(tx.symbolTableIndexPointers);
        this.hb.put(tx.indexPointers);
        this.hb.put(tx.lagIndexPointers);
        this.headAddress = this.hb.getPos();
        this.writeTxAddress(this.currentAddress);
        this.hb.setAppendOffset(this.headAddress);
    }

    public void writeTxAddress(long address) {
        byte b0 = (byte)address;
        byte b1 = (byte)(address >> 8);
        byte b2 = (byte)(address >> 16);
        byte b3 = (byte)(address >> 24);
        byte b4 = (byte)(address >> 32);
        byte b5 = (byte)(address >> 40);
        byte b6 = (byte)(address >> 48);
        byte b7 = (byte)(address >> 56);
        this.hb.setPos(0L);
        this.hb.put(address);
        this.hb.put((byte)(b0 ^ b1 ^ b2 ^ b3 ^ b4 ^ b5 ^ b6 ^ b7));
        this.currentAddress = address;
    }
}

