/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.std.Chars;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.MemoryFile;
import java.io.File;

public class UnstructuredFile
extends MemoryFile {
    private long pos = 0L;

    public UnstructuredFile(File file, int bitHint, int journalMode) throws JournalException {
        super(file, bitHint, journalMode, false);
    }

    public int[] get(int[] container) {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        if (container == null || len != container.length) {
            container = new int[len];
        }
        long address = this.nextAddress(len * 4);
        for (int i = 0; i < len; ++i) {
            container[i] = Unsafe.getUnsafe().getInt(address);
            address += 4L;
        }
        return container;
    }

    public long[] get(long[] container) {
        int len = this.getInt();
        if (len == -1) {
            return null;
        }
        if (container == null || len != container.length) {
            container = new long[len];
        }
        long address = this.nextAddress(len * 8);
        for (int i = 0; i < len; ++i) {
            container[i] = Unsafe.getUnsafe().getLong(address);
            address += 8L;
        }
        return container;
    }

    public byte get() {
        return Unsafe.getUnsafe().getByte(this.nextAddress(1));
    }

    public boolean getBool() {
        return Unsafe.getBool(this.nextAddress(1));
    }

    public int getInt() {
        return Unsafe.getUnsafe().getInt(this.nextAddress(4));
    }

    public long getLong() {
        return Unsafe.getUnsafe().getLong(this.nextAddress(8));
    }

    public long getPos() {
        return this.pos;
    }

    public void setPos(long pos) {
        this.pos = pos;
    }

    public String getStr() {
        int len = Unsafe.getUnsafe().getInt(this.nextAddress(4));
        if (len == -1) {
            return null;
        }
        long address = this.nextAddress(len * 2);
        char[] c = new char[len];
        for (int i = 0; i < len; ++i) {
            c[i] = Unsafe.getUnsafe().getChar(address);
            address += 2L;
        }
        return new String(c);
    }

    public void put(CharSequence value) {
        if (value == null) {
            this.put(-1);
        } else {
            Chars.strcpyw(value, this.nextAddress(value.length() * 2 + 4));
        }
    }

    public void put(int[] values) {
        if (values == null) {
            this.put(-1);
        } else {
            long address = this.nextAddress(values.length * 4 + 4);
            Unsafe.getUnsafe().putInt(address, values.length);
            address += 4L;
            for (int i = 0; i < values.length; ++i) {
                Unsafe.getUnsafe().putInt(address, values[i]);
                address += 4L;
            }
        }
    }

    public void put(long[] values) {
        if (values == null) {
            this.put(-1);
        } else {
            long address = this.nextAddress(values.length * 8 + 4);
            Unsafe.getUnsafe().putInt(address, values.length);
            address += 4L;
            for (int i = 0; i < values.length; ++i) {
                Unsafe.getUnsafe().putLong(address, values[i]);
                address += 8L;
            }
        }
    }

    public void put(int value) {
        Unsafe.getUnsafe().putInt(this.nextAddress(4), value);
    }

    public void put(byte value) {
        Unsafe.getUnsafe().putByte(this.nextAddress(1), value);
    }

    public void put(long value) {
        Unsafe.getUnsafe().putLong(this.nextAddress(8), value);
    }

    public void put(boolean value) {
        Unsafe.getUnsafe().putByte(this.nextAddress(1), (byte)(value ? 1 : 0));
    }

    private long nextAddress(int len) {
        long a = this.addressOf(this.pos, len);
        this.pos += (long)len;
        return a;
    }
}

