/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.Chars;
import com.questdb.std.DirectInputStream;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectBytes;
import com.questdb.std.str.DirectCharSequence;
import com.questdb.store.AbstractColumn;
import com.questdb.store.FixedColumn;
import com.questdb.store.MemoryFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class VariableColumn
extends AbstractColumn {
    public static final int NULL_LEN = -1;
    private final FixedColumn indexColumn;
    private final BinaryOutputStream binOut = new BinaryOutputStream();
    private final BinaryInputStream binIn = new BinaryInputStream();
    private final DirectCharSequence csA = new DirectCharSequence();
    private final DirectCharSequence csB = new DirectCharSequence();
    private char[] buffer = new char[32];
    private byte[] streamBuf;

    public VariableColumn(MemoryFile dataFile, MemoryFile indexFile) {
        super(dataFile);
        this.indexColumn = new FixedColumn(indexFile, 8);
    }

    @Override
    public void close() {
        this.indexColumn.close();
        super.close();
    }

    @Override
    public void commit() {
        if (this.binOut.offset != -1L) {
            this.binOut.close();
        }
        super.commit();
        this.indexColumn.commit();
    }

    @Override
    public void compact() throws JournalException {
        super.compact();
        this.indexColumn.compact();
    }

    @Override
    public void force() {
        super.force();
        this.indexColumn.force();
    }

    @Override
    public long getOffset(long localRowID) {
        return this.indexColumn.getLong(localRowID);
    }

    @Override
    public void setSequentialAccess(boolean sequentialAccess) {
        super.setSequentialAccess(sequentialAccess);
        this.indexColumn.setSequentialAccess(sequentialAccess);
    }

    @Override
    public long size() {
        return this.indexColumn.size();
    }

    @Override
    public void truncate(long size) {
        if (size < 0L) {
            size = 0L;
        }
        if (size < this.size()) {
            this.preCommit(this.getOffset(size));
        }
        this.indexColumn.truncate(size);
    }

    public boolean cmpStr(long localRowID, CharSequence value) {
        if (value == null) {
            return this.isNull(localRowID);
        }
        long offset = this.indexColumn.getLong(localRowID);
        int len = Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(offset, 4));
        if (len != value.length()) {
            return false;
        }
        long address = this.mappedFile.addressOf(offset + 4L, len * 2);
        for (int i = 0; i < len; ++i) {
            if (Unsafe.getUnsafe().getChar(address) != value.charAt(i)) {
                return false;
            }
            address += 2L;
        }
        return true;
    }

    public void getBin(long localRowID, ByteBuffer target) {
        long offset = this.getOffset(localRowID) + 4L;
        while (target.hasRemaining()) {
            long address = this.mappedFile.addressOf(offset, 1);
            int len = this.mappedFile.pageRemaining(offset);
            int min = len < target.remaining() ? len : target.remaining();
            for (int i = 0; i < min; ++i) {
                target.put(Unsafe.getUnsafe().getByte(address++));
            }
            offset += (long)min;
        }
    }

    public void getBin(long localRowID, OutputStream s) {
        this.getBin(localRowID, s, this.getBinLen(localRowID));
    }

    public DirectInputStream getBin(long localRowID) {
        this.binIn.reset(this.getOffset(localRowID));
        return this.binIn.isNull() ? null : this.binIn;
    }

    public int getBinLen(long localRowID) {
        return Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(this.getOffset(localRowID), 4));
    }

    public CharSequence getFlyweightStr(long localRowID) {
        return this.getFlyweightStr0(localRowID, this.csA);
    }

    public CharSequence getFlyweightStrB(long localRowID) {
        return this.getFlyweightStr0(localRowID, this.csB);
    }

    public FixedColumn getIndexColumn() {
        return this.indexColumn;
    }

    public String getStr(long localRowID) {
        long offset = this.indexColumn.getLong(localRowID);
        int len = Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(offset, 4));
        if (len == -1) {
            return null;
        }
        return this.getStr0(this.mappedFile.addressOf(offset + 4L, len * 2), len);
    }

    public void getStr(long localRowID, CharSink sink) {
        long offset = this.indexColumn.getLong(localRowID);
        int len = Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(offset, 4));
        if (len == -1) {
            return;
        }
        long address = this.mappedFile.addressOf(offset + 4L, len * 2);
        for (int i = 0; i < len; ++i) {
            sink.put(Unsafe.getUnsafe().getChar(address));
            address += 2L;
        }
    }

    public int getStrLen(long localRowID) {
        return Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(this.indexColumn.getLong(localRowID), 4));
    }

    public void putBin(ByteBuffer value) {
        long rowOffset = this.getOffset();
        long targetOffset = rowOffset + (long)value.remaining() + 4L;
        long appendOffset = rowOffset;
        long address = this.mappedFile.addressOf(rowOffset, 4);
        Unsafe.getUnsafe().putInt(address, value.remaining());
        address += 4L;
        int len = this.mappedFile.pageRemaining(appendOffset += 4L);
        while (appendOffset < targetOffset) {
            if (len == 0) {
                address = this.mappedFile.addressOf(appendOffset, 1);
                len = this.mappedFile.pageRemaining(appendOffset);
            }
            int min = len < value.remaining() ? len : value.remaining();
            for (int i = 0; i < min; ++i) {
                Unsafe.getUnsafe().putByte(address++, value.get());
            }
            len -= min;
            appendOffset += (long)min;
        }
        this.commitAppend(rowOffset, (int)(targetOffset - rowOffset));
    }

    public void putBin(InputStream s) {
        if (s == null) {
            this.putNull();
            return;
        }
        this.initStreamBuf();
        long rowOffset = this.getOffset();
        long off = rowOffset + 4L;
        int blockRemaining = 0;
        long blockAddress = 0L;
        int sz = 0;
        try {
            int bufRemaining;
            while ((bufRemaining = s.read(this.streamBuf)) != -1) {
                sz += bufRemaining;
                long streamOffset = Unsafe.BYTE_OFFSET;
                while (bufRemaining > 0) {
                    if (blockRemaining == 0) {
                        blockAddress = this.mappedFile.addressOf(off, 1);
                        blockRemaining = this.mappedFile.pageRemaining(off);
                    }
                    if (blockRemaining < 1) {
                        throw new JournalRuntimeException("Internal error. Unable to allocateOffset disk block", new Object[0]);
                    }
                    int len = bufRemaining > blockRemaining ? blockRemaining : bufRemaining;
                    Unsafe.getUnsafe().copyMemory(this.streamBuf, streamOffset, null, blockAddress, len);
                    bufRemaining -= len;
                    off += (long)len;
                    blockRemaining -= len;
                    blockAddress += (long)len;
                    streamOffset += (long)len;
                }
            }
            long a = this.mappedFile.addressOf(rowOffset, 4);
            Unsafe.getUnsafe().putInt(a, sz);
            this.commitAppend(rowOffset, sz + 4);
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public OutputStream putBin() {
        this.binOut.reset(this.getOffset());
        return this.binOut;
    }

    public long putNull() {
        long offset = this.getOffset();
        Unsafe.getUnsafe().putInt(this.mappedFile.addressOf(offset, 4), -1);
        return this.commitAppend(offset, 4);
    }

    public long putStr(CharSequence value) {
        if (value == null) {
            return this.putNull();
        }
        int len = value.length() * 2 + 4;
        long offset = this.getOffset();
        Chars.strcpyw(value, this.mappedFile.addressOf(offset, len));
        return this.commitAppend(offset, len);
    }

    public long putStr(DirectBytes value) {
        if (value == null) {
            return this.putNull();
        }
        int len = value.byteLength();
        long offset = this.getOffset();
        long address = this.mappedFile.addressOf(offset, len + 4);
        Unsafe.getUnsafe().putInt(address, len / 2);
        Unsafe.getUnsafe().copyMemory(value.address(), address + 4L, len);
        return this.commitAppend(offset, len + 4);
    }

    private long commitAppend(long offset, int size) {
        this.preCommit(offset + (long)size);
        return this.indexColumn.putLong(offset);
    }

    private void getBin(long localRowID, OutputStream s, int len) {
        this.initStreamBuf();
        long offset = this.getOffset(localRowID) + 4L;
        int blockRemaining = 0;
        long blockAddress = 0L;
        try {
            while (len > 0) {
                if (blockRemaining == 0) {
                    blockAddress = this.mappedFile.addressOf(offset, 1);
                    blockRemaining = this.mappedFile.pageRemaining(offset);
                }
                int l = len > blockRemaining ? blockRemaining : len;
                Unsafe.getUnsafe().copyMemory(null, blockAddress, this.streamBuf, Unsafe.BYTE_OFFSET, l);
                offset += (long)l;
                blockRemaining -= l;
                len -= l;
                blockAddress += (long)l;
                s.write(this.streamBuf, 0, l);
            }
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }

    private CharSequence getFlyweightStr0(long localRowID, DirectCharSequence cs) {
        long offset = this.indexColumn.getLong(localRowID);
        int len = Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(offset, 4));
        if (len == -1) {
            return null;
        }
        long lo = this.mappedFile.addressOf(offset + 4L, len <<= 1);
        return cs.of(lo, lo + (long)len);
    }

    private String getStr0(long address, int len) {
        if (this.buffer.length < len) {
            this.buffer = new char[len];
        }
        Unsafe.getUnsafe().copyMemory(null, address, this.buffer, Unsafe.CHAR_OFFSET, (long)len * 2L);
        return new String(this.buffer, 0, len);
    }

    private void initStreamBuf() {
        if (this.streamBuf == null) {
            this.streamBuf = new byte[0x100000];
        }
    }

    private boolean isNull(long localRowID) {
        return Unsafe.getUnsafe().getInt(this.mappedFile.addressOf(this.indexColumn.getLong(localRowID), 4)) == -1;
    }

    private class BinaryInputStream
    extends DirectInputStream {
        private long workOffset;
        private long blockAddress;
        private int remaining;
        private int pageRemaining;

        private BinaryInputStream() {
        }

        @Override
        public long copyTo(long address, long start, long length) {
            int sz;
            long rem = (long)this.remaining - start;
            long res = length > rem ? rem : length;
            long size = res;
            long offset = this.workOffset + start;
            do {
                long from = VariableColumn.this.mappedFile.addressOf(offset, 1);
                int remaining = VariableColumn.this.mappedFile.pageRemaining(offset);
                sz = size > (long)remaining ? remaining : (int)size;
                Unsafe.getUnsafe().copyMemory(from, address, sz);
                address += (long)sz;
                offset += (long)sz;
            } while ((size -= (long)sz) > 0L);
            return res;
        }

        @Override
        public long size() {
            return this.remaining;
        }

        public boolean isNull() {
            return this.remaining == -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            if (this.pageRemaining == 0) {
                this.renew();
            }
            --this.pageRemaining;
            ++this.workOffset;
            --this.remaining;
            return Unsafe.getUnsafe().getByte(this.blockAddress++) & 0xFF;
        }

        private void renew() {
            this.blockAddress = VariableColumn.this.mappedFile.addressOf(this.workOffset, 1);
            this.pageRemaining = VariableColumn.this.mappedFile.pageRemaining(this.workOffset);
        }

        private void reset(long offset) {
            this.workOffset = offset + 4L;
            this.pageRemaining = 0;
            this.remaining = Unsafe.getUnsafe().getInt(VariableColumn.this.mappedFile.addressOf(offset, 4));
        }
    }

    private class BinaryOutputStream
    extends OutputStream {
        private long offset = -1L;
        private long workOffset;
        private long blockAddress;
        private int blockRemaining;

        private BinaryOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.blockRemaining == 0) {
                this.renew();
            }
            Unsafe.getUnsafe().putByte(this.blockAddress++, (byte)b);
            ++this.workOffset;
            --this.blockRemaining;
        }

        @Override
        public void close() {
            long a = VariableColumn.this.mappedFile.addressOf(this.offset, 4);
            Unsafe.getUnsafe().putInt(a, (int)(this.workOffset - this.offset - 4L));
            VariableColumn.this.commitAppend(this.offset, (int)(this.workOffset - this.offset));
            this.offset = -1L;
        }

        private void renew() {
            this.blockAddress = VariableColumn.this.mappedFile.addressOf(this.workOffset, 1);
            this.blockRemaining = VariableColumn.this.mappedFile.pageRemaining(this.workOffset);
        }

        private void reset(long offset) {
            if (this.offset != -1L) {
                this.close();
            }
            this.offset = offset;
            this.workOffset = offset + 4L;
            this.blockRemaining = 0;
        }
    }
}

