/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.store.factory.FactoryEventListener;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import java.io.Closeable;

abstract class AbstractFactory
implements Closeable {
    private final JournalConfiguration configuration;
    private final long inactiveTtlMs;
    protected FactoryEventListener eventListener;

    public AbstractFactory(JournalConfiguration configuration, long inactiveTtlMs) {
        this.configuration = configuration;
        this.inactiveTtlMs = inactiveTtlMs;
    }

    public AbstractFactory(String databaseHome, long inactiveTtlMs) {
        this(new JournalConfigurationBuilder().build(databaseHome), inactiveTtlMs);
    }

    @Override
    public void close() {
    }

    public JournalConfiguration getConfiguration() {
        return this.configuration;
    }

    public FactoryEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(FactoryEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public boolean releaseInactive() {
        return this.releaseAll(System.currentTimeMillis() - this.inactiveTtlMs);
    }

    protected abstract boolean releaseAll(long var1);
}

