/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.common.PoolConstants;
import com.questdb.ex.FactoryClosedException;
import com.questdb.ex.FactoryFullException;
import com.questdb.ex.JournalDoesNotExistException;
import com.questdb.ex.JournalLockedException;
import com.questdb.ex.RetryLockException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.factory.AbstractFactory;
import com.questdb.store.factory.FactoryEventListener;
import com.questdb.store.factory.JournalCloseInterceptor;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingReaderFactory
extends AbstractFactory
implements JournalCloseInterceptor {
    private static final long CLOSED = Unsafe.getFieldOffset(CachingReaderFactory.class, "closed");
    private static final Log LOG = LogFactory.getLog(CachingReaderFactory.class);
    private static final long UNLOCKED = -1L;
    private static final long NEXT_STATUS = Unsafe.getFieldOffset(Entry.class, "nextStatus");
    private static final int ENTRY_SIZE = 32;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final long LOCK_OWNER = Unsafe.getFieldOffset(Entry.class, "lockOwner");
    private final ConcurrentHashMap<String, Entry> entries = new ConcurrentHashMap();
    private final int maxSegments;
    private final int maxEntries;
    private volatile int closed = 0;

    public CachingReaderFactory(String databaseHome, long inactiveTtl, int maxSegments) {
        super(databaseHome, inactiveTtl);
        this.maxSegments = maxSegments;
        this.maxEntries = maxSegments * 32;
    }

    public CachingReaderFactory(JournalConfiguration configuration, long inactiveTtl, int maxSegments) {
        super(configuration, inactiveTtl);
        this.maxSegments = maxSegments;
        this.maxEntries = maxSegments * 32;
    }

    @Override
    public boolean canClose(Journal journal) {
        String name = journal.getName();
        if (journal instanceof R) {
            long thread = Thread.currentThread().getId();
            Entry e = this.entries.get(name);
            if (e == null) {
                LOG.error().$("Reader '").$(name).$("' is not managed by this pool").$();
                this.notifyListener(thread, name, (short)5, -1, -1);
                return true;
            }
            R r = (R)journal;
            if (Unsafe.arrayGetVolatile(((R)r).entry.allocations, r.index) != -1L) {
                if (this.closed == 1) {
                    Unsafe.arrayPut(((R)r).entry.readers, r.index, null);
                    this.notifyListener(thread, name, (short)2, ((R)r).entry.index, r.index);
                    return true;
                }
                Unsafe.arrayPut(((R)r).entry.releaseTimes, r.index, System.currentTimeMillis());
                Unsafe.arrayPutOrdered(((R)r).entry.allocations, r.index, -1L);
                LOG.info().$("Thread ").$(thread).$(" released reader '").$(name).$("' (").$(((R)r).entry.index).$(',').$(r.index).$(')').$();
                this.notifyListener(thread, name, (short)1, ((R)r).entry.index, r.index);
                return false;
            }
            LOG.error().$("Thread ").$(thread).$(" attempts to release unallocated reader '").$(name).$("' ").$(((R)r).entry.index).$(',').$(r.index).$();
        } else {
            LOG.error().$("Internal error. Closing foreign reader: ").$(name).$();
        }
        return true;
    }

    @Override
    public void close() {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, CLOSED, 0, 1)) {
            this.releaseAll(Long.MAX_VALUE);
        }
    }

    public int getBusyCount() {
        int count = 0;
        for (Map.Entry<String, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.arrayGetVolatile(e.allocations, i) == -1L || Unsafe.arrayGet(e.readers, i) == null) continue;
                    ++count;
                }
            } while ((e = e.next) != null);
        }
        return count;
    }

    public void lock(String name) throws JournalException {
        Entry e = this.entries.get(name);
        if (e == null) {
            LOG.info().$("Reader '").$(name).$("' doesn't exist. Nothing to lock.").$();
            return;
        }
        long thread = Thread.currentThread().getId();
        if (Unsafe.cas(e, LOCK_OWNER, -1L, thread) || Unsafe.cas(e, LOCK_OWNER, thread, thread)) {
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        this.closeReader(thread, e, i, (short)19, (short)20, 2);
                        continue;
                    }
                    if (Unsafe.arrayGet(e.allocations, i) == thread && Unsafe.arrayGet(e.readers, i) == null) continue;
                    LOG.info().$("Reader '").$(name).$("' is partially locked by ").$(e.lockOwner).$();
                    throw RetryLockException.INSTANCE;
                }
            } while ((e = e.next) != null);
        } else {
            LOG.error().$("Reader '").$(name).$("' is already locked by ").$(e.lockOwner).$();
            this.notifyListener(thread, name, (short)7, -1, -1);
            throw JournalLockedException.INSTANCE;
        }
        this.notifyListener(thread, name, (short)6, -1, -1);
        LOG.info().$("Reader '").$(name).$("' is locked").$();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    private void closeReader(long thread, Entry e, int index, short ev, short evex, int reason) {
        R r = Unsafe.arrayGet(e.readers, index);
        if (r != null) {
            try {
                r.setCloseInterceptor(null);
                r.close();
                LOG.info().$("Closed reader '").$(r.getName()).$("' (").$(e.index).$(',').$(index).$(") ").$(PoolConstants.closeReasonText(reason)).$();
                this.notifyListener(thread, r.getName(), ev, e.index, index);
            }
            catch (Throwable e1) {
                LOG.error().$("Cannot close reader '").$(r.getName()).$("' (").$(e.index).$(',').$(index).$(") ").$(PoolConstants.closeReasonText(reason)).$(e1.getMessage()).$();
                this.notifyListener(thread, r.getName(), evex, e.index, index);
            }
            Unsafe.arrayPut(e.readers, index, null);
        }
    }

    public void unlock(String name) {
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e == null) {
            LOG.info().$("Reader '").$(name).$("' does not exist. Nothing to unlock.").$();
            this.notifyListener(thread, name, (short)9, -1, -1);
            return;
        }
        if (e.lockOwner == thread) {
            this.entries.remove(name);
        }
        this.notifyListener(thread, name, (short)8, -1, -1);
        LOG.info().$("Reader '").$(name).$("' is unlocked").$();
    }

    <T> Journal<T> reader(JournalMetadata<T> metadata) throws JournalException {
        long lockOwner;
        if (this.closed == 1) {
            LOG.info().$("Pool is closed");
            throw FactoryClosedException.INSTANCE;
        }
        String name = metadata.getName();
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e == null) {
            LOG.info().$("Thread ").$(thread).$(" is racing to create first entry for '").$(name).$('\'').$();
            e = new Entry(0);
            Entry other = this.entries.putIfAbsent(name, e);
            if (other != null) {
                e = other;
                LOG.info().$("Thread ").$(thread).$(" LOST the race to create first entry for '").$(name).$('\'').$();
            } else {
                if (this.getConfiguration().exists(name) != 1) {
                    LOG.info().$("Reader '").$(name).$("' does not exist").$();
                    throw JournalDoesNotExistException.INSTANCE;
                }
                LOG.info().$("Thread ").$(thread).$(" WON the race to create first entry for '").$(name).$('\'').$();
            }
        }
        if ((lockOwner = e.lockOwner) != -1L) {
            LOG.info().$("Reader '").$(name).$("' is locked by ").$(lockOwner).$();
            throw JournalLockedException.INSTANCE;
        }
        do {
            for (int i = 0; i < 32; ++i) {
                if (!Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                R<T> r = Unsafe.arrayGet(e.readers, i);
                if (r == null) {
                    LOG.info().$("Thread ").$(thread).$(" created new reader '").$(name).$("' (").$(e.index).$(',').$(i).$(')').$();
                    r = new R<T>(e, i, metadata, new File(this.getConfiguration().getJournalBase(), metadata.getName()));
                    this.notifyListener(thread, name, (short)10, e.index, i);
                    if (this.closed == 1) {
                        return r;
                    }
                    Unsafe.arrayPut(e.readers, i, r);
                    r.setCloseInterceptor(this);
                } else {
                    LOG.info().$("Thread ").$(thread).$(" allocated reader '").$(name).$("' (").$(e.index).$(',').$(i).$(')').$();
                    r.refresh();
                    this.notifyListener(thread, name, (short)11, e.index, i);
                }
                if (this.closed == 1) {
                    Unsafe.arrayPut(e.readers, i, null);
                    r.setCloseInterceptor(null);
                }
                return r;
            }
            LOG.info().$("Thread ").$(thread).$(" is moving to entry ").$(e.index + 1).$();
            if (!Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 1)) continue;
            LOG.info().$("Thread ").$(thread).$(" allocated entry ").$(e.index + 1).$();
            e.next = new Entry(e.index + 1);
        } while ((e = e.next) != null && e.index < this.maxSegments);
        this.notifyListener(thread, name, (short)25, -1, -1);
        LOG.info().$("Thread ").$(thread).$(" cannot allocate reader. Max entries exceeded (").$(this.maxSegments).$(')').$();
        throw FactoryFullException.INSTANCE;
    }

    private void notifyListener(long thread, String name, short event, int segment, int position) {
        FactoryEventListener listener = this.getEventListener();
        if (listener != null) {
            listener.onEvent((byte)2, thread, name, event, (short)segment, (short)position);
        }
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int closeReason = deadline < Long.MAX_VALUE ? 3 : 1;
        for (Map.Entry<String, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    if (deadline <= Unsafe.arrayGetVolatile(e.releaseTimes, i) || Unsafe.arrayGet(e.readers, i) == null || !Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                    if (deadline > Unsafe.arrayGet(e.releaseTimes, i)) {
                        removed = true;
                        this.closeReader(thread, e, i, (short)17, (short)18, closeReason);
                    }
                    Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                }
            } while ((e = e.next) != null);
        }
        return removed;
    }

    public static class R<T>
    extends Journal<T> {
        private Entry entry;
        private int index;

        public R(Entry entry, int index, JournalMetadata<T> metadata, File location) throws JournalException {
            super(metadata, location);
            this.entry = entry;
            this.index = index;
        }
    }

    private static class Entry {
        final long[] allocations = new long[32];
        final long[] releaseTimes = new long[32];
        final R[] readers = new R[32];
        volatile long lockOwner = -1L;
        long nextStatus = 0L;
        volatile Entry next;
        int index = 0;

        public Entry(int index) {
            this.index = index;
            Arrays.fill(this.allocations, -1L);
            Arrays.fill(this.releaseTimes, System.currentTimeMillis());
        }
    }
}

