/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.PoolConstants;
import com.questdb.ex.FactoryClosedException;
import com.questdb.ex.FactoryInternalException;
import com.questdb.ex.JournalLockedException;
import com.questdb.ex.JournalMetadataException;
import com.questdb.ex.JournalPartiallyMappedException;
import com.questdb.ex.WriterBusyException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.AbstractFactory;
import com.questdb.store.factory.FactoryEventListener;
import com.questdb.store.factory.JournalCloseInterceptor;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class CachingWriterFactory
extends AbstractFactory
implements JournalCloseInterceptor {
    private static final Log LOG = LogFactory.getLog(CachingWriterFactory.class);
    private static final long ENTRY_OWNER = Unsafe.getFieldOffset(Entry.class, "owner");
    private final ConcurrentHashMap<String, Entry> entries = new ConcurrentHashMap();
    private volatile boolean closed = false;

    public CachingWriterFactory(String databaseHome, long inactiveTtl) {
        super(databaseHome, inactiveTtl);
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    public CachingWriterFactory(JournalConfiguration configuration, long inactiveTtl) {
        super(configuration, inactiveTtl);
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    @Override
    public boolean canClose(Journal journal) {
        String name = journal.getName();
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e != null) {
            if (e.owner != -1L) {
                if (e.writer.isCommitOnClose()) {
                    try {
                        e.writer.commit();
                    }
                    catch (JournalException ex) {
                        this.notifyListener(thread, name, (short)4);
                        throw new JournalRuntimeException(ex);
                    }
                }
                LOG.info().$("Writer '").$(name).$(" is back in pool").$();
                e.lastReleaseTime = System.currentTimeMillis();
                if (this.closed || e.writer.isInError()) {
                    LOG.info().$("Closing writer '").$(name).$('\'').$();
                    e.writer.setCloseInterceptor(null);
                    e.writer = null;
                    this.entries.remove(name);
                    this.notifyListener(thread, name, (short)2);
                    return true;
                }
                e.owner = -1L;
                this.notifyListener(thread, name, (short)1);
            } else {
                LOG.error().$("Writer '").$(name).$("' is not allocated ").$(e.owner).$();
                this.notifyListener(thread, name, (short)3);
            }
        } else {
            LOG.error().$("Writer '").$(name).$("' is not managed by this pool").$();
            journal.setCloseInterceptor(null);
            this.notifyListener(thread, name, (short)5);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        this.releaseAll(Long.MAX_VALUE);
        this.notifyListener(Thread.currentThread().getId(), null, (short)24);
    }

    public void lock(String name) throws JournalException {
        if (this.closed) {
            LOG.info().$("Pool is closed").$();
            throw FactoryClosedException.INSTANCE;
        }
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(name);
        if (e == null) {
            e = new Entry();
            if (this.entries.putIfAbsent(name, e) == null) {
                this.notifyListener(thread, name, (short)6);
                e.locked = true;
                return;
            }
            e = this.entries.get(name);
        }
        if (e != null) {
            if (Unsafe.cas(e, ENTRY_OWNER, -1L, thread) || Unsafe.cas(e, ENTRY_OWNER, thread, thread)) {
                LOG.info().$("Thread ").$(e.owner).$(" locked writer ").$(name).$();
                this.closeWriter(thread, e, (short)19, (short)20, 2);
                e.locked = true;
                this.notifyListener(thread, name, (short)6);
                return;
            }
            LOG.error().$("Writer '").$(name).$("' is owned by thread ").$(e.owner).$();
        }
        this.notifyListener(thread, name, (short)7);
        throw WriterBusyException.INSTANCE;
    }

    public int getBusyCount() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) continue;
            ++count;
        }
        return count;
    }

    private JournalWriter checkAndReturn(long thread, Entry e, String name, JournalMetadata<?> metadata) throws JournalException {
        JournalMetadata wm = e.writer.getMetadata();
        if (metadata.isCompatible(wm, false)) {
            if (metadata.getModelClass() != null && wm.getModelClass() == null) {
                this.closeWriter(thread, e, (short)12, (short)15, 4);
                return this.createWriter(thread, name, e, metadata);
            }
            LOG.info().$("Writer '").$(name).$("' is assigned to thread ").$(thread).$();
            this.notifyListener(thread, name, (short)11);
            return e.writer;
        }
        JournalMetadataException ex = new JournalMetadataException(wm, metadata);
        this.notifyListener(thread, name, (short)13);
        if (this.closed) {
            this.closeWriter(thread, e, (short)12, (short)15, 1);
        }
        e.owner = -1L;
        throw ex;
    }

    public int size() {
        return this.entries.size();
    }

    public void unlock(String name) {
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(name);
        if (e == null) {
            this.notifyListener(thread, name, (short)9);
            return;
        }
        if (e.owner == thread) {
            if (e.writer != null) {
                this.notifyListener(thread, name, (short)9);
                throw new IllegalStateException("Writer " + name + " is not locked");
            }
            this.entries.remove(name);
        }
        this.notifyListener(thread, name, (short)8);
    }

    private void closeWriter(long thread, Entry e, short ev, short evex, int reason) {
        JournalWriter w = e.writer;
        if (w != null) {
            String name = e.writer.getName();
            w.setCloseInterceptor(null);
            try {
                w.close();
                e.writer = null;
                LOG.info().$("Closed writer '").$(name).$('\'').$(PoolConstants.closeReasonText(reason)).$();
                this.notifyListener(thread, name, ev);
            }
            catch (Throwable e1) {
                this.notifyListener(thread, name, evex);
                LOG.error().$("Cannot close writer '").$(w.getName()).$("': ").$(e1.getMessage()).$();
            }
        }
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int reason = deadline == Long.MAX_VALUE ? 1 : 3;
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (deadline > e.lastReleaseTime && e.owner == -1L) {
                if (!Unsafe.cas(e, ENTRY_OWNER, -1L, thread)) continue;
                this.closeWriter(thread, e, (short)17, (short)18, reason);
                iterator.remove();
                removed = true;
                Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
                continue;
            }
            if (e.ex == null) continue;
            LOG.info().$("Removing entry for failed to allocate writer").$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    int countFreeWriters() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) {
                ++count;
                continue;
            }
            LOG.info().$("Writer '").$(e.writer.getName()).$("' is still owned by ").$(e.owner).$();
        }
        return count;
    }

    private <T> JournalWriter<T> createWriter(long thread, String name, Entry e, JournalMetadata<T> metadata) throws JournalException {
        try {
            JournalMetadata mo = this.getConfiguration().readMetadata(metadata.getName());
            if (mo != null && !mo.isCompatible(metadata, false)) {
                throw new JournalMetadataException(mo, metadata);
            }
            if (this.closed) {
                throw FactoryClosedException.INSTANCE;
            }
            JournalWriter<T> w = new JournalWriter<T>(metadata, new File(this.getConfiguration().getJournalBase(), name));
            w.setCloseInterceptor(this);
            LOG.info().$("Writer '").$(name).$("' is allocated by thread ").$(e.owner).$();
            e.writer = w;
            this.notifyListener(thread, name, (short)10);
            return w;
        }
        catch (JournalException ex) {
            LOG.error().$("Failed to allocate writer '").$(name).$("' in thread ").$(e.owner).$(": ").$(ex).$();
            e.ex = ex;
            this.notifyListener(thread, name, (short)14);
            throw ex;
        }
    }

    private void notifyListener(long thread, String name, short event) {
        FactoryEventListener listener = this.getEventListener();
        if (listener != null) {
            listener.onEvent((byte)1, thread, name, event, (short)0, (short)0);
        }
    }

    <T> JournalWriter<T> writer(JournalMetadata<T> metadata) throws JournalException {
        if (metadata.isPartialMapped()) {
            throw JournalPartiallyMappedException.INSTANCE;
        }
        if (this.closed) {
            LOG.info().$("Pool is closed").$();
            throw FactoryClosedException.INSTANCE;
        }
        String name = metadata.getKey().getName();
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(name);
        if (e == null) {
            e = new Entry();
            if (this.entries.putIfAbsent(name, e) == null) {
                return this.createWriter(thread, name, e, metadata);
            }
            LOG.info().$("Thread ").$(e.owner).$(" lost race to allocate writer '").$(name).$('\'').$();
            e = this.entries.get(name);
        }
        if (e != null && Unsafe.cas(e, ENTRY_OWNER, -1L, thread)) {
            if (e.writer == null) {
                return this.createWriter(thread, name, e, metadata);
            }
            if (this.closed) {
                e.writer.setCloseInterceptor(null);
            }
            return this.checkAndReturn(thread, e, name, metadata);
        }
        if (e == null) {
            LOG.error().$("Writer '").$(name).$("' is not managed by this pool. Internal error?").$();
            throw FactoryInternalException.INSTANCE;
        }
        long owner = e.owner;
        if (owner == thread) {
            if (e.locked) {
                throw JournalLockedException.INSTANCE;
            }
            if (e.ex != null) {
                this.notifyListener(thread, name, (short)21);
                throw e.ex;
            }
            if (this.closed) {
                LOG.info().$("Writer '").$(name).$("' is detached").$();
                e.writer.setCloseInterceptor(null);
            }
            return this.checkAndReturn(thread, e, name, metadata);
        }
        LOG.error().$("Writer '").$(name).$("' is already owned by thread ").$(owner).$();
        throw WriterBusyException.INSTANCE;
    }

    private static class Entry {
        private long owner = Thread.currentThread().getId();
        private JournalWriter writer;
        private volatile long lastReleaseTime = System.currentTimeMillis();
        private JournalException ex = null;
        private volatile boolean locked = false;

        private Entry() {
        }
    }
}

