/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory;

import com.questdb.ex.FactoryInternalException;
import com.questdb.ex.JournalDoesNotExistException;
import com.questdb.ex.JournalExistsException;
import com.questdb.ex.JournalWriterAlreadyOpenException;
import com.questdb.ex.SystemException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.Job;
import com.questdb.mp.SynchronizedJob;
import com.questdb.std.Files;
import com.questdb.std.ObjHashSet;
import com.questdb.std.Os;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.Path;
import com.questdb.store.Journal;
import com.questdb.store.JournalKey;
import com.questdb.store.JournalWriter;
import com.questdb.store.Lock;
import com.questdb.store.LockManager;
import com.questdb.store.factory.CachingReaderFactory;
import com.questdb.store.factory.CachingWriterFactory;
import com.questdb.store.factory.FactoryEventListener;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.MetadataBuilder;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class Factory
implements ReaderFactory,
WriterFactory {
    private static final Log LOG = LogFactory.getLog(Factory.class);
    private final CachingWriterFactory writerFactory;
    private final CachingReaderFactory readerFactory;
    private final JournalConfiguration configuration;
    private final ConcurrentHashMap<String, JournalMetadata> metadataCache = new ConcurrentHashMap();
    private final WriterMaintenanceJob writerMaintenanceJob;
    private final ReaderMaintenanceJob readerMaintenanceJob;

    public Factory(JournalConfiguration configuration) {
        this(configuration, 0L, 2, 0L);
    }

    public Factory(JournalConfiguration configuration, long idleTimeoutMs, int maxSegments, long idleCheckIntervalMs) {
        this.writerFactory = new CachingWriterFactory(configuration, idleTimeoutMs);
        this.readerFactory = new CachingReaderFactory(configuration, idleTimeoutMs, maxSegments);
        this.configuration = configuration;
        this.writerMaintenanceJob = new WriterMaintenanceJob(idleCheckIntervalMs);
        this.readerMaintenanceJob = new ReaderMaintenanceJob(idleCheckIntervalMs);
    }

    public Factory(String databaseHome, long inactiveTtlMs, int readerCacheSegments, long idleCheckIntervalMs) {
        this.writerFactory = new CachingWriterFactory(databaseHome, inactiveTtlMs);
        this.readerFactory = new CachingReaderFactory(databaseHome, inactiveTtlMs, readerCacheSegments);
        this.configuration = this.readerFactory.getConfiguration();
        this.writerMaintenanceJob = new WriterMaintenanceJob(idleCheckIntervalMs);
        this.readerMaintenanceJob = new ReaderMaintenanceJob(idleCheckIntervalMs);
    }

    @Override
    public void close() {
        this.writerFactory.close();
        this.readerFactory.close();
    }

    @Override
    public JournalConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final <T> Journal<T> reader(JournalKey<T> key) throws JournalException {
        return this.reader(this.getConfiguration().createMetadata(key));
    }

    @Override
    public final <T> Journal<T> reader(Class<T> clazz) throws JournalException {
        return this.reader(new JournalKey<T>(clazz));
    }

    @Override
    public final <T> Journal<T> reader(Class<T> clazz, String name) throws JournalException {
        return this.reader(new JournalKey<T>(clazz, name));
    }

    @Override
    public final Journal reader(String name) throws JournalException {
        return this.reader(this.getMetadata(name));
    }

    @Override
    public final <T> Journal<T> reader(Class<T> clazz, String name, int recordHint) throws JournalException {
        return this.reader(new JournalKey<T>(clazz, name, 4, recordHint));
    }

    @Override
    public <T> Journal<T> reader(JournalMetadata<T> metadata) throws JournalException {
        return this.readerFactory.reader(metadata);
    }

    public void delete(String name) throws JournalException {
        this.lock(name);
        try {
            this.delete0(name);
        }
        finally {
            this.unlock(name);
        }
    }

    public void expire() {
        this.writerFactory.releaseInactive();
        this.readerFactory.releaseInactive();
    }

    public void exportJobs(ObjHashSet<Job> jobs) {
        jobs.add(this.writerMaintenanceJob);
        jobs.add(this.readerMaintenanceJob);
    }

    public int getBusyReaderCount() {
        return this.readerFactory.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerFactory.getBusyCount();
    }

    public FactoryEventListener getEventListener() {
        return this.writerFactory.getEventListener();
    }

    public void setEventListener(FactoryEventListener eventListener) {
        this.writerFactory.setEventListener(eventListener);
        this.readerFactory.setEventListener(eventListener);
    }

    public JournalMetadata getMetadata(String name) throws JournalException {
        JournalMetadata metadata = this.metadataCache.get(name);
        if (metadata != null) {
            return metadata;
        }
        metadata = this.configuration.readMetadata(name);
        JournalMetadata other = this.metadataCache.putIfAbsent(name, metadata);
        if (other != null) {
            return other;
        }
        return metadata;
    }

    public void lock(String name) throws JournalException {
        this.writerFactory.lock(name);
        try {
            this.readerFactory.lock(name);
        }
        catch (JournalException e) {
            this.writerFactory.unlock(name);
            throw e;
        }
    }

    public void rename(String from, String to) throws JournalException {
        this.lock(from);
        try {
            this.rename0(from, to);
        }
        finally {
            this.unlock(from);
        }
    }

    public void unlock(String name) {
        this.readerFactory.unlock(name);
        this.writerFactory.unlock(name);
    }

    @Override
    public <T> JournalWriter<T> writer(Class<T> clazz) throws JournalException {
        return this.writer(new JournalKey<T>(clazz));
    }

    @Override
    public <T> JournalWriter<T> writer(Class<T> clazz, String name) throws JournalException {
        return this.writer(new JournalKey<T>(clazz, name));
    }

    @Override
    public <T> JournalWriter<T> writer(Class<T> clazz, String name, int recordHint) throws JournalException {
        return this.writer(new JournalKey<T>(clazz, name, 4, recordHint));
    }

    @Override
    public JournalWriter writer(String name) throws JournalException {
        return this.writer(this.getMetadata(name));
    }

    @Override
    public <T> JournalWriter<T> writer(JournalKey<T> key) throws JournalException {
        return this.writer(this.getConfiguration().createMetadata(key));
    }

    @Override
    public <T> JournalWriter<T> writer(MetadataBuilder<T> metadataBuilder) throws JournalException {
        return this.writer(metadataBuilder.build());
    }

    @Override
    public <T> JournalWriter<T> writer(JournalMetadata<T> metadata) throws JournalException {
        return this.writerFactory.writer(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete0(String name) throws JournalException {
        File l = new File(this.getConfiguration().getJournalBase(), name);
        Lock lock = LockManager.lockExclusive(l.getAbsolutePath());
        try {
            if (lock == null || !lock.isValid()) {
                LOG.error().$("Cannot obtain lock on ").$(l).$();
                throw JournalWriterAlreadyOpenException.INSTANCE;
            }
            this.metadataCache.remove(name);
            Files.deleteOrException(l);
        }
        finally {
            LockManager.release(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename0(CharSequence from, CharSequence to) throws JournalException {
        try (Path oldName = new Path();
             Path newName = new Path();){
            String path = this.getConfiguration().getJournalBase().getAbsolutePath();
            oldName.of(path).concat(from).$();
            newName.of(path).concat(to).$();
            if (!Files.exists(oldName)) {
                LOG.error().$("Journal does not exist: ").$(oldName).$();
                throw JournalDoesNotExistException.INSTANCE;
            }
            if (Os.type == 3) {
                oldName.of("\\\\?\\").concat(path).concat(from).$();
                newName.of("\\\\?\\").concat(path).concat(to).$();
            }
            String oname = oldName.toString();
            Lock lock = LockManager.lockExclusive(oname);
            try {
                if (lock == null || !lock.isValid()) {
                    LOG.error().$("Cannot obtain lock on ").$(oldName).$();
                    throw JournalWriterAlreadyOpenException.INSTANCE;
                }
                if (Files.exists(newName)) {
                    throw JournalExistsException.INSTANCE;
                }
                Lock writeLock = LockManager.lockExclusive(newName.toString());
                try {
                    if (writeLock == null || !writeLock.isValid()) {
                        LOG.error().$("Cannot obtain lock on ").$(newName).$();
                        throw FactoryInternalException.INSTANCE;
                    }
                    this.metadataCache.remove(oname);
                    if (!Files.rename(oldName, newName)) {
                        LOG.error().$("Cannot rename ").$(oldName).$(" to ").$(newName).$(": ").$(Os.errno()).$();
                        throw SystemException.INSTANCE;
                    }
                }
                finally {
                    LockManager.release(writeLock);
                }
            }
            finally {
                LockManager.release(lock);
            }
        }
    }

    private class ReaderMaintenanceJob
    extends PeriodicSynchronizedJob {
        public ReaderMaintenanceJob(long checkInterval) {
            super(checkInterval);
        }

        @Override
        protected boolean doRun() {
            return Factory.this.readerFactory.releaseInactive();
        }
    }

    private class WriterMaintenanceJob
    extends PeriodicSynchronizedJob {
        public WriterMaintenanceJob(long checkInterval) {
            super(checkInterval);
        }

        @Override
        protected boolean doRun() {
            return Factory.this.writerFactory.releaseInactive();
        }
    }

    private static abstract class PeriodicSynchronizedJob
    extends SynchronizedJob {
        private final long checkInterval;
        private long last = 0L;

        public PeriodicSynchronizedJob(long checkInterval) {
            this.checkInterval = checkInterval;
        }

        abstract boolean doRun();

        @Override
        protected boolean runSerially() {
            long t = System.currentTimeMillis();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return this.doRun();
            }
            return false;
        }
    }
}

