/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.SymbolTable;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.UnstructuredFile;

public class ColumnMetadata
implements RecordColumnMetadata {
    public String name;
    public int type;
    public long offset;
    public int size;
    public int avgSize = 12;
    public boolean indexed;
    public int bitHint;
    public int indexBitHint;
    public int distinctCountHint;
    public String sameAs;
    public boolean noCache = false;
    public MMappedSymbolTable symbolTable;

    public ColumnMetadata copy(ColumnMetadata from) {
        this.name = from.name;
        this.type = from.type;
        this.offset = from.offset;
        this.size = from.size;
        this.avgSize = from.avgSize;
        this.indexed = from.indexed;
        this.bitHint = from.bitHint;
        this.indexBitHint = from.indexBitHint;
        this.distinctCountHint = from.distinctCountHint;
        this.sameAs = from.sameAs;
        this.noCache = from.noCache;
        return this;
    }

    @Override
    public int getBucketCount() {
        return this.distinctCountHint;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ColumnMetadata setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public ColumnMetadata setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type;
        result = 31 * result + this.size;
        result = 31 * result + this.avgSize;
        result = 31 * result + (this.indexed ? 1 : 0);
        result = 31 * result + this.bitHint;
        result = 31 * result + this.indexBitHint;
        result = 31 * result + this.distinctCountHint;
        result = 31 * result + (this.sameAs != null ? this.sameAs.hashCode() : 0);
        return 31 * result + (this.noCache ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)o;
        return this.avgSize == that.avgSize && this.bitHint == that.bitHint && this.distinctCountHint == that.distinctCountHint && this.indexBitHint == that.indexBitHint && this.indexed == that.indexed && this.noCache == that.noCache && this.size == that.size && this.name.equals(that.name) && !(this.sameAs == null ? that.sameAs != null : !this.sameAs.equals(that.sameAs)) && this.type == that.type;
    }

    public String toString() {
        return "ColumnMetadata{name*='" + this.name + '\'' + ", type*=" + this.type + ", offset=" + this.offset + ", size*=" + this.size + ", avgSize=" + this.avgSize + ", indexed=" + this.indexed + ", bitHint=" + this.bitHint + ", indexBitHint=" + this.indexBitHint + ", distinctCountHint=" + this.distinctCountHint + ", sameAs='" + this.sameAs + '\'' + ", noCache=" + this.noCache + '}';
    }

    public void read(UnstructuredFile buf) {
        this.name = buf.getStr();
        this.type = buf.getInt();
        this.size = buf.getInt();
        this.avgSize = buf.getInt();
        this.indexed = buf.getBool();
        this.bitHint = buf.getInt();
        this.indexBitHint = buf.getInt();
        this.distinctCountHint = buf.getInt();
        this.sameAs = buf.getStr();
        this.noCache = buf.getBool();
    }

    public void write(UnstructuredFile buf) {
        buf.put(this.name);
        buf.put(this.type);
        buf.put(this.size);
        buf.put(this.avgSize);
        buf.put(this.indexed);
        buf.put(this.bitHint);
        buf.put(this.indexBitHint);
        buf.put(this.distinctCountHint);
        buf.put(this.sameAs);
        buf.put(this.noCache);
    }
}

