/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.std.Chars;
import com.questdb.std.ThreadLocal;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.FlyweightCharSequence;
import org.jetbrains.annotations.NotNull;

public class ColumnName
extends AbstractCharSequence {
    private static final ThreadLocal<ColumnName> SINGLETON = new ThreadLocal<ColumnName>(ColumnName::new);
    private final FlyweightCharSequence alias = new FlyweightCharSequence();
    private final FlyweightCharSequence name = new FlyweightCharSequence();
    private CharSequence underlying;

    public static ColumnName singleton(CharSequence that) {
        ColumnName cn = (ColumnName)SINGLETON.get();
        cn.of(that);
        return cn;
    }

    public CharSequence alias() {
        return this.alias;
    }

    @Override
    public int hashCode() {
        return Chars.hashCode(this.underlying);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnName)) {
            return false;
        }
        ColumnName that = (ColumnName)obj;
        return Chars.equals((CharSequence)this.alias, that.alias()) && Chars.equals((CharSequence)this.name, that.name());
    }

    public boolean isNull() {
        return this.alias.length() == 0 && this.name.length() == 0;
    }

    @Override
    public int length() {
        return this.underlying.length();
    }

    @Override
    public char charAt(int index) {
        return this.underlying.charAt(index);
    }

    public CharSequence name() {
        return this.name;
    }

    @Override
    @NotNull
    public String toString() {
        return this.underlying == null ? "null" : this.underlying.toString();
    }

    private void of(CharSequence that) {
        this.underlying = that;
        int dot = Chars.indexOf(that, '.');
        if (dot == -1) {
            this.alias.of(null, 0, 0);
            this.name.of(that, 0, that.length());
        } else {
            this.alias.of(that, 0, dot);
            this.name.of(that, dot + 1, that.length() - dot - 1);
        }
    }
}

