/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.ex.JournalConfigurationException;
import com.questdb.std.ObjObjHashMap;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalConfigurationImpl;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalMetadataBuilder;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JournalConfigurationBuilder {
    private final List<MetadataBuilder> builders = new ArrayList<MetadataBuilder>();

    public <T> JournalMetadataBuilder<T> $(Class<T> clazz) {
        JournalMetadataBuilder<T> builder = new JournalMetadataBuilder<T>(clazz);
        this.builders.add(builder);
        return builder;
    }

    public <T> JournalMetadataBuilder<T> $(Class<T> clazz, String name) {
        JournalMetadataBuilder<T> builder = new JournalMetadataBuilder<T>(clazz, name);
        this.builders.add(builder);
        return builder;
    }

    public JournalStructure $(String name) {
        JournalStructure builder = new JournalStructure(name);
        this.builders.add(builder);
        return builder;
    }

    public JournalConfiguration build(String journalBase) {
        return this.build(new File(journalBase));
    }

    public JournalConfiguration build(File journalBase) {
        if (!journalBase.isDirectory()) {
            throw new JournalConfigurationException("Not a directory: %s", journalBase);
        }
        if (!journalBase.canRead()) {
            throw new JournalConfigurationException("Not readable: %s", journalBase);
        }
        ObjObjHashMap<String, JournalMetadata> metadata = new ObjObjHashMap<String, JournalMetadata>(this.builders.size());
        int sz = this.builders.size();
        for (int i = 0; i < sz; ++i) {
            JournalMetadata meta = this.builders.get(i).build();
            metadata.put(meta.getModelClassName(), meta);
        }
        return new JournalConfigurationImpl(journalBase, metadata);
    }
}

