/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.ex.JournalDoesNotExistException;
import com.questdb.ex.JournalMetadataException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.ObjObjHashMap;
import com.questdb.std.ThreadLocal;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.Path;
import com.questdb.store.JournalKey;
import com.questdb.store.UnstructuredFile;
import com.questdb.store.factory.configuration.JournalConfiguration;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalMetadataBuilder;
import com.questdb.store.factory.configuration.JournalStructure;
import java.io.File;

class JournalConfigurationImpl
implements JournalConfiguration {
    private static final Log LOG = LogFactory.getLog(JournalConfigurationImpl.class);
    private static final ThreadLocal<Path> tlPath = new ThreadLocal<Path>(Path::new);
    private final ObjObjHashMap<String, JournalMetadata> journalMetadata;
    private final File journalBase;

    JournalConfigurationImpl(File journalBase, ObjObjHashMap<String, JournalMetadata> journalMetadata) {
        this.journalBase = journalBase;
        this.journalMetadata = journalMetadata;
    }

    @Override
    public <T> JournalMetadata<T> createMetadata(JournalKey<T> key) throws JournalException {
        JournalMetadata mn;
        JournalMetadata<T> mo = this.readMetadata(key.getName());
        String className = key.getModelClassName();
        JournalMetadata journalMetadata = mn = className == null ? null : this.journalMetadata.get(className);
        if (mo == null) {
            if (mn == null && key.getModelClass() == null) {
                LOG.error().$("Journal does not exist: ").$(key.getName()).$();
                throw JournalDoesNotExistException.INSTANCE;
            }
            if (mn == null) {
                return ((JournalMetadataBuilder)((JournalMetadataBuilder)((JournalMetadataBuilder)new JournalMetadataBuilder<T>(key.getModelClass(), key.getName()).partitionBy(key.getPartitionBy())).recordCountHint(key.getRecordHint())).ordered(key.isOrdered())).build();
            }
            return new JournalStructure(mn, key.getName()).partitionBy(key.getPartitionBy()).recordCountHint(key.getRecordHint()).ordered(key.isOrdered()).map(key.getModelClass());
        }
        if (mn == null || mn.isCompatible(mo, false)) {
            return new JournalStructure(mo, key.getName()).recordCountHint(key.getRecordHint()).map(key.getModelClass());
        }
        throw new JournalMetadataException(mo, mn);
    }

    @Override
    public int exists(CharSequence location) {
        String base;
        Path path = (Path)tlPath.get();
        if (!Files.exists(path.of(base = this.getJournalBase().getAbsolutePath()).concat(location).$())) {
            return 2;
        }
        if (Files.exists(path.of(base).concat(location).concat("_tx").$()) && Files.exists(path.of(base).concat(location).concat("_meta2").$())) {
            return 1;
        }
        return 4;
    }

    @Override
    public File getJournalBase() {
        return this.journalBase;
    }

    @Override
    public <T> JournalMetadata<T> readMetadata(String name) throws JournalException {
        File dir = new File(this.getJournalBase(), name);
        if (dir.exists()) {
            File metaFile = new File(dir, "_meta2");
            if (!metaFile.exists()) {
                throw new JournalException(dir + " is not a recognised journal", new Object[0]);
            }
            try (UnstructuredFile hb = new UnstructuredFile(metaFile, 12, 0);){
                JournalMetadata journalMetadata = new JournalMetadata(hb, name);
                return journalMetadata;
            }
        }
        return null;
    }

    @Override
    public void releaseThreadLocals() {
        Misc.free(tlPath.get());
        tlPath.remove();
    }
}

