/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.PartitionBy;
import com.questdb.ex.JournalConfigurationException;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalKey;
import com.questdb.store.UnstructuredFile;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.ColumnName;
import java.lang.reflect.Constructor;

public class JournalMetadata<T>
extends AbstractRecordMetadata {
    private static final int TO_STRING_COL1_PAD = 20;
    private static final int TO_STRING_COL2_PAD = 55;
    private final String name;
    private final Class<T> modelClass;
    private final int partitionBy;
    private final int columnCount;
    private final ColumnMetadata timestampMetadata;
    private final Constructor<T> constructor;
    private final long openFileTTL;
    private final int ioBlockRecordCount;
    private final int ioBlockTxCount;
    private final String keyColumn;
    private final ColumnMetadata[] columnMetadata;
    private final CharSequenceIntHashMap columnIndexLookup;
    private final int timestampColumnIndex;
    private final int lag;
    private final boolean partialMapping;
    private final JournalKey<T> key;
    private final boolean ordered;

    public JournalMetadata(String name, Class<T> modelClass, Constructor<T> constructor, String keyColumn, int partitionBy, ColumnMetadata[] columnMetadata, int timestampColumnIndex, long openFileTTL, int ioBlockRecordCount, int ioBlockTxCount, int lag, boolean partialMapping, boolean ordered) {
        this.name = name;
        this.modelClass = modelClass;
        this.partitionBy = partitionBy;
        this.columnMetadata = new ColumnMetadata[columnMetadata.length];
        System.arraycopy(columnMetadata, 0, this.columnMetadata, 0, columnMetadata.length);
        this.columnCount = columnMetadata.length;
        this.timestampMetadata = timestampColumnIndex > -1 ? columnMetadata[timestampColumnIndex] : null;
        this.timestampColumnIndex = timestampColumnIndex;
        this.constructor = constructor;
        this.openFileTTL = openFileTTL;
        this.ioBlockRecordCount = ioBlockRecordCount;
        this.ioBlockTxCount = ioBlockTxCount;
        this.keyColumn = keyColumn;
        this.columnIndexLookup = new CharSequenceIntHashMap(this.columnCount);
        for (int i = 0; i < columnMetadata.length; ++i) {
            this.columnIndexLookup.put(columnMetadata[i].name, i);
        }
        this.lag = lag;
        this.partialMapping = partialMapping;
        this.key = new JournalKey<T>(modelClass, name, partitionBy, ioBlockRecordCount, ordered);
        this.ordered = ordered;
    }

    public JournalMetadata(UnstructuredFile buf, String name) {
        buf.setPos(0L);
        String oldName = buf.getStr();
        this.name = name == null ? oldName : name;
        this.modelClass = null;
        this.partitionBy = buf.getInt();
        this.columnCount = buf.getInt();
        this.timestampColumnIndex = buf.getInt();
        this.columnMetadata = new ColumnMetadata[this.columnCount];
        this.columnIndexLookup = new CharSequenceIntHashMap();
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnMetadata[i] = new ColumnMetadata();
            this.columnMetadata[i].read(buf);
            this.columnIndexLookup.put(this.columnMetadata[i].name, i);
        }
        this.timestampMetadata = this.timestampColumnIndex > -1 ? this.columnMetadata[this.timestampColumnIndex] : null;
        this.openFileTTL = buf.getLong();
        this.ioBlockRecordCount = buf.getInt();
        this.ioBlockTxCount = buf.getInt();
        this.keyColumn = buf.getStr();
        this.lag = buf.getInt();
        this.ordered = buf.getBool();
        this.constructor = null;
        this.partialMapping = false;
        this.key = new JournalKey(null, this.name, this.partitionBy, this.ioBlockRecordCount, this.ordered);
    }

    public void copyColumnMetadata(ColumnMetadata[] meta) {
        if (meta.length != this.columnCount) {
            throw new JournalRuntimeException("Invalid length for column metadata array", new Object[0]);
        }
        System.arraycopy(this.columnMetadata, 0, meta, 0, meta.length);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        int index = this.columnIndexLookup.get(name);
        if (index > -1) {
            return index;
        }
        if (this.getAlias() == null) {
            return -1;
        }
        ColumnName columnName = ColumnName.singleton(name);
        if (columnName.alias().length() == 0) {
            return -1;
        }
        if (Chars.equals(columnName.alias(), this.getAlias())) {
            return this.columnIndexLookup.get(columnName.name());
        }
        return -1;
    }

    @Override
    public ColumnMetadata getColumnQuick(int index) {
        return Unsafe.arrayGet(this.columnMetadata, index);
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampColumnIndex;
    }

    public JournalKey<T> getKey() {
        return this.key;
    }

    public String getKeyColumn() {
        if (this.keyColumn == null) {
            throw new JournalConfigurationException(this.modelClass.getName() + " does not have a keyColumn");
        }
        return this.keyColumn;
    }

    public String getKeyQuiet() {
        return this.keyColumn;
    }

    public int getLag() {
        return this.lag;
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }

    public String getModelClassName() {
        return this.modelClass == null ? null : this.modelClass.getName();
    }

    public String getName() {
        return this.name;
    }

    public long getOpenFileTTL() {
        return this.openFileTTL;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getRecordHint() {
        return this.ioBlockRecordCount;
    }

    public ColumnMetadata getTimestampMetadata() {
        return this.timestampMetadata;
    }

    public int getTxCountHint() {
        return this.ioBlockTxCount;
    }

    public boolean isCompatible(JournalMetadata that, boolean ignorePartitionType) {
        if (that == null || this.getPartitionBy() != that.getPartitionBy() && !ignorePartitionType || this.getColumnCount() != that.getColumnCount()) {
            return false;
        }
        int k = this.getColumnCount();
        for (int i = 0; i < k; ++i) {
            ColumnMetadata thisM = this.getColumnQuick(i);
            ColumnMetadata thatM = that.getColumnQuick(i);
            if (thisM.name.equals(thatM.name) && thisM.type == thatM.type && thisM.size == thatM.size && thisM.distinctCountHint == thatM.distinctCountHint && thisM.indexed == thatM.indexed && (thisM.sameAs != null || thatM.sameAs == null) && (thisM.sameAs == null || thisM.sameAs.equals(thatM.sameAs))) continue;
            return false;
        }
        return true;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isPartialMapped() {
        return this.partialMapping;
    }

    public Object newObject() {
        if (this.constructor == null) {
            throw new JournalRuntimeException("There is no object class associated with this journal. Please use generic access methods", new Object[0]);
        }
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JournalRuntimeException("Could not create instance of class: " + this.modelClass.getName(), (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalBuilder();
        JournalMetadata.sep(b);
        b.put('|');
        JournalMetadata.pad(b, 20, "Name:");
        JournalMetadata.pad(b, 55, this.name).put('\n');
        b.put('|');
        JournalMetadata.pad(b, 20, "Partition by");
        JournalMetadata.pad(b, 55, PartitionBy.toString(this.partitionBy)).put('\n');
        JournalMetadata.sep(b);
        for (int i = 0; i < this.columnCount; ++i) {
            b.put('|');
            JournalMetadata.pad(b, 20, Integer.toString(i));
            this.col(b, this.columnMetadata[i]);
            b.put('\n');
        }
        JournalMetadata.sep(b);
        return ((Object)b).toString();
    }

    public void write(UnstructuredFile buf) {
        buf.setPos(0L);
        buf.put(this.name);
        buf.put(this.partitionBy);
        buf.put(this.columnCount);
        buf.put(this.timestampColumnIndex);
        for (int i = 0; i < this.columnMetadata.length; ++i) {
            this.columnMetadata[i].write(buf);
        }
        buf.put(this.openFileTTL);
        buf.put(this.ioBlockRecordCount);
        buf.put(this.ioBlockTxCount);
        buf.put(this.keyColumn);
        buf.put(this.lag);
        buf.put(this.ordered);
        buf.setAppendOffset(buf.getPos());
    }

    private static CharSink pad(CharSink b, int w, String value) {
        int pad = value == null ? w : w - value.length();
        for (int i = 0; i < pad; ++i) {
            b.put(' ');
        }
        if (value != null) {
            if (pad < 0) {
                b.put("...").put(value.substring(-pad + 3));
            } else {
                b.put(value);
            }
        }
        b.put("  |");
        return b;
    }

    private static void sep(CharSink b) {
        b.put('+');
        for (int i = 0; i < 80; ++i) {
            b.put('-');
        }
        b.put("+\n");
    }

    private void col(CharSink b, ColumnMetadata m) {
        JournalMetadata.pad(b, 55, (m.distinctCountHint > 0 ? m.distinctCountHint + " ~ " : "") + (m.indexed ? Character.valueOf('#') : "") + m.name + (m.sameAs != null ? " -> " + m.sameAs : "") + ' ' + ColumnType.nameOf(m.type) + '(' + m.size + ')');
    }
}

