/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.common.ColumnType;
import com.questdb.ex.JournalConfigurationException;
import com.questdb.std.ByteBuffers;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Numbers;
import com.questdb.std.ObjObjHashMap;
import com.questdb.std.Unsafe;
import com.questdb.store.factory.configuration.BinaryBuilder;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.IntBuilder;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.store.factory.configuration.StringBuilder;
import com.questdb.store.factory.configuration.SymbolBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JournalMetadataBuilder<T>
implements MetadataBuilder<T> {
    private final ObjObjHashMap<String, ColumnMetadata> columnMetadata = new ObjObjHashMap();
    private final Class<T> modelClass;
    private final String name;
    private Constructor<T> constructor;
    private CharSequenceIntHashMap nameToIndexMap;
    private int tsColumnIndex = -1;
    private int partitionBy = 3;
    private int recordCountHint = 100000;
    private int txCountHint = -1;
    private String keyColumn;
    private long openFileTTL = TimeUnit.MINUTES.toMillis(3L);
    private int lag = -1;
    private boolean ordered = true;

    public JournalMetadataBuilder(Class<T> modelClass) {
        this(modelClass, modelClass.getCanonicalName());
    }

    public JournalMetadataBuilder(Class<T> modelClass, String name) {
        this.modelClass = modelClass;
        this.name = name;
        this.parseClass();
    }

    public JournalMetadataBuilder(JournalMetadata<T> model, String name) {
        this(model.getModelClass(), name);
        this.tsColumnIndex = model.getTimestampIndex();
        this.partitionBy = model.getPartitionBy();
        this.recordCountHint = model.getRecordHint();
        this.txCountHint = model.getTxCountHint();
        this.keyColumn = model.getKeyQuiet();
        this.openFileTTL = model.getOpenFileTTL();
        this.lag = model.getLag();
        int n = model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnMetadata from = model.getColumnQuick(i);
            this.columnMetadata.get(from.name).copy(from);
        }
        this.ordered = model.isOrdered();
    }

    public BinaryBuilder<T> $bin(String name) {
        return new BinaryBuilder(this, this.getMeta(name));
    }

    public JournalMetadataBuilder<T> $date(String name) {
        this.getMeta((String)name).type = 10;
        return this;
    }

    public IntBuilder<T> $int(String name) {
        return new IntBuilder(this, this.getMeta(name));
    }

    public StringBuilder<T> $str(String name) {
        return new StringBuilder(this, this.getMeta(name));
    }

    public SymbolBuilder<T> $sym(String name) {
        return new SymbolBuilder(this, this.getMeta(name));
    }

    public JournalMetadataBuilder<T> $ts() {
        return this.$ts("timestamp");
    }

    public JournalMetadataBuilder<T> $ts(String name) {
        this.tsColumnIndex = this.nameToIndexMap.get(name);
        if (this.tsColumnIndex == -1) {
            throw new JournalConfigurationException("Invalid column name: %s", name);
        }
        this.getMeta((String)name).type = 10;
        return this;
    }

    @Override
    public JournalMetadata<T> build() {
        if (this.txCountHint == -1) {
            this.txCountHint = (int)((double)this.recordCountHint * 0.1);
        }
        ColumnMetadata[] metadata = new ColumnMetadata[this.nameToIndexMap.size()];
        for (ObjObjHashMap.Entry<String, ColumnMetadata> e : this.columnMetadata.immutableIterator()) {
            int index = this.nameToIndexMap.get((CharSequence)e.key);
            ColumnMetadata meta = (ColumnMetadata)e.value;
            if (meta.indexed && meta.distinctCountHint < 2) {
                meta.distinctCountHint = Numbers.ceilPow2(Math.max(2, (int)((double)this.recordCountHint * 0.01))) - 1;
            }
            if (meta.size == 0 && meta.avgSize == 0) {
                throw new JournalConfigurationException("Invalid size for column %s.%s", this.modelClass.getName(), meta.name);
            }
            if (meta.distinctCountHint < 1 && meta.type == 8) {
                meta.distinctCountHint = Numbers.ceilPow2((int)((double)this.recordCountHint * 0.2)) - 1;
            }
            switch (meta.type) {
                case 7: {
                    meta.size = meta.avgSize + 4;
                    meta.bitHint = ByteBuffers.getBitHint(meta.avgSize * 2, this.recordCountHint);
                    meta.indexBitHint = ByteBuffers.getBitHint(8, this.recordCountHint);
                    break;
                }
                case 9: {
                    meta.size = meta.avgSize;
                    meta.bitHint = ByteBuffers.getBitHint(meta.avgSize, this.recordCountHint);
                    meta.indexBitHint = ByteBuffers.getBitHint(8, this.recordCountHint);
                    break;
                }
                default: {
                    meta.bitHint = ByteBuffers.getBitHint(meta.size, this.recordCountHint);
                }
            }
            metadata[index] = meta;
        }
        return new JournalMetadata<T>(this.name, this.modelClass, this.constructor, this.keyColumn, this.partitionBy, metadata, this.tsColumnIndex, this.openFileTTL, this.recordCountHint, this.txCountHint, this.lag, false, this.ordered);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JournalMetadataBuilder<T> ordered(boolean flag) {
        this.ordered = flag;
        return this;
    }

    @Override
    public JournalMetadataBuilder<T> partitionBy(int partitionBy) {
        if (partitionBy != 4) {
            this.partitionBy = partitionBy;
        }
        return this;
    }

    @Override
    public JournalMetadataBuilder<T> recordCountHint(int count) {
        if (count > 0) {
            this.recordCountHint = count;
        }
        return this;
    }

    public JournalMetadataBuilder<T> keyColumn(String key) {
        this.keyColumn = key;
        return this;
    }

    public JournalMetadataBuilder<T> lag(long time, TimeUnit unit) {
        this.lag = (int)unit.toHours(time);
        return this;
    }

    public JournalMetadataBuilder<T> openFileTTL(long time, TimeUnit unit) {
        this.openFileTTL = unit.toMillis(time);
        return this;
    }

    public JournalMetadataBuilder<T> txCountHint(int count) {
        this.txCountHint = count;
        return this;
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        return type.getSuperclass() != null ? this.getAllFields(fields, type.getSuperclass()) : fields;
    }

    private ColumnMetadata getMeta(String name) {
        ColumnMetadata meta = this.columnMetadata.get(name);
        if (meta == null) {
            throw new JournalConfigurationException("No such column: %s", name);
        }
        return meta;
    }

    private void parseClass() throws JournalConfigurationException {
        try {
            this.constructor = this.modelClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new JournalConfigurationException("No default constructor declared on %s", this.modelClass.getName());
        }
        List<Field> classFields = this.getAllFields(new ArrayList<Field>(), this.modelClass);
        this.nameToIndexMap = new CharSequenceIntHashMap(classFields.size());
        for (int i = 0; i < classFields.size(); ++i) {
            int columnType;
            Field f = classFields.get(i);
            if (Modifier.isStatic(f.getModifiers()) || (columnType = ColumnType.columnTypeOf(f.getType())) == -1) continue;
            ColumnMetadata meta = new ColumnMetadata();
            meta.type = columnType;
            meta.size = ColumnType.sizeOf(columnType);
            meta.offset = Unsafe.getUnsafe().objectFieldOffset(f);
            meta.name = f.getName();
            this.columnMetadata.put(meta.name, meta);
            this.nameToIndexMap.put(meta.name, this.nameToIndexMap.size());
        }
    }
}

